/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.mongo.packageresolver.linux.AmazonPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.CentosRedhatPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.DebianPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.LinuxMintPackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.linux.UbuntuPackageResolver;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.ImmutablePlatform;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.AmazonVersion;
import de.flapdoodle.os.linux.CentosVersion;
import de.flapdoodle.os.linux.DebianVersion;
import de.flapdoodle.os.linux.LinuxMintVersion;
import de.flapdoodle.os.linux.OracleVersion;
import de.flapdoodle.os.linux.RedhatVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxPackageFinder
implements PackageFinder,
HasPlatformMatchRules {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinuxPackageFinder.class);
    private final Command command;
    private final ImmutablePackageFinderRules rules;

    public LinuxPackageFinder(Command command) {
        this.command = command;
        this.rules = LinuxPackageFinder.rules(command);
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public Optional<Package> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        UbuntuPackageResolver ubuntuPackageResolver = new UbuntuPackageResolver(command);
        ImmutablePackageFinderRule ubuntuRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])UbuntuVersion.values())).finder(ubuntuPackageResolver).build();
        ImmutablePackageFinderRule linuxMintRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])LinuxMintVersion.values())).finder(new LinuxMintPackageResolver(ubuntuPackageResolver)).build();
        ImmutablePackageFinderRule debianRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])DebianVersion.values())).finder(new DebianPackageResolver(command)).build();
        CentosRedhatPackageResolver centosRedhatPackageResolver = new CentosRedhatPackageResolver(command);
        List centosRedhatAndOracleVersions = Stream.of(Stream.of(CentosVersion.values()), Stream.of(RedhatVersion.values()), Stream.of(OracleVersion.values())).flatMap(it -> it).collect(Collectors.toList());
        ImmutablePackageFinderRule centosRedhatOracleRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion(centosRedhatAndOracleVersions)).finder(centosRedhatPackageResolver).build();
        ImmutablePackageFinderRule amazonRule = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withVersion((Version[])AmazonVersion.values())).finder(new AmazonPackageResolver(command)).build();
        ImmutablePackageFinderRule legacy32 = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withBitSize(BitSize.B32).andThen(DistributionMatch.any(VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15"), VersionRange.of("2.6.0", "2.6.12")))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-i686-{version}.tgz").build()).build();
        ImmutablePackageFinderRule legacy64 = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withBitSize(BitSize.B64).andThen(DistributionMatch.any(VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.0", "3.6.23"), VersionRange.of("3.4.9", "3.4.24"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15"), VersionRange.of("2.6.0", "2.6.12")))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-{version}.tgz").build()).build();
        ImmutablePackageFinderRule hiddenLegacy64 = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withBitSize(BitSize.B64).andThen(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-{version}.tgz").build()).build();
        ImmutablePackageFinderRule hiddenLegacy32 = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux).withBitSize(BitSize.B32).andThen(DistributionMatch.any(VersionRange.of("3.3.1", "3.3.1"), VersionRange.of("3.5.5", "3.5.5")))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-i686-{version}.tgz").build()).build();
        ImmutablePackageFinderRule failIfNothingMatches = PackageFinderRule.builder().match(PlatformMatch.withOs((OS)CommonOS.Linux)).finder(new FallbackToUbuntuOrFailPackageFinder(ubuntuPackageResolver)).build();
        return PackageFinderRules.empty().withRules(ubuntuRule, linuxMintRule, debianRule, centosRedhatOracleRule, amazonRule, legacy64, legacy32, hiddenLegacy64, hiddenLegacy32, failIfNothingMatches);
    }

    static class FallbackToUbuntuOrFailPackageFinder
    implements PackageFinder,
    HasExplanation {
        private final UbuntuPackageResolver ubuntuPackageResolver;
        private final UbuntuVersion fallbackUbuntuVersion = UbuntuVersion.Ubuntu_20_04;

        public FallbackToUbuntuOrFailPackageFinder(UbuntuPackageResolver ubuntuPackageResolver) {
            this.ubuntuPackageResolver = ubuntuPackageResolver;
        }

        @Override
        public Optional<Package> packageFor(Distribution distribution) {
            if (distribution.platform().distribution().isPresent()) {
                return Optional.empty();
            }
            Distribution ubuntuLTSFallback = Distribution.of((de.flapdoodle.embed.process.distribution.Version)distribution.version(), (Platform)ImmutablePlatform.copyOf((Platform)distribution.platform()).withVersion((Version)this.fallbackUbuntuVersion));
            LOGGER.warn("because there is no package for " + distribution + " we fall back to " + ubuntuLTSFallback);
            Optional<Package> resolvedPackage = this.ubuntuPackageResolver.packageFor(ubuntuLTSFallback);
            if (!resolvedPackage.isPresent()) {
                throw new IllegalArgumentException("linux distribution not supported: " + distribution + "(with fallback to " + ubuntuLTSFallback + ")");
            }
            return resolvedPackage;
        }

        @Override
        public String explain() {
            return "fallback to " + this.fallbackUbuntuVersion;
        }
    }
}

