/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;

public class Paths
implements IPackageResolver {
    private final Command command;

    public Paths(Command command) {
        this.command = command;
    }

    public FileSet getFileSet(Distribution distribution) {
        String executableFileName;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                executableFileName = this.command.commandName();
                break;
            }
            case Windows: {
                executableFileName = this.command.commandName() + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return FileSet.builder().addEntry(FileType.Executable, executableFileName).build();
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: 
            case Solaris: 
            case FreeBSD: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String versionStr = Paths.getVersionPart(distribution.getVersion());
        if (distribution.getPlatform() == Platform.Solaris && Paths.isFeatureEnabled(distribution, Feature.NO_SOLARIS_SUPPORT)) {
            throw new IllegalArgumentException("Mongodb for solaris is not available anymore");
        }
        ArchiveType archiveType = this.getArchiveType(distribution);
        String archiveTypeStr = this.getArchiveString(archiveType);
        String platformStr = this.getPlattformString(distribution);
        String bitSizeStr = this.getBitSize(distribution);
        if (distribution.getBitsize() == BitSize.B64 && distribution.getPlatform() == Platform.Windows) {
            versionStr = (this.useWindows2008PlusVersion(distribution) ? "2008plus-" : "") + (this.withSsl(distribution) ? "ssl-" : "") + versionStr;
        }
        if (distribution.getPlatform() == Platform.OS_X && this.withSsl(distribution)) {
            return platformStr + "/mongodb-" + platformStr + "-ssl-" + bitSizeStr + "-" + versionStr + "." + archiveTypeStr;
        }
        return platformStr + "/mongodb-" + platformStr + "-" + bitSizeStr + "-" + versionStr + "." + archiveTypeStr;
    }

    private String getArchiveString(ArchiveType archiveType) {
        String sarchiveType;
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tgz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        return sarchiveType;
    }

    private String getPlattformString(Distribution distribution) {
        String splatform;
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "win32";
                break;
            }
            case OS_X: {
                splatform = "osx";
                break;
            }
            case Solaris: {
                splatform = "sunos5";
                break;
            }
            case FreeBSD: {
                splatform = "freebsd";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return splatform;
    }

    private String getBitSize(Distribution distribution) {
        String sbitSize;
        block0 : switch (distribution.getBitsize()) {
            case B32: {
                IFeatureAwareVersion featuredVersion;
                if (distribution.getVersion() instanceof IFeatureAwareVersion && (featuredVersion = (IFeatureAwareVersion)distribution.getVersion()).enabled(Feature.ONLY_64BIT)) {
                    throw new IllegalArgumentException("this version does not support 32Bit: " + distribution);
                }
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "i686";
                        break block0;
                    }
                    case Windows: {
                        sbitSize = "i386";
                        break block0;
                    }
                    case OS_X: {
                        sbitSize = "i386";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Platform " + distribution.getPlatform() + " not supported yet on 32Bit Platform");
            }
            case B64: {
                sbitSize = "x86_64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + distribution.getBitsize());
            }
        }
        return sbitSize;
    }

    protected boolean useWindows2008PlusVersion(Distribution distribution) {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows Server 2008 R2") || distribution.getVersion() instanceof IFeatureAwareVersion && ((IFeatureAwareVersion)distribution.getVersion()).enabled(Feature.ONLY_WINDOWS_2008_SERVER)) {
            return true;
        }
        return osName.contains("Windows 7");
    }

    protected boolean withSsl(Distribution distribution) {
        if ((distribution.getPlatform() == Platform.Windows || distribution.getPlatform() == Platform.OS_X) && distribution.getVersion() instanceof IFeatureAwareVersion) {
            return ((IFeatureAwareVersion)distribution.getVersion()).enabled(Feature.ONLY_WITH_SSL);
        }
        return false;
    }

    private static boolean isFeatureEnabled(Distribution distribution, Feature feature) {
        return distribution.getVersion() instanceof IFeatureAwareVersion && ((IFeatureAwareVersion)distribution.getVersion()).enabled(feature);
    }

    protected static String getVersionPart(IVersion version) {
        return version.asInDownloadPath();
    }
}

