/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.distribution;

import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import java.util.EnumSet;

public enum Version implements IFeatureAwareVersion
{
    V1_6_5("1.6.5", new Feature[0]),
    V1_7_6("1.7.6", new Feature[0]),
    V1_8_0_rc0("1.8.0-rc0", new Feature[0]),
    V1_8_0("1.8.0", new Feature[0]),
    V1_8_1("1.8.1", new Feature[0]),
    V1_8_2_rc0("1.8.2-rc0", new Feature[0]),
    V1_8_2("1.8.2", new Feature[0]),
    V1_8_4("1.8.4", new Feature[0]),
    V1_8_5("1.8.5", new Feature[0]),
    V1_9_0("1.9.0", new Feature[0]),
    V2_0_1("2.0.1", new Feature[0]),
    V2_0_4("2.0.4", new Feature[0]),
    V2_0_5("2.0.5", new Feature[0]),
    V2_0_6("2.0.6", new Feature[0]),
    V2_0_7_RC1("2.0.7-rc1", new Feature[0]),
    V2_0_7("2.0.7", new Feature[0]),
    V2_0_8_RC0("2.0.8-rc0", new Feature[0]),
    V2_0_9("2.0.9", new Feature[0]),
    V2_1_0("2.1.0", new Feature[0]),
    V2_1_1("2.1.1", new Feature[0]),
    V2_1_2("2.1.2", new Feature[0]),
    V2_2_0_RC0("2.2.0-rc0", new Feature[0]),
    V2_2_0("2.2.0", new Feature[0]),
    V2_2_1("2.2.1", new Feature[0]),
    V2_2_3("2.2.3", new Feature[0]),
    V2_2_4("2.2.4", new Feature[0]),
    V2_2_5("2.2.5", new Feature[0]),
    V2_2_6("2.2.6", new Feature[0]),
    V2_2_7("2.2.7", new Feature[0]),
    V2_3_0("2.3.0", new Feature[0]),
    V2_4_0_RC3("2.4.0-rc3", new Feature[0]),
    V2_4_0("2.4.0", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_1("2.4.1", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_2("2.4.2", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_3("2.4.3", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_5("2.4.5", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_6("2.4.6", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_7("2.4.7", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_8("2.4.8", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_9("2.4.9", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_4_10("2.4.10", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_5_0("2.5.0", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_5_1("2.5.1", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_5_3("2.5.3", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_5_4("2.5.4", Feature.SYNC_DELAY, Feature.TEXT_SEARCH),
    V2_6_0("2.6.0", Feature.SYNC_DELAY),
    V2_6_1("2.6.1", Feature.SYNC_DELAY),
    V2_6_8("2.6.8", Feature.SYNC_DELAY),
    V2_6_10("2.6.10", Feature.SYNC_DELAY),
    V2_6_11("2.6.11", Feature.SYNC_DELAY),
    V2_7_0("2.7.0", Feature.SYNC_DELAY),
    V2_7_1("2.7.1", Feature.SYNC_DELAY),
    V3_0_0("3.0.0", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_1("3.0.1", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_2("3.0.2", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_4("3.0.4", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_5("3.0.5", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_6("3.0.6", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_7("3.0.7", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_0_8("3.0.8", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_1_0("3.1.0", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_1_5("3.1.5", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_1_6("3.1.6", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_2_0("3.2.0", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_2_1_RC3("3.2.1-rc3", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_2_1("3.2.1", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_2_20("3.2.20", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_3_1("3.3.1", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE),
    V3_4_3("3.4.3", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE),
    V3_4_5("3.4.5", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE),
    V3_4_15("3.4.15", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_SOLARIS_SUPPORT),
    V3_5_5("3.5.5", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE),
    V3_6_0("3.6.0", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V3_6_2("3.6.2", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V3_6_3("3.6.3", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V3_6_5("3.6.5", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V4_0_2("4.0.2", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V4_0_12("4.0.12", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    V4_4_1("4.4.1", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST),
    LATEST_NIGHTLY("latest", Feature.SYNC_DELAY, Feature.STORAGE_ENGINE, Feature.ONLY_64BIT, Feature.NO_CHUNKSIZE_ARG, Feature.MONGOS_CONFIGDB_SET_STYLE, Feature.NO_HTTP_INTERFACE_ARG, Feature.ONLY_WITH_SSL, Feature.ONLY_WINDOWS_2008_SERVER, Feature.NO_SOLARIS_SUPPORT, Feature.NO_BIND_IP_TO_LOCALHOST);

    private final String specificVersion;
    private EnumSet<Feature> features;

    private Version(String vName, Feature ... features) {
        this.specificVersion = vName;
        this.features = Feature.asSet(features);
    }

    public String asInDownloadPath() {
        return this.specificVersion;
    }

    @Override
    public boolean enabled(Feature feature) {
        return this.features.contains((Object)feature);
    }

    @Override
    public EnumSet<Feature> getFeatures() {
        return EnumSet.copyOf(this.features);
    }

    public String toString() {
        return "Version{" + this.specificVersion + '}';
    }

    public static enum Main implements IFeatureAwareVersion
    {
        V1_8(V1_8_5),
        V2_0(V2_0_9),
        V2_1(V2_1_2),
        V2_2(V2_2_7),
        V2_3(V2_3_0),
        V2_4(V2_4_10),
        V2_5(V2_5_4),
        V2_6(V2_6_11),
        V2_7(V2_7_1),
        V3_0(V3_0_8),
        V3_1(V3_1_6),
        V3_2(V3_2_20),
        V3_3(V3_3_1),
        V3_4(V3_4_15),
        V3_5(V3_5_5),
        V3_6(V3_6_5),
        V4_0(V4_0_12),
        LEGACY(V3_6),
        PRODUCTION(V4_0),
        DEVELOPMENT(V4_0);

        private final IFeatureAwareVersion _latest;

        private Main(IFeatureAwareVersion latest) {
            this._latest = latest;
        }

        public String asInDownloadPath() {
            return this._latest.asInDownloadPath();
        }

        @Override
        public boolean enabled(Feature feature) {
            return this._latest.enabled(feature);
        }

        @Override
        public EnumSet<Feature> getFeatures() {
            return this._latest.getFeatures();
        }
    }
}

