/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.CentosVersion;
import java.util.Optional;

public class CentosPackageResolver
implements PackageFinder {
    private final Command command;
    private final ImmutablePlatformMatchRules rules;

    public CentosPackageResolver(Command command) {
        this.command = command;
        this.rules = CentosPackageResolver.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        ImmutablePlatformMatchRule centos6 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_6}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-rhel62-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule tools_centos6 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_6}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-rhel62-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule centos7 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_7}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-rhel70-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule tools_centos7 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_7}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-rhel70-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule centos8 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.1", "4.2.3"), VersionRange.of("4.0.14", "4.0.26"), VersionRange.of("3.6.17", "3.6.22")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_8}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-rhel80-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule tools_centos8 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.1", "4.2.3"), VersionRange.of("4.0.14", "4.0.26"), VersionRange.of("3.6.17", "3.6.22")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{CentosVersion.CentOS_8}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-rhel80-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule centos8arm = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.ARM).withVersion(new Version[]{CentosVersion.CentOS_8}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-rhel82-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule tools_centos8arm = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.ARM).withVersion(new Version[]{CentosVersion.CentOS_8}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-rhel82-arm64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PlatformMatchRules.empty().withRules(tools_centos6, tools_centos7, tools_centos8, tools_centos8arm);
            }
        }
        return PlatformMatchRules.empty().withRules(centos6, centos7, centos8, centos8arm);
    }
}

