/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embed.mongo.packageresolver.PlatformPackageResolver;
import de.flapdoodle.embed.process.config.ImmutableRuntimeConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.store.DistributionDownloadPath;
import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.ImmutableDownloadConfig;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.NoopTempNaming;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.directories.UserHome;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.Slf4jProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import de.flapdoodle.embed.process.runtime.CommandLinePostProcessor;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.ExtractedArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableExtractedArtifactStore;
import de.flapdoodle.embed.process.store.UrlConnectionDownloader;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public abstract class Defaults {
    public static ImmutableExtractedArtifactStore extractedArtifactStoreFor(Command command) {
        return ExtractedArtifactStore.builder().downloadConfig((DownloadConfig)Defaults.downloadConfigFor(command).build()).downloader((Downloader)new UrlConnectionDownloader()).extraction((DirectoryAndExecutableNaming)DirectoryAndExecutableNaming.builder().directory((Directory)new UserHome(".embedmongo/extracted")).executableNaming((TempNaming)new NoopTempNaming()).build()).temp((DirectoryAndExecutableNaming)DirectoryAndExecutableNaming.builder().directory((Directory)new PropertyOrPlatformTempDir()).executableNaming((TempNaming)new UUIDTempNaming()).build()).build();
    }

    public static ImmutableDownloadConfig.Builder downloadConfigFor(Command command) {
        return DownloadConfigDefaults.defaultsForCommand(command);
    }

    public static ImmutableDownloadConfig.Builder downloadConfigDefaults() {
        return DownloadConfigDefaults.withDefaults();
    }

    public static ImmutableRuntimeConfig.Builder runtimeConfigFor(Command command, Logger logger) {
        return RuntimeConfigDefaults.defaultsWithLogger(command, logger);
    }

    public static ImmutableRuntimeConfig.Builder runtimeConfigFor(Command command) {
        return RuntimeConfigDefaults.defaults(command);
    }

    protected static class RuntimeConfigDefaults {
        protected RuntimeConfigDefaults() {
        }

        protected static ImmutableRuntimeConfig.Builder defaultsWithLogger(Command command, Logger logger) {
            ImmutableDownloadConfig downloadConfig = Defaults.downloadConfigFor(command).progressListener((ProgressListener)new Slf4jProgressListener(logger)).build();
            return RuntimeConfigDefaults.defaults(command).processOutput(MongodProcessOutputConfig.getInstance(command, logger)).artifactStore((IArtifactStore)Defaults.extractedArtifactStoreFor(command).withDownloadConfig((DownloadConfig)downloadConfig));
        }

        protected static ImmutableRuntimeConfig.Builder defaults(Command command) {
            return RuntimeConfig.builder().processOutput(MongodProcessOutputConfig.getDefaultInstance(command)).commandLinePostProcessor((CommandLinePostProcessor)new CommandLinePostProcessor.Noop()).artifactStore((IArtifactStore)Defaults.extractedArtifactStoreFor(command));
        }
    }

    protected static class DownloadConfigDefaults {
        protected DownloadConfigDefaults() {
        }

        protected static ImmutableDownloadConfig.Builder defaultsForCommand(Command command) {
            return DownloadConfigDefaults.withDefaults().packageResolver(DownloadConfigDefaults.packageResolver(command));
        }

        protected static ImmutableDownloadConfig.Builder withDefaults() {
            return DownloadConfig.builder().fileNaming((TempNaming)new UUIDTempNaming()).downloadPath((DistributionDownloadPath)new StaticDownloadPath()).progressListener((ProgressListener)new StandardConsoleProgressListener()).artifactStorePath(DownloadConfigDefaults.defaultArtifactStoreLocation()).downloadPrefix("embedmongo-download").userAgent("Mozilla/5.0 (compatible; Embedded MongoDB; +https://github.com/flapdoodle-oss/embedmongo.flapdoodle.de)");
        }

        public static PackageResolver packageResolver(Command command) {
            return new PlatformPackageResolver(command);
        }

        private static Directory defaultArtifactStoreLocation() {
            return DownloadConfigDefaults.defaultArtifactStoreLocation(System.getenv());
        }

        protected static Directory defaultArtifactStoreLocation(Map<String, String> env) {
            Optional<String> artifactStoreLocationEnvironmentVariable = Optional.ofNullable(env.get("EMBEDDED_MONGO_ARTIFACTS"));
            if (artifactStoreLocationEnvironmentVariable.isPresent()) {
                return new FixedPath(artifactStoreLocationEnvironmentVariable.get());
            }
            return new UserHome(".embedmongo");
        }

        private static class StaticDownloadPath
        implements DistributionDownloadPath {
            private StaticDownloadPath() {
            }

            public String getPath(Distribution distribution) {
                return "https://fastdl.mongodb.org";
            }
        }
    }
}

