/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.AmazonVersion;
import java.util.Optional;

public class AmazonPackageResolver
implements PackageFinder {
    private final ImmutablePlatformMatchRules rules;

    public AmazonPackageResolver(Command command) {
        this.rules = AmazonPackageResolver.rules(command);
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        ImmutablePlatformMatchRule amazon2Arm = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.4", "4.4.9"), VersionRange.of("4.2.13", "4.2.16")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.ARM).withVersion(new Version[]{AmazonVersion.AmazonLinux2}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule amazon2ArmTools = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.4", "4.4.9"), VersionRange.of("4.2.13", "4.2.16")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.ARM).withVersion(new Version[]{AmazonVersion.AmazonLinux2}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-arm64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule amazon2 = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.22", "3.6.22")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{AmazonVersion.AmazonLinux2}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule amazon2tools = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.22", "3.6.22")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{AmazonVersion.AmazonLinux2}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-x86_64-{tools.version}.tgz").build()).build();
        ImmutablePlatformMatchRule amazon = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{AmazonVersion.AmazonLinux}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule amazontools = PlatformMatchRule.builder().match(DistributionMatch.any(VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.26"), VersionRange.of("3.6.0", "3.6.22"), VersionRange.of("3.4.9", "3.4.23"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.21"), VersionRange.of("3.0.0", "3.0.14")).andThen(PlatformMatch.withOs(OS.Linux).withBitSize(BitSize.B64).withCpuType(CPUType.X86).withVersion(new Version[]{AmazonVersion.AmazonLinux}))).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PlatformMatchRules.empty().withRules(amazon2ArmTools, amazon2tools, amazontools);
            }
        }
        return PlatformMatchRules.empty().withRules(amazon2Arm, amazon2, amazon);
    }
}

