/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.ExplainRules;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.OSXPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.SolarisPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.WindowsPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.linux.LinuxPackageFinder;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.OS;
import java.util.Optional;

public class PlatformPackageResolver
implements PackageResolver,
HasPlatformMatchRules {
    private final Command command;
    private final PlatformMatchRules rules;

    public PlatformPackageResolver(Command command) {
        this.command = command;
        this.rules = PlatformMatchRules.empty().with(PlatformMatchRule.of(PlatformMatch.withOs(OS.Windows), new WindowsPackageFinder(command))).with(PlatformMatchRule.of(PlatformMatch.withOs(OS.OS_X), new OSXPackageFinder(command))).with(PlatformMatchRule.of(PlatformMatch.withOs(OS.Linux), new LinuxPackageFinder(command))).with(PlatformMatchRule.of(PlatformMatch.withOs(OS.Solaris), new SolarisPackageFinder(command)));
    }

    public DistributionPackage packageFor(Distribution distribution) {
        Optional<DistributionPackage> result = this.rules.packageFor(distribution);
        return result.orElseThrow(() -> {
            String message = "could not resolve package for " + distribution + System.lineSeparator() + "--------------" + System.lineSeparator() + this.explain();
            return new IllegalArgumentException(message);
        });
    }

    @Override
    public PlatformMatchRules rules() {
        return this.rules;
    }

    public String explain() {
        return ExplainRules.explain(this.rules);
    }
}

