/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRule;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.DebianVersion;
import java.util.Optional;

public class DebianPackageResolver
implements PackageFinder,
HasPlatformMatchRules {
    private final ImmutablePlatformMatchRules rules;

    public DebianPackageResolver(Command command) {
        this.rules = DebianPackageResolver.rules(command);
    }

    @Override
    public PlatformMatchRules rules() {
        return this.rules;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static PlatformMatch match(BitSize bitSize, CPUType cpuType, DebianVersion ... versions) {
        return PlatformMatch.withOs(OS.Linux).withBitSize(bitSize).withCpuType(cpuType).withVersion((Version[])versions);
    }

    private static ImmutablePlatformMatchRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        DistributionMatch debian9MongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.5"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.18"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.27"), VersionRange.of("3.6.5", "3.6.23"));
        ImmutablePlatformMatchRule debian9 = PlatformMatchRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_9).andThen(debian9MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian92-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule debian9tools = PlatformMatchRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_9).andThen(debian9MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian92-x86_64-{tools.version}.tgz").build()).build();
        DistributionMatch debian10MongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.5"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.18"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.1", "4.2.3"));
        ImmutablePlatformMatchRule debian10 = PlatformMatchRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_10).andThen(debian10MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-debian10-{version}.tgz").build()).build();
        ImmutablePlatformMatchRule debian10tools = PlatformMatchRule.builder().match(DebianPackageResolver.match(BitSize.B64, CPUType.X86, DebianVersion.DEBIAN_10).andThen(debian10MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-debian10-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PlatformMatchRules.empty().withRules(debian9tools, debian10tools);
            }
        }
        return PlatformMatchRules.empty().withRules(debian9, debian10);
    }
}

