package de.flapdoodle.embed.mongo.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoCmdOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoCmdOptions.builder()}.
 */
@Generated(from = "MongoCmdOptions", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoCmdOptions implements MongoCmdOptions {
  private final int syncDelay;
  private final boolean useDefaultSyncDelay;
  private final String storageEngine;
  private final boolean isVerbose;
  private final boolean useNoPrealloc;
  private final boolean useSmallFiles;
  private final boolean useNoJournal;
  private final boolean enableTextSearch;
  private final boolean auth;
  private final boolean master;

  private ImmutableMongoCmdOptions(ImmutableMongoCmdOptions.Builder builder) {
    this.storageEngine = builder.storageEngine;
    if (builder.syncDelayIsSet()) {
      initShim.syncDelay(builder.syncDelay);
    }
    if (builder.useDefaultSyncDelayIsSet()) {
      initShim.useDefaultSyncDelay(builder.useDefaultSyncDelay);
    }
    if (builder.isVerboseIsSet()) {
      initShim.isVerbose(builder.isVerbose);
    }
    if (builder.useNoPreallocIsSet()) {
      initShim.useNoPrealloc(builder.useNoPrealloc);
    }
    if (builder.useSmallFilesIsSet()) {
      initShim.useSmallFiles(builder.useSmallFiles);
    }
    if (builder.useNoJournalIsSet()) {
      initShim.useNoJournal(builder.useNoJournal);
    }
    if (builder.enableTextSearchIsSet()) {
      initShim.enableTextSearch(builder.enableTextSearch);
    }
    if (builder.authIsSet()) {
      initShim.auth(builder.auth);
    }
    if (builder.masterIsSet()) {
      initShim.master(builder.master);
    }
    this.syncDelay = initShim.syncDelay();
    this.useDefaultSyncDelay = initShim.useDefaultSyncDelay();
    this.isVerbose = initShim.isVerbose();
    this.useNoPrealloc = initShim.useNoPrealloc();
    this.useSmallFiles = initShim.useSmallFiles();
    this.useNoJournal = initShim.useNoJournal();
    this.enableTextSearch = initShim.enableTextSearch();
    this.auth = initShim.auth();
    this.master = initShim.master();
    this.initShim = null;
  }

  private ImmutableMongoCmdOptions(
      int syncDelay,
      boolean useDefaultSyncDelay,
      String storageEngine,
      boolean isVerbose,
      boolean useNoPrealloc,
      boolean useSmallFiles,
      boolean useNoJournal,
      boolean enableTextSearch,
      boolean auth,
      boolean master) {
    this.syncDelay = syncDelay;
    this.useDefaultSyncDelay = useDefaultSyncDelay;
    this.storageEngine = storageEngine;
    this.isVerbose = isVerbose;
    this.useNoPrealloc = useNoPrealloc;
    this.useSmallFiles = useSmallFiles;
    this.useNoJournal = useNoJournal;
    this.enableTextSearch = enableTextSearch;
    this.auth = auth;
    this.master = master;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoCmdOptions", generator = "Immutables")
  private final class InitShim {
    private byte syncDelayBuildStage = STAGE_UNINITIALIZED;
    private int syncDelay;

    int syncDelay() {
      if (syncDelayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (syncDelayBuildStage == STAGE_UNINITIALIZED) {
        syncDelayBuildStage = STAGE_INITIALIZING;
        this.syncDelay = syncDelayInitialize();
        syncDelayBuildStage = STAGE_INITIALIZED;
      }
      return this.syncDelay;
    }

    void syncDelay(int syncDelay) {
      this.syncDelay = syncDelay;
      syncDelayBuildStage = STAGE_INITIALIZED;
    }

    private byte useDefaultSyncDelayBuildStage = STAGE_UNINITIALIZED;
    private boolean useDefaultSyncDelay;

    boolean useDefaultSyncDelay() {
      if (useDefaultSyncDelayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useDefaultSyncDelayBuildStage == STAGE_UNINITIALIZED) {
        useDefaultSyncDelayBuildStage = STAGE_INITIALIZING;
        this.useDefaultSyncDelay = useDefaultSyncDelayInitialize();
        useDefaultSyncDelayBuildStage = STAGE_INITIALIZED;
      }
      return this.useDefaultSyncDelay;
    }

    void useDefaultSyncDelay(boolean useDefaultSyncDelay) {
      this.useDefaultSyncDelay = useDefaultSyncDelay;
      useDefaultSyncDelayBuildStage = STAGE_INITIALIZED;
    }

    private byte isVerboseBuildStage = STAGE_UNINITIALIZED;
    private boolean isVerbose;

    boolean isVerbose() {
      if (isVerboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isVerboseBuildStage == STAGE_UNINITIALIZED) {
        isVerboseBuildStage = STAGE_INITIALIZING;
        this.isVerbose = isVerboseInitialize();
        isVerboseBuildStage = STAGE_INITIALIZED;
      }
      return this.isVerbose;
    }

    void isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      isVerboseBuildStage = STAGE_INITIALIZED;
    }

    private byte useNoPreallocBuildStage = STAGE_UNINITIALIZED;
    private boolean useNoPrealloc;

    boolean useNoPrealloc() {
      if (useNoPreallocBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useNoPreallocBuildStage == STAGE_UNINITIALIZED) {
        useNoPreallocBuildStage = STAGE_INITIALIZING;
        this.useNoPrealloc = useNoPreallocInitialize();
        useNoPreallocBuildStage = STAGE_INITIALIZED;
      }
      return this.useNoPrealloc;
    }

    void useNoPrealloc(boolean useNoPrealloc) {
      this.useNoPrealloc = useNoPrealloc;
      useNoPreallocBuildStage = STAGE_INITIALIZED;
    }

    private byte useSmallFilesBuildStage = STAGE_UNINITIALIZED;
    private boolean useSmallFiles;

    boolean useSmallFiles() {
      if (useSmallFilesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useSmallFilesBuildStage == STAGE_UNINITIALIZED) {
        useSmallFilesBuildStage = STAGE_INITIALIZING;
        this.useSmallFiles = useSmallFilesInitialize();
        useSmallFilesBuildStage = STAGE_INITIALIZED;
      }
      return this.useSmallFiles;
    }

    void useSmallFiles(boolean useSmallFiles) {
      this.useSmallFiles = useSmallFiles;
      useSmallFilesBuildStage = STAGE_INITIALIZED;
    }

    private byte useNoJournalBuildStage = STAGE_UNINITIALIZED;
    private boolean useNoJournal;

    boolean useNoJournal() {
      if (useNoJournalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useNoJournalBuildStage == STAGE_UNINITIALIZED) {
        useNoJournalBuildStage = STAGE_INITIALIZING;
        this.useNoJournal = useNoJournalInitialize();
        useNoJournalBuildStage = STAGE_INITIALIZED;
      }
      return this.useNoJournal;
    }

    void useNoJournal(boolean useNoJournal) {
      this.useNoJournal = useNoJournal;
      useNoJournalBuildStage = STAGE_INITIALIZED;
    }

    private byte enableTextSearchBuildStage = STAGE_UNINITIALIZED;
    private boolean enableTextSearch;

    boolean enableTextSearch() {
      if (enableTextSearchBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (enableTextSearchBuildStage == STAGE_UNINITIALIZED) {
        enableTextSearchBuildStage = STAGE_INITIALIZING;
        this.enableTextSearch = enableTextSearchInitialize();
        enableTextSearchBuildStage = STAGE_INITIALIZED;
      }
      return this.enableTextSearch;
    }

    void enableTextSearch(boolean enableTextSearch) {
      this.enableTextSearch = enableTextSearch;
      enableTextSearchBuildStage = STAGE_INITIALIZED;
    }

    private byte authBuildStage = STAGE_UNINITIALIZED;
    private boolean auth;

    boolean auth() {
      if (authBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authBuildStage == STAGE_UNINITIALIZED) {
        authBuildStage = STAGE_INITIALIZING;
        this.auth = authInitialize();
        authBuildStage = STAGE_INITIALIZED;
      }
      return this.auth;
    }

    void auth(boolean auth) {
      this.auth = auth;
      authBuildStage = STAGE_INITIALIZED;
    }

    private byte masterBuildStage = STAGE_UNINITIALIZED;
    private boolean master;

    boolean master() {
      if (masterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (masterBuildStage == STAGE_UNINITIALIZED) {
        masterBuildStage = STAGE_INITIALIZING;
        this.master = masterInitialize();
        masterBuildStage = STAGE_INITIALIZED;
      }
      return this.master;
    }

    void master(boolean master) {
      this.master = master;
      masterBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (syncDelayBuildStage == STAGE_INITIALIZING) attributes.add("syncDelay");
      if (useDefaultSyncDelayBuildStage == STAGE_INITIALIZING) attributes.add("useDefaultSyncDelay");
      if (isVerboseBuildStage == STAGE_INITIALIZING) attributes.add("isVerbose");
      if (useNoPreallocBuildStage == STAGE_INITIALIZING) attributes.add("useNoPrealloc");
      if (useSmallFilesBuildStage == STAGE_INITIALIZING) attributes.add("useSmallFiles");
      if (useNoJournalBuildStage == STAGE_INITIALIZING) attributes.add("useNoJournal");
      if (enableTextSearchBuildStage == STAGE_INITIALIZING) attributes.add("enableTextSearch");
      if (authBuildStage == STAGE_INITIALIZING) attributes.add("auth");
      if (masterBuildStage == STAGE_INITIALIZING) attributes.add("master");
      return "Cannot build MongoCmdOptions, attribute initializers form cycle " + attributes;
    }
  }

  private int syncDelayInitialize() {
    return MongoCmdOptions.super.syncDelay();
  }

  private boolean useDefaultSyncDelayInitialize() {
    return MongoCmdOptions.super.useDefaultSyncDelay();
  }

  private boolean isVerboseInitialize() {
    return MongoCmdOptions.super.isVerbose();
  }

  private boolean useNoPreallocInitialize() {
    return MongoCmdOptions.super.useNoPrealloc();
  }

  private boolean useSmallFilesInitialize() {
    return MongoCmdOptions.super.useSmallFiles();
  }

  private boolean useNoJournalInitialize() {
    return MongoCmdOptions.super.useNoJournal();
  }

  private boolean enableTextSearchInitialize() {
    return MongoCmdOptions.super.enableTextSearch();
  }

  private boolean authInitialize() {
    return MongoCmdOptions.super.auth();
  }

  private boolean masterInitialize() {
    return MongoCmdOptions.super.master();
  }

  /**
   * @return The value of the {@code syncDelay} attribute
   */
  @Override
  public int syncDelay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.syncDelay()
        : this.syncDelay;
  }

  /**
   * @return The value of the {@code useDefaultSyncDelay} attribute
   */
  @Override
  public boolean useDefaultSyncDelay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useDefaultSyncDelay()
        : this.useDefaultSyncDelay;
  }

  /**
   * @return The value of the {@code storageEngine} attribute
   */
  @Override
  public Optional<String> storageEngine() {
    return Optional.ofNullable(storageEngine);
  }

  /**
   * @return The value of the {@code isVerbose} attribute
   */
  @Override
  public boolean isVerbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVerbose()
        : this.isVerbose;
  }

  /**
   * @return The value of the {@code useNoPrealloc} attribute
   */
  @Override
  public boolean useNoPrealloc() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useNoPrealloc()
        : this.useNoPrealloc;
  }

  /**
   * @return The value of the {@code useSmallFiles} attribute
   */
  @Override
  public boolean useSmallFiles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useSmallFiles()
        : this.useSmallFiles;
  }

  /**
   * @return The value of the {@code useNoJournal} attribute
   */
  @Override
  public boolean useNoJournal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useNoJournal()
        : this.useNoJournal;
  }

  /**
   * @return The value of the {@code enableTextSearch} attribute
   */
  @Override
  public boolean enableTextSearch() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.enableTextSearch()
        : this.enableTextSearch;
  }

  /**
   * @return The value of the {@code auth} attribute
   */
  @Override
  public boolean auth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.auth()
        : this.auth;
  }

  /**
   * @return The value of the {@code master} attribute
   */
  @Override
  public boolean master() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.master()
        : this.master;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#syncDelay() syncDelay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for syncDelay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withSyncDelay(int value) {
    if (this.syncDelay == value) return this;
    return new ImmutableMongoCmdOptions(
        value,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#useDefaultSyncDelay() useDefaultSyncDelay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useDefaultSyncDelay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withUseDefaultSyncDelay(boolean value) {
    if (this.useDefaultSyncDelay == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        value,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoCmdOptions#storageEngine() storageEngine} attribute.
   * @param value The value for storageEngine
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoCmdOptions withStorageEngine(String value) {
    String newValue = Objects.requireNonNull(value, "storageEngine");
    if (Objects.equals(this.storageEngine, newValue)) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        newValue,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoCmdOptions#storageEngine() storageEngine} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for storageEngine
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoCmdOptions withStorageEngine(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.storageEngine, value)) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        value,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#isVerbose() isVerbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVerbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withIsVerbose(boolean value) {
    if (this.isVerbose == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        value,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#useNoPrealloc() useNoPrealloc} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useNoPrealloc
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withUseNoPrealloc(boolean value) {
    if (this.useNoPrealloc == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        value,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#useSmallFiles() useSmallFiles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useSmallFiles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withUseSmallFiles(boolean value) {
    if (this.useSmallFiles == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        value,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#useNoJournal() useNoJournal} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useNoJournal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withUseNoJournal(boolean value) {
    if (this.useNoJournal == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        value,
        this.enableTextSearch,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#enableTextSearch() enableTextSearch} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableTextSearch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withEnableTextSearch(boolean value) {
    if (this.enableTextSearch == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        value,
        this.auth,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#auth() auth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for auth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withAuth(boolean value) {
    if (this.auth == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        value,
        this.master);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCmdOptions#master() master} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for master
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoCmdOptions withMaster(boolean value) {
    if (this.master == value) return this;
    return new ImmutableMongoCmdOptions(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoCmdOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoCmdOptions
        && equalTo(0, (ImmutableMongoCmdOptions) another);
  }

  private boolean equalTo(int synthetic, ImmutableMongoCmdOptions another) {
    return syncDelay == another.syncDelay
        && useDefaultSyncDelay == another.useDefaultSyncDelay
        && Objects.equals(storageEngine, another.storageEngine)
        && isVerbose == another.isVerbose
        && useNoPrealloc == another.useNoPrealloc
        && useSmallFiles == another.useSmallFiles
        && useNoJournal == another.useNoJournal
        && enableTextSearch == another.enableTextSearch
        && auth == another.auth
        && master == another.master;
  }

  /**
   * Computes a hash code from attributes: {@code syncDelay}, {@code useDefaultSyncDelay}, {@code storageEngine}, {@code isVerbose}, {@code useNoPrealloc}, {@code useSmallFiles}, {@code useNoJournal}, {@code enableTextSearch}, {@code auth}, {@code master}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + syncDelay;
    h += (h << 5) + Boolean.hashCode(useDefaultSyncDelay);
    h += (h << 5) + Objects.hashCode(storageEngine);
    h += (h << 5) + Boolean.hashCode(isVerbose);
    h += (h << 5) + Boolean.hashCode(useNoPrealloc);
    h += (h << 5) + Boolean.hashCode(useSmallFiles);
    h += (h << 5) + Boolean.hashCode(useNoJournal);
    h += (h << 5) + Boolean.hashCode(enableTextSearch);
    h += (h << 5) + Boolean.hashCode(auth);
    h += (h << 5) + Boolean.hashCode(master);
    return h;
  }

  /**
   * Prints the immutable value {@code MongoCmdOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoCmdOptions{");
    builder.append("syncDelay=").append(syncDelay);
    builder.append(", ");
    builder.append("useDefaultSyncDelay=").append(useDefaultSyncDelay);
    if (storageEngine != null) {
      builder.append(", ");
      builder.append("storageEngine=").append(storageEngine);
    }
    builder.append(", ");
    builder.append("isVerbose=").append(isVerbose);
    builder.append(", ");
    builder.append("useNoPrealloc=").append(useNoPrealloc);
    builder.append(", ");
    builder.append("useSmallFiles=").append(useSmallFiles);
    builder.append(", ");
    builder.append("useNoJournal=").append(useNoJournal);
    builder.append(", ");
    builder.append("enableTextSearch=").append(enableTextSearch);
    builder.append(", ");
    builder.append("auth=").append(auth);
    builder.append(", ");
    builder.append("master=").append(master);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoCmdOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoCmdOptions instance
   */
  public static ImmutableMongoCmdOptions copyOf(MongoCmdOptions instance) {
    if (instance instanceof ImmutableMongoCmdOptions) {
      return (ImmutableMongoCmdOptions) instance;
    }
    return ImmutableMongoCmdOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoCmdOptions ImmutableMongoCmdOptions}.
   * <pre>
   * ImmutableMongoCmdOptions.builder()
   *    .syncDelay(int) // optional {@link MongoCmdOptions#syncDelay() syncDelay}
   *    .useDefaultSyncDelay(boolean) // optional {@link MongoCmdOptions#useDefaultSyncDelay() useDefaultSyncDelay}
   *    .storageEngine(String) // optional {@link MongoCmdOptions#storageEngine() storageEngine}
   *    .isVerbose(boolean) // optional {@link MongoCmdOptions#isVerbose() isVerbose}
   *    .useNoPrealloc(boolean) // optional {@link MongoCmdOptions#useNoPrealloc() useNoPrealloc}
   *    .useSmallFiles(boolean) // optional {@link MongoCmdOptions#useSmallFiles() useSmallFiles}
   *    .useNoJournal(boolean) // optional {@link MongoCmdOptions#useNoJournal() useNoJournal}
   *    .enableTextSearch(boolean) // optional {@link MongoCmdOptions#enableTextSearch() enableTextSearch}
   *    .auth(boolean) // optional {@link MongoCmdOptions#auth() auth}
   *    .master(boolean) // optional {@link MongoCmdOptions#master() master}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoCmdOptions builder
   */
  public static ImmutableMongoCmdOptions.Builder builder() {
    return new ImmutableMongoCmdOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoCmdOptions ImmutableMongoCmdOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoCmdOptions", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_SYNC_DELAY = 0x1L;
    private static final long OPT_BIT_USE_DEFAULT_SYNC_DELAY = 0x2L;
    private static final long OPT_BIT_IS_VERBOSE = 0x4L;
    private static final long OPT_BIT_USE_NO_PREALLOC = 0x8L;
    private static final long OPT_BIT_USE_SMALL_FILES = 0x10L;
    private static final long OPT_BIT_USE_NO_JOURNAL = 0x20L;
    private static final long OPT_BIT_ENABLE_TEXT_SEARCH = 0x40L;
    private static final long OPT_BIT_AUTH = 0x80L;
    private static final long OPT_BIT_MASTER = 0x100L;
    private long optBits;

    private int syncDelay;
    private boolean useDefaultSyncDelay;
    private String storageEngine;
    private boolean isVerbose;
    private boolean useNoPrealloc;
    private boolean useSmallFiles;
    private boolean useNoJournal;
    private boolean enableTextSearch;
    private boolean auth;
    private boolean master;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoCmdOptions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCmdOptions instance) {
      Objects.requireNonNull(instance, "instance");
      syncDelay(instance.syncDelay());
      useDefaultSyncDelay(instance.useDefaultSyncDelay());
      Optional<String> storageEngineOptional = instance.storageEngine();
      if (storageEngineOptional.isPresent()) {
        storageEngine(storageEngineOptional);
      }
      isVerbose(instance.isVerbose());
      useNoPrealloc(instance.useNoPrealloc());
      useSmallFiles(instance.useSmallFiles());
      useNoJournal(instance.useNoJournal());
      enableTextSearch(instance.enableTextSearch());
      auth(instance.auth());
      master(instance.master());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#syncDelay() syncDelay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#syncDelay() syncDelay}.</em>
     * @param syncDelay The value for syncDelay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syncDelay(int syncDelay) {
      this.syncDelay = syncDelay;
      optBits |= OPT_BIT_SYNC_DELAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#useDefaultSyncDelay() useDefaultSyncDelay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#useDefaultSyncDelay() useDefaultSyncDelay}.</em>
     * @param useDefaultSyncDelay The value for useDefaultSyncDelay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useDefaultSyncDelay(boolean useDefaultSyncDelay) {
      this.useDefaultSyncDelay = useDefaultSyncDelay;
      optBits |= OPT_BIT_USE_DEFAULT_SYNC_DELAY;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoCmdOptions#storageEngine() storageEngine} to storageEngine.
     * @param storageEngine The value for storageEngine
     * @return {@code this} builder for chained invocation
     */
    public final Builder storageEngine(String storageEngine) {
      this.storageEngine = Objects.requireNonNull(storageEngine, "storageEngine");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoCmdOptions#storageEngine() storageEngine} to storageEngine.
     * @param storageEngine The value for storageEngine
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder storageEngine(Optional<String> storageEngine) {
      this.storageEngine = storageEngine.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#isVerbose() isVerbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#isVerbose() isVerbose}.</em>
     * @param isVerbose The value for isVerbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      optBits |= OPT_BIT_IS_VERBOSE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#useNoPrealloc() useNoPrealloc} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#useNoPrealloc() useNoPrealloc}.</em>
     * @param useNoPrealloc The value for useNoPrealloc 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useNoPrealloc(boolean useNoPrealloc) {
      this.useNoPrealloc = useNoPrealloc;
      optBits |= OPT_BIT_USE_NO_PREALLOC;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#useSmallFiles() useSmallFiles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#useSmallFiles() useSmallFiles}.</em>
     * @param useSmallFiles The value for useSmallFiles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useSmallFiles(boolean useSmallFiles) {
      this.useSmallFiles = useSmallFiles;
      optBits |= OPT_BIT_USE_SMALL_FILES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#useNoJournal() useNoJournal} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#useNoJournal() useNoJournal}.</em>
     * @param useNoJournal The value for useNoJournal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useNoJournal(boolean useNoJournal) {
      this.useNoJournal = useNoJournal;
      optBits |= OPT_BIT_USE_NO_JOURNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#enableTextSearch() enableTextSearch} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#enableTextSearch() enableTextSearch}.</em>
     * @param enableTextSearch The value for enableTextSearch 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableTextSearch(boolean enableTextSearch) {
      this.enableTextSearch = enableTextSearch;
      optBits |= OPT_BIT_ENABLE_TEXT_SEARCH;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#auth() auth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#auth() auth}.</em>
     * @param auth The value for auth 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auth(boolean auth) {
      this.auth = auth;
      optBits |= OPT_BIT_AUTH;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCmdOptions#master() master} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoCmdOptions#master() master}.</em>
     * @param master The value for master 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder master(boolean master) {
      this.master = master;
      optBits |= OPT_BIT_MASTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoCmdOptions ImmutableMongoCmdOptions}.
     * @return An immutable instance of MongoCmdOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoCmdOptions build() {
      return new ImmutableMongoCmdOptions(this);
    }

    private boolean syncDelayIsSet() {
      return (optBits & OPT_BIT_SYNC_DELAY) != 0;
    }

    private boolean useDefaultSyncDelayIsSet() {
      return (optBits & OPT_BIT_USE_DEFAULT_SYNC_DELAY) != 0;
    }

    private boolean isVerboseIsSet() {
      return (optBits & OPT_BIT_IS_VERBOSE) != 0;
    }

    private boolean useNoPreallocIsSet() {
      return (optBits & OPT_BIT_USE_NO_PREALLOC) != 0;
    }

    private boolean useSmallFilesIsSet() {
      return (optBits & OPT_BIT_USE_SMALL_FILES) != 0;
    }

    private boolean useNoJournalIsSet() {
      return (optBits & OPT_BIT_USE_NO_JOURNAL) != 0;
    }

    private boolean enableTextSearchIsSet() {
      return (optBits & OPT_BIT_ENABLE_TEXT_SEARCH) != 0;
    }

    private boolean authIsSet() {
      return (optBits & OPT_BIT_AUTH) != 0;
    }

    private boolean masterIsSet() {
      return (optBits & OPT_BIT_MASTER) != 0;
    }
  }
}
