package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.SupportConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoDumpConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoDumpConfig.builder()}.
 */
@Generated(from = "MongoDumpConfig", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableMongoDumpConfig implements MongoDumpConfig {
  private final Long stopTimeoutInMillis;
  private final IFeatureAwareVersion version;
  private final Timeout timeout;
  private final Net net;
  private final MongoCmdOptions cmdOptions;
  private final String password;
  private final String userName;
  private final boolean isVerbose;
  private final String databaseName;
  private final String collectionName;
  private final String query;
  private final String queryFile;
  private final String readPreference;
  private final boolean isForceTableScan;
  private final String archive;
  private final boolean isDumpDbUsersAndRoles;
  private final boolean isGzip;
  private final boolean isRepair;
  private final String out;
  private final boolean isOplog;
  private final String excludeCollection;
  private final String excludeCollectionWithPrefix;
  private final Integer numberOfParallelCollections;
  private final String pidFile;
  private final SupportConfig supportConfig;

  private ImmutableMongoDumpConfig(ImmutableMongoDumpConfig.Builder builder) {
    this.stopTimeoutInMillis = builder.stopTimeoutInMillis;
    this.version = builder.version;
    this.databaseName = builder.databaseName;
    this.collectionName = builder.collectionName;
    this.query = builder.query;
    this.queryFile = builder.queryFile;
    this.readPreference = builder.readPreference;
    this.archive = builder.archive;
    this.out = builder.out;
    this.excludeCollection = builder.excludeCollection;
    this.excludeCollectionWithPrefix = builder.excludeCollectionWithPrefix;
    this.numberOfParallelCollections = builder.numberOfParallelCollections;
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.net != null) {
      initShim.net(builder.net);
    }
    if (builder.cmdOptions != null) {
      initShim.cmdOptions(builder.cmdOptions);
    }
    if (builder.password != null) {
      initShim.password(builder.password);
    }
    if (builder.userName != null) {
      initShim.userName(builder.userName);
    }
    if (builder.isVerboseIsSet()) {
      initShim.isVerbose(builder.isVerbose);
    }
    if (builder.isForceTableScanIsSet()) {
      initShim.isForceTableScan(builder.isForceTableScan);
    }
    if (builder.isDumpDbUsersAndRolesIsSet()) {
      initShim.isDumpDbUsersAndRoles(builder.isDumpDbUsersAndRoles);
    }
    if (builder.isGzipIsSet()) {
      initShim.isGzip(builder.isGzip);
    }
    if (builder.isRepairIsSet()) {
      initShim.isRepair(builder.isRepair);
    }
    if (builder.isOplogIsSet()) {
      initShim.isOplog(builder.isOplog);
    }
    if (builder.pidFile != null) {
      initShim.pidFile(builder.pidFile);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    this.timeout = initShim.timeout();
    this.net = initShim.net();
    this.cmdOptions = initShim.cmdOptions();
    this.password = initShim.password();
    this.userName = initShim.userName();
    this.isVerbose = initShim.isVerbose();
    this.isForceTableScan = initShim.isForceTableScan();
    this.isDumpDbUsersAndRoles = initShim.isDumpDbUsersAndRoles();
    this.isGzip = initShim.isGzip();
    this.isRepair = initShim.isRepair();
    this.isOplog = initShim.isOplog();
    this.pidFile = initShim.pidFile();
    this.supportConfig = initShim.supportConfig();
    this.initShim = null;
  }

  private ImmutableMongoDumpConfig(
      Long stopTimeoutInMillis,
      IFeatureAwareVersion version,
      Timeout timeout,
      Net net,
      MongoCmdOptions cmdOptions,
      String password,
      String userName,
      boolean isVerbose,
      String databaseName,
      String collectionName,
      String query,
      String queryFile,
      String readPreference,
      boolean isForceTableScan,
      String archive,
      boolean isDumpDbUsersAndRoles,
      boolean isGzip,
      boolean isRepair,
      String out,
      boolean isOplog,
      String excludeCollection,
      String excludeCollectionWithPrefix,
      Integer numberOfParallelCollections,
      String pidFile,
      SupportConfig supportConfig) {
    this.stopTimeoutInMillis = stopTimeoutInMillis;
    this.version = version;
    this.timeout = timeout;
    this.net = net;
    this.cmdOptions = cmdOptions;
    this.password = password;
    this.userName = userName;
    this.isVerbose = isVerbose;
    this.databaseName = databaseName;
    this.collectionName = collectionName;
    this.query = query;
    this.queryFile = queryFile;
    this.readPreference = readPreference;
    this.isForceTableScan = isForceTableScan;
    this.archive = archive;
    this.isDumpDbUsersAndRoles = isDumpDbUsersAndRoles;
    this.isGzip = isGzip;
    this.isRepair = isRepair;
    this.out = out;
    this.isOplog = isOplog;
    this.excludeCollection = excludeCollection;
    this.excludeCollectionWithPrefix = excludeCollectionWithPrefix;
    this.numberOfParallelCollections = numberOfParallelCollections;
    this.pidFile = pidFile;
    this.supportConfig = supportConfig;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MongoDumpConfig", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Timeout timeout;

    Timeout timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Timeout timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte netBuildStage = STAGE_UNINITIALIZED;
    private Net net;

    Net net() {
      if (netBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (netBuildStage == STAGE_UNINITIALIZED) {
        netBuildStage = STAGE_INITIALIZING;
        this.net = Objects.requireNonNull(netInitialize(), "net");
        netBuildStage = STAGE_INITIALIZED;
      }
      return this.net;
    }

    void net(Net net) {
      this.net = net;
      netBuildStage = STAGE_INITIALIZED;
    }

    private byte cmdOptionsBuildStage = STAGE_UNINITIALIZED;
    private MongoCmdOptions cmdOptions;

    MongoCmdOptions cmdOptions() {
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cmdOptionsBuildStage == STAGE_UNINITIALIZED) {
        cmdOptionsBuildStage = STAGE_INITIALIZING;
        this.cmdOptions = Objects.requireNonNull(cmdOptionsInitialize(), "cmdOptions");
        cmdOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.cmdOptions;
    }

    void cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = cmdOptions;
      cmdOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte passwordBuildStage = STAGE_UNINITIALIZED;
    private String password;

    String password() {
      if (passwordBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passwordBuildStage == STAGE_UNINITIALIZED) {
        passwordBuildStage = STAGE_INITIALIZING;
        this.password = Objects.requireNonNull(passwordInitialize(), "password");
        passwordBuildStage = STAGE_INITIALIZED;
      }
      return this.password;
    }

    void password(String password) {
      this.password = password;
      passwordBuildStage = STAGE_INITIALIZED;
    }

    private byte userNameBuildStage = STAGE_UNINITIALIZED;
    private String userName;

    String userName() {
      if (userNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userNameBuildStage == STAGE_UNINITIALIZED) {
        userNameBuildStage = STAGE_INITIALIZING;
        this.userName = Objects.requireNonNull(userNameInitialize(), "userName");
        userNameBuildStage = STAGE_INITIALIZED;
      }
      return this.userName;
    }

    void userName(String userName) {
      this.userName = userName;
      userNameBuildStage = STAGE_INITIALIZED;
    }

    private byte isVerboseBuildStage = STAGE_UNINITIALIZED;
    private boolean isVerbose;

    boolean isVerbose() {
      if (isVerboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isVerboseBuildStage == STAGE_UNINITIALIZED) {
        isVerboseBuildStage = STAGE_INITIALIZING;
        this.isVerbose = isVerboseInitialize();
        isVerboseBuildStage = STAGE_INITIALIZED;
      }
      return this.isVerbose;
    }

    void isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      isVerboseBuildStage = STAGE_INITIALIZED;
    }

    private byte isForceTableScanBuildStage = STAGE_UNINITIALIZED;
    private boolean isForceTableScan;

    boolean isForceTableScan() {
      if (isForceTableScanBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isForceTableScanBuildStage == STAGE_UNINITIALIZED) {
        isForceTableScanBuildStage = STAGE_INITIALIZING;
        this.isForceTableScan = isForceTableScanInitialize();
        isForceTableScanBuildStage = STAGE_INITIALIZED;
      }
      return this.isForceTableScan;
    }

    void isForceTableScan(boolean isForceTableScan) {
      this.isForceTableScan = isForceTableScan;
      isForceTableScanBuildStage = STAGE_INITIALIZED;
    }

    private byte isDumpDbUsersAndRolesBuildStage = STAGE_UNINITIALIZED;
    private boolean isDumpDbUsersAndRoles;

    boolean isDumpDbUsersAndRoles() {
      if (isDumpDbUsersAndRolesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isDumpDbUsersAndRolesBuildStage == STAGE_UNINITIALIZED) {
        isDumpDbUsersAndRolesBuildStage = STAGE_INITIALIZING;
        this.isDumpDbUsersAndRoles = isDumpDbUsersAndRolesInitialize();
        isDumpDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
      }
      return this.isDumpDbUsersAndRoles;
    }

    void isDumpDbUsersAndRoles(boolean isDumpDbUsersAndRoles) {
      this.isDumpDbUsersAndRoles = isDumpDbUsersAndRoles;
      isDumpDbUsersAndRolesBuildStage = STAGE_INITIALIZED;
    }

    private byte isGzipBuildStage = STAGE_UNINITIALIZED;
    private boolean isGzip;

    boolean isGzip() {
      if (isGzipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isGzipBuildStage == STAGE_UNINITIALIZED) {
        isGzipBuildStage = STAGE_INITIALIZING;
        this.isGzip = isGzipInitialize();
        isGzipBuildStage = STAGE_INITIALIZED;
      }
      return this.isGzip;
    }

    void isGzip(boolean isGzip) {
      this.isGzip = isGzip;
      isGzipBuildStage = STAGE_INITIALIZED;
    }

    private byte isRepairBuildStage = STAGE_UNINITIALIZED;
    private boolean isRepair;

    boolean isRepair() {
      if (isRepairBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isRepairBuildStage == STAGE_UNINITIALIZED) {
        isRepairBuildStage = STAGE_INITIALIZING;
        this.isRepair = isRepairInitialize();
        isRepairBuildStage = STAGE_INITIALIZED;
      }
      return this.isRepair;
    }

    void isRepair(boolean isRepair) {
      this.isRepair = isRepair;
      isRepairBuildStage = STAGE_INITIALIZED;
    }

    private byte isOplogBuildStage = STAGE_UNINITIALIZED;
    private boolean isOplog;

    boolean isOplog() {
      if (isOplogBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isOplogBuildStage == STAGE_UNINITIALIZED) {
        isOplogBuildStage = STAGE_INITIALIZING;
        this.isOplog = isOplogInitialize();
        isOplogBuildStage = STAGE_INITIALIZED;
      }
      return this.isOplog;
    }

    void isOplog(boolean isOplog) {
      this.isOplog = isOplog;
      isOplogBuildStage = STAGE_INITIALIZED;
    }

    private byte pidFileBuildStage = STAGE_UNINITIALIZED;
    private String pidFile;

    String pidFile() {
      if (pidFileBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pidFileBuildStage == STAGE_UNINITIALIZED) {
        pidFileBuildStage = STAGE_INITIALIZING;
        this.pidFile = Objects.requireNonNull(pidFileInitialize(), "pidFile");
        pidFileBuildStage = STAGE_INITIALIZED;
      }
      return this.pidFile;
    }

    void pidFile(String pidFile) {
      this.pidFile = pidFile;
      pidFileBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private SupportConfig supportConfig;

    SupportConfig supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(supportConfigInitialize(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(SupportConfig supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (netBuildStage == STAGE_INITIALIZING) attributes.add("net");
      if (cmdOptionsBuildStage == STAGE_INITIALIZING) attributes.add("cmdOptions");
      if (passwordBuildStage == STAGE_INITIALIZING) attributes.add("password");
      if (userNameBuildStage == STAGE_INITIALIZING) attributes.add("userName");
      if (isVerboseBuildStage == STAGE_INITIALIZING) attributes.add("isVerbose");
      if (isForceTableScanBuildStage == STAGE_INITIALIZING) attributes.add("isForceTableScan");
      if (isDumpDbUsersAndRolesBuildStage == STAGE_INITIALIZING) attributes.add("isDumpDbUsersAndRoles");
      if (isGzipBuildStage == STAGE_INITIALIZING) attributes.add("isGzip");
      if (isRepairBuildStage == STAGE_INITIALIZING) attributes.add("isRepair");
      if (isOplogBuildStage == STAGE_INITIALIZING) attributes.add("isOplog");
      if (pidFileBuildStage == STAGE_INITIALIZING) attributes.add("pidFile");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      return "Cannot build MongoDumpConfig, attribute initializers form cycle " + attributes;
    }
  }

  private Timeout timeoutInitialize() {
    return MongoDumpConfig.super.timeout();
  }

  private Net netInitialize() {
    return MongoDumpConfig.super.net();
  }

  private MongoCmdOptions cmdOptionsInitialize() {
    return MongoDumpConfig.super.cmdOptions();
  }

  private String passwordInitialize() {
    return MongoDumpConfig.super.password();
  }

  private String userNameInitialize() {
    return MongoDumpConfig.super.userName();
  }

  private boolean isVerboseInitialize() {
    return MongoDumpConfig.super.isVerbose();
  }

  private boolean isForceTableScanInitialize() {
    return MongoDumpConfig.super.isForceTableScan();
  }

  private boolean isDumpDbUsersAndRolesInitialize() {
    return MongoDumpConfig.super.isDumpDbUsersAndRoles();
  }

  private boolean isGzipInitialize() {
    return MongoDumpConfig.super.isGzip();
  }

  private boolean isRepairInitialize() {
    return MongoDumpConfig.super.isRepair();
  }

  private boolean isOplogInitialize() {
    return MongoDumpConfig.super.isOplog();
  }

  private String pidFileInitialize() {
    return MongoDumpConfig.super.pidFile();
  }

  private SupportConfig supportConfigInitialize() {
    return MongoDumpConfig.super.supportConfig();
  }

  /**
   * @return The value of the {@code stopTimeoutInMillis} attribute
   */
  @Override
  public OptionalLong stopTimeoutInMillis() {
    return stopTimeoutInMillis != null
        ? OptionalLong.of(stopTimeoutInMillis)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public IFeatureAwareVersion version() {
    return version;
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Timeout timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code net} attribute
   */
  @Override
  public Net net() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.net()
        : this.net;
  }

  /**
   * @return The value of the {@code cmdOptions} attribute
   */
  @Override
  public MongoCmdOptions cmdOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.cmdOptions()
        : this.cmdOptions;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public String password() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.password()
        : this.password;
  }

  /**
   * @return The value of the {@code userName} attribute
   */
  @Override
  public String userName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.userName()
        : this.userName;
  }

  /**
   * @return The value of the {@code isVerbose} attribute
   */
  @Override
  public boolean isVerbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVerbose()
        : this.isVerbose;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @Override
  public Optional<String> getDatabaseName() {
    return Optional.ofNullable(databaseName);
  }

  /**
   * @return The value of the {@code collectionName} attribute
   */
  @Override
  public Optional<String> getCollectionName() {
    return Optional.ofNullable(collectionName);
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @Override
  public Optional<String> getQuery() {
    return Optional.ofNullable(query);
  }

  /**
   * @return The value of the {@code queryFile} attribute
   */
  @Override
  public Optional<String> getQueryFile() {
    return Optional.ofNullable(queryFile);
  }

  /**
   * @return The value of the {@code readPreference} attribute
   */
  @Override
  public Optional<String> getReadPreference() {
    return Optional.ofNullable(readPreference);
  }

  /**
   * @return The value of the {@code isForceTableScan} attribute
   */
  @Override
  public boolean isForceTableScan() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isForceTableScan()
        : this.isForceTableScan;
  }

  /**
   * @return The value of the {@code archive} attribute
   */
  @Override
  public Optional<String> getArchive() {
    return Optional.ofNullable(archive);
  }

  /**
   * @return The value of the {@code isDumpDbUsersAndRoles} attribute
   */
  @Override
  public boolean isDumpDbUsersAndRoles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isDumpDbUsersAndRoles()
        : this.isDumpDbUsersAndRoles;
  }

  /**
   * @return The value of the {@code isGzip} attribute
   */
  @Override
  public boolean isGzip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isGzip()
        : this.isGzip;
  }

  /**
   * @return The value of the {@code isRepair} attribute
   */
  @Override
  public boolean isRepair() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isRepair()
        : this.isRepair;
  }

  /**
   * @return The value of the {@code out} attribute
   */
  @Override
  public Optional<String> getOut() {
    return Optional.ofNullable(out);
  }

  /**
   * @return The value of the {@code isOplog} attribute
   */
  @Override
  public boolean isOplog() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isOplog()
        : this.isOplog;
  }

  /**
   * @return The value of the {@code excludeCollection} attribute
   */
  @Override
  public Optional<String> getExcludeCollection() {
    return Optional.ofNullable(excludeCollection);
  }

  /**
   * @return The value of the {@code excludeCollectionWithPrefix} attribute
   */
  @Override
  public Optional<String> getExcludeCollectionWithPrefix() {
    return Optional.ofNullable(excludeCollectionWithPrefix);
  }

  /**
   * @return The value of the {@code numberOfParallelCollections} attribute
   */
  @Override
  public OptionalInt getNumberOfParallelCollections() {
    return numberOfParallelCollections != null
        ? OptionalInt.of(numberOfParallelCollections)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code pidFile} attribute
   */
  @Override
  public String pidFile() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pidFile()
        : this.pidFile;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public SupportConfig supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * @param value The value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withStopTimeoutInMillis(long value) {
    Long newValue = value;
    if (Objects.equals(this.stopTimeoutInMillis, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        newValue,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#stopTimeoutInMillis() stopTimeoutInMillis} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for stopTimeoutInMillis
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withStopTimeoutInMillis(OptionalLong optional) {
    Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.stopTimeoutInMillis, value)) return this;
    return new ImmutableMongoDumpConfig(
        value,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#version() version} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withVersion(IFeatureAwareVersion value) {
    if (this.version == value) return this;
    IFeatureAwareVersion newValue = Objects.requireNonNull(value, "version");
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        newValue,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withTimeout(Timeout value) {
    if (this.timeout == value) return this;
    Timeout newValue = Objects.requireNonNull(value, "timeout");
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        newValue,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#net() net} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for net
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withNet(Net value) {
    if (this.net == value) return this;
    Net newValue = Objects.requireNonNull(value, "net");
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        newValue,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#cmdOptions() cmdOptions} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cmdOptions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withCmdOptions(MongoCmdOptions value) {
    if (this.cmdOptions == value) return this;
    MongoCmdOptions newValue = Objects.requireNonNull(value, "cmdOptions");
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        newValue,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withPassword(String value) {
    String newValue = Objects.requireNonNull(value, "password");
    if (this.password.equals(newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        newValue,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#userName() userName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withUserName(String value) {
    String newValue = Objects.requireNonNull(value, "userName");
    if (this.userName.equals(newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        newValue,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isVerbose() isVerbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVerbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsVerbose(boolean value) {
    if (this.isVerbose == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        value,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getDatabaseName() databaseName} attribute.
   * @param value The value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withDatabaseName(String value) {
    String newValue = Objects.requireNonNull(value, "databaseName");
    if (Objects.equals(this.databaseName, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        newValue,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getDatabaseName() databaseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for databaseName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withDatabaseName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        value,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getCollectionName() collectionName} attribute.
   * @param value The value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withCollectionName(String value) {
    String newValue = Objects.requireNonNull(value, "collectionName");
    if (Objects.equals(this.collectionName, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        newValue,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getCollectionName() collectionName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for collectionName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withCollectionName(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.collectionName, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        value,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getQuery() query} attribute.
   * @param value The value for query
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withQuery(String value) {
    String newValue = Objects.requireNonNull(value, "query");
    if (Objects.equals(this.query, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        newValue,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getQuery() query} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for query
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withQuery(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.query, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        value,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getQueryFile() queryFile} attribute.
   * @param value The value for queryFile
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withQueryFile(String value) {
    String newValue = Objects.requireNonNull(value, "queryFile");
    if (Objects.equals(this.queryFile, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        newValue,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getQueryFile() queryFile} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for queryFile
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withQueryFile(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.queryFile, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        value,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getReadPreference() readPreference} attribute.
   * @param value The value for readPreference
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withReadPreference(String value) {
    String newValue = Objects.requireNonNull(value, "readPreference");
    if (Objects.equals(this.readPreference, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        newValue,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getReadPreference() readPreference} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for readPreference
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withReadPreference(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.readPreference, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        value,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isForceTableScan() isForceTableScan} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isForceTableScan
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsForceTableScan(boolean value) {
    if (this.isForceTableScan == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        value,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getArchive() archive} attribute.
   * @param value The value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withArchive(String value) {
    String newValue = Objects.requireNonNull(value, "archive");
    if (Objects.equals(this.archive, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        newValue,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getArchive() archive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for archive
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withArchive(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.archive, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        value,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isDumpDbUsersAndRoles() isDumpDbUsersAndRoles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDumpDbUsersAndRoles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsDumpDbUsersAndRoles(boolean value) {
    if (this.isDumpDbUsersAndRoles == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        value,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isGzip() isGzip} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isGzip
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsGzip(boolean value) {
    if (this.isGzip == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        value,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isRepair() isRepair} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isRepair
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsRepair(boolean value) {
    if (this.isRepair == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        value,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getOut() out} attribute.
   * @param value The value for out
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withOut(String value) {
    String newValue = Objects.requireNonNull(value, "out");
    if (Objects.equals(this.out, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        newValue,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getOut() out} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for out
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withOut(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.out, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        value,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#isOplog() isOplog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isOplog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withIsOplog(boolean value) {
    if (this.isOplog == value) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        value,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getExcludeCollection() excludeCollection} attribute.
   * @param value The value for excludeCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withExcludeCollection(String value) {
    String newValue = Objects.requireNonNull(value, "excludeCollection");
    if (Objects.equals(this.excludeCollection, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        newValue,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getExcludeCollection() excludeCollection} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for excludeCollection
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withExcludeCollection(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.excludeCollection, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        value,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getExcludeCollectionWithPrefix() excludeCollectionWithPrefix} attribute.
   * @param value The value for excludeCollectionWithPrefix
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withExcludeCollectionWithPrefix(String value) {
    String newValue = Objects.requireNonNull(value, "excludeCollectionWithPrefix");
    if (Objects.equals(this.excludeCollectionWithPrefix, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        newValue,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getExcludeCollectionWithPrefix() excludeCollectionWithPrefix} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for excludeCollectionWithPrefix
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withExcludeCollectionWithPrefix(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.excludeCollectionWithPrefix, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        value,
        this.numberOfParallelCollections,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongoDumpConfig#getNumberOfParallelCollections() numberOfParallelCollections} attribute.
   * @param value The value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withNumberOfParallelCollections(int value) {
    Integer newValue = value;
    if (Objects.equals(this.numberOfParallelCollections, newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        newValue,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongoDumpConfig#getNumberOfParallelCollections() numberOfParallelCollections} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for numberOfParallelCollections
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoDumpConfig withNumberOfParallelCollections(OptionalInt optional) {
    Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.numberOfParallelCollections, value)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        value,
        this.pidFile,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#pidFile() pidFile} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pidFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withPidFile(String value) {
    String newValue = Objects.requireNonNull(value, "pidFile");
    if (this.pidFile.equals(newValue)) return this;
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        newValue,
        this.supportConfig);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoDumpConfig#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDumpConfig withSupportConfig(SupportConfig value) {
    if (this.supportConfig == value) return this;
    SupportConfig newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongoDumpConfig(
        this.stopTimeoutInMillis,
        this.version,
        this.timeout,
        this.net,
        this.cmdOptions,
        this.password,
        this.userName,
        this.isVerbose,
        this.databaseName,
        this.collectionName,
        this.query,
        this.queryFile,
        this.readPreference,
        this.isForceTableScan,
        this.archive,
        this.isDumpDbUsersAndRoles,
        this.isGzip,
        this.isRepair,
        this.out,
        this.isOplog,
        this.excludeCollection,
        this.excludeCollectionWithPrefix,
        this.numberOfParallelCollections,
        this.pidFile,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoDumpConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoDumpConfig
        && equalTo(0, (ImmutableMongoDumpConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableMongoDumpConfig another) {
    return Objects.equals(stopTimeoutInMillis, another.stopTimeoutInMillis)
        && version.equals(another.version)
        && timeout.equals(another.timeout)
        && net.equals(another.net)
        && cmdOptions.equals(another.cmdOptions)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && isVerbose == another.isVerbose
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(collectionName, another.collectionName)
        && Objects.equals(query, another.query)
        && Objects.equals(queryFile, another.queryFile)
        && Objects.equals(readPreference, another.readPreference)
        && isForceTableScan == another.isForceTableScan
        && Objects.equals(archive, another.archive)
        && isDumpDbUsersAndRoles == another.isDumpDbUsersAndRoles
        && isGzip == another.isGzip
        && isRepair == another.isRepair
        && Objects.equals(out, another.out)
        && isOplog == another.isOplog
        && Objects.equals(excludeCollection, another.excludeCollection)
        && Objects.equals(excludeCollectionWithPrefix, another.excludeCollectionWithPrefix)
        && Objects.equals(numberOfParallelCollections, another.numberOfParallelCollections)
        && pidFile.equals(another.pidFile)
        && supportConfig.equals(another.supportConfig);
  }

  /**
   * Computes a hash code from attributes: {@code stopTimeoutInMillis}, {@code version}, {@code timeout}, {@code net}, {@code cmdOptions}, {@code password}, {@code userName}, {@code isVerbose}, {@code databaseName}, {@code collectionName}, {@code query}, {@code queryFile}, {@code readPreference}, {@code isForceTableScan}, {@code archive}, {@code isDumpDbUsersAndRoles}, {@code isGzip}, {@code isRepair}, {@code out}, {@code isOplog}, {@code excludeCollection}, {@code excludeCollectionWithPrefix}, {@code numberOfParallelCollections}, {@code pidFile}, {@code supportConfig}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(stopTimeoutInMillis);
    h += (h << 5) + version.hashCode();
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + net.hashCode();
    h += (h << 5) + cmdOptions.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Boolean.hashCode(isVerbose);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(collectionName);
    h += (h << 5) + Objects.hashCode(query);
    h += (h << 5) + Objects.hashCode(queryFile);
    h += (h << 5) + Objects.hashCode(readPreference);
    h += (h << 5) + Boolean.hashCode(isForceTableScan);
    h += (h << 5) + Objects.hashCode(archive);
    h += (h << 5) + Boolean.hashCode(isDumpDbUsersAndRoles);
    h += (h << 5) + Boolean.hashCode(isGzip);
    h += (h << 5) + Boolean.hashCode(isRepair);
    h += (h << 5) + Objects.hashCode(out);
    h += (h << 5) + Boolean.hashCode(isOplog);
    h += (h << 5) + Objects.hashCode(excludeCollection);
    h += (h << 5) + Objects.hashCode(excludeCollectionWithPrefix);
    h += (h << 5) + Objects.hashCode(numberOfParallelCollections);
    h += (h << 5) + pidFile.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoDumpConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongoDumpConfig{");
    if (stopTimeoutInMillis != null) {
      builder.append("stopTimeoutInMillis=").append(stopTimeoutInMillis);
    }
    if (builder.length() > 16) builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("timeout=").append(timeout);
    builder.append(", ");
    builder.append("net=").append(net);
    builder.append(", ");
    builder.append("cmdOptions=").append(cmdOptions);
    builder.append(", ");
    builder.append("password=").append(password);
    builder.append(", ");
    builder.append("userName=").append(userName);
    builder.append(", ");
    builder.append("isVerbose=").append(isVerbose);
    if (databaseName != null) {
      builder.append(", ");
      builder.append("databaseName=").append(databaseName);
    }
    if (collectionName != null) {
      builder.append(", ");
      builder.append("collectionName=").append(collectionName);
    }
    if (query != null) {
      builder.append(", ");
      builder.append("query=").append(query);
    }
    if (queryFile != null) {
      builder.append(", ");
      builder.append("queryFile=").append(queryFile);
    }
    if (readPreference != null) {
      builder.append(", ");
      builder.append("readPreference=").append(readPreference);
    }
    builder.append(", ");
    builder.append("isForceTableScan=").append(isForceTableScan);
    if (archive != null) {
      builder.append(", ");
      builder.append("archive=").append(archive);
    }
    builder.append(", ");
    builder.append("isDumpDbUsersAndRoles=").append(isDumpDbUsersAndRoles);
    builder.append(", ");
    builder.append("isGzip=").append(isGzip);
    builder.append(", ");
    builder.append("isRepair=").append(isRepair);
    if (out != null) {
      builder.append(", ");
      builder.append("out=").append(out);
    }
    builder.append(", ");
    builder.append("isOplog=").append(isOplog);
    if (excludeCollection != null) {
      builder.append(", ");
      builder.append("excludeCollection=").append(excludeCollection);
    }
    if (excludeCollectionWithPrefix != null) {
      builder.append(", ");
      builder.append("excludeCollectionWithPrefix=").append(excludeCollectionWithPrefix);
    }
    if (numberOfParallelCollections != null) {
      builder.append(", ");
      builder.append("numberOfParallelCollections=").append(numberOfParallelCollections);
    }
    builder.append(", ");
    builder.append("pidFile=").append(pidFile);
    builder.append(", ");
    builder.append("supportConfig=").append(supportConfig);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoDumpConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoDumpConfig instance
   */
  public static ImmutableMongoDumpConfig copyOf(MongoDumpConfig instance) {
    if (instance instanceof ImmutableMongoDumpConfig) {
      return (ImmutableMongoDumpConfig) instance;
    }
    return ImmutableMongoDumpConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoDumpConfig ImmutableMongoDumpConfig}.
   * <pre>
   * ImmutableMongoDumpConfig.builder()
   *    .stopTimeoutInMillis(long) // optional {@link MongoDumpConfig#stopTimeoutInMillis() stopTimeoutInMillis}
   *    .version(de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion) // required {@link MongoDumpConfig#version() version}
   *    .timeout(de.flapdoodle.embed.mongo.config.Timeout) // optional {@link MongoDumpConfig#timeout() timeout}
   *    .net(de.flapdoodle.embed.mongo.config.Net) // optional {@link MongoDumpConfig#net() net}
   *    .cmdOptions(de.flapdoodle.embed.mongo.config.MongoCmdOptions) // optional {@link MongoDumpConfig#cmdOptions() cmdOptions}
   *    .password(String) // optional {@link MongoDumpConfig#password() password}
   *    .userName(String) // optional {@link MongoDumpConfig#userName() userName}
   *    .isVerbose(boolean) // optional {@link MongoDumpConfig#isVerbose() isVerbose}
   *    .databaseName(String) // optional {@link MongoDumpConfig#getDatabaseName() databaseName}
   *    .collectionName(String) // optional {@link MongoDumpConfig#getCollectionName() collectionName}
   *    .query(String) // optional {@link MongoDumpConfig#getQuery() query}
   *    .queryFile(String) // optional {@link MongoDumpConfig#getQueryFile() queryFile}
   *    .readPreference(String) // optional {@link MongoDumpConfig#getReadPreference() readPreference}
   *    .isForceTableScan(boolean) // optional {@link MongoDumpConfig#isForceTableScan() isForceTableScan}
   *    .archive(String) // optional {@link MongoDumpConfig#getArchive() archive}
   *    .isDumpDbUsersAndRoles(boolean) // optional {@link MongoDumpConfig#isDumpDbUsersAndRoles() isDumpDbUsersAndRoles}
   *    .isGzip(boolean) // optional {@link MongoDumpConfig#isGzip() isGzip}
   *    .isRepair(boolean) // optional {@link MongoDumpConfig#isRepair() isRepair}
   *    .out(String) // optional {@link MongoDumpConfig#getOut() out}
   *    .isOplog(boolean) // optional {@link MongoDumpConfig#isOplog() isOplog}
   *    .excludeCollection(String) // optional {@link MongoDumpConfig#getExcludeCollection() excludeCollection}
   *    .excludeCollectionWithPrefix(String) // optional {@link MongoDumpConfig#getExcludeCollectionWithPrefix() excludeCollectionWithPrefix}
   *    .numberOfParallelCollections(int) // optional {@link MongoDumpConfig#getNumberOfParallelCollections() numberOfParallelCollections}
   *    .pidFile(String) // optional {@link MongoDumpConfig#pidFile() pidFile}
   *    .supportConfig(de.flapdoodle.embed.process.config.SupportConfig) // optional {@link MongoDumpConfig#supportConfig() supportConfig}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoDumpConfig builder
   */
  public static ImmutableMongoDumpConfig.Builder builder() {
    return new ImmutableMongoDumpConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoDumpConfig ImmutableMongoDumpConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoDumpConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long OPT_BIT_IS_VERBOSE = 0x1L;
    private static final long OPT_BIT_IS_FORCE_TABLE_SCAN = 0x2L;
    private static final long OPT_BIT_IS_DUMP_DB_USERS_AND_ROLES = 0x4L;
    private static final long OPT_BIT_IS_GZIP = 0x8L;
    private static final long OPT_BIT_IS_REPAIR = 0x10L;
    private static final long OPT_BIT_IS_OPLOG = 0x20L;
    private long initBits = 0x1L;
    private long optBits;

    private Long stopTimeoutInMillis;
    private IFeatureAwareVersion version;
    private Timeout timeout;
    private Net net;
    private MongoCmdOptions cmdOptions;
    private String password;
    private String userName;
    private boolean isVerbose;
    private String databaseName;
    private String collectionName;
    private String query;
    private String queryFile;
    private String readPreference;
    private boolean isForceTableScan;
    private String archive;
    private boolean isDumpDbUsersAndRoles;
    private boolean isGzip;
    private boolean isRepair;
    private String out;
    private boolean isOplog;
    private String excludeCollection;
    private String excludeCollectionWithPrefix;
    private Integer numberOfParallelCollections;
    private String pidFile;
    private SupportConfig supportConfig;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoDumpConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoDumpConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.config.MongoCommonConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoCommonConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.config.ExecutableProcessConfig} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecutableProcessConfig instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MongoDumpConfig) {
        MongoDumpConfig instance = (MongoDumpConfig) object;
        isOplog(instance.isOplog());
        Optional<String> excludeCollectionOptional = instance.getExcludeCollection();
        if (excludeCollectionOptional.isPresent()) {
          excludeCollection(excludeCollectionOptional);
        }
        isForceTableScan(instance.isForceTableScan());
        Optional<String> databaseNameOptional = instance.getDatabaseName();
        if (databaseNameOptional.isPresent()) {
          databaseName(databaseNameOptional);
        }
        isGzip(instance.isGzip());
        if ((bits & 0x1L) == 0) {
          timeout(instance.timeout());
          bits |= 0x1L;
        }
        Optional<String> collectionNameOptional = instance.getCollectionName();
        if (collectionNameOptional.isPresent()) {
          collectionName(collectionNameOptional);
        }
        Optional<String> outOptional = instance.getOut();
        if (outOptional.isPresent()) {
          out(outOptional);
        }
        if ((bits & 0x2L) == 0) {
          password(instance.password());
          bits |= 0x2L;
        }
        Optional<String> excludeCollectionWithPrefixOptional = instance.getExcludeCollectionWithPrefix();
        if (excludeCollectionWithPrefixOptional.isPresent()) {
          excludeCollectionWithPrefix(excludeCollectionWithPrefixOptional);
        }
        OptionalInt numberOfParallelCollectionsOptional = instance.getNumberOfParallelCollections();
        if (numberOfParallelCollectionsOptional.isPresent()) {
          numberOfParallelCollections(numberOfParallelCollectionsOptional);
        }
        if ((bits & 0x4L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          net(instance.net());
          bits |= 0x10L;
        }
        Optional<String> queryFileOptional = instance.getQueryFile();
        if (queryFileOptional.isPresent()) {
          queryFile(queryFileOptional);
        }
        isVerbose(instance.isVerbose());
        Optional<String> queryOptional = instance.getQuery();
        if (queryOptional.isPresent()) {
          query(queryOptional);
        }
        Optional<String> archiveOptional = instance.getArchive();
        if (archiveOptional.isPresent()) {
          archive(archiveOptional);
        }
        if ((bits & 0x20L) == 0) {
          userName(instance.userName());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          version(instance.version());
          bits |= 0x40L;
        }
        isRepair(instance.isRepair());
        if ((bits & 0x80L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x80L;
        }
        isDumpDbUsersAndRoles(instance.isDumpDbUsersAndRoles());
        Optional<String> readPreferenceOptional = instance.getReadPreference();
        if (readPreferenceOptional.isPresent()) {
          readPreference(readPreferenceOptional);
        }
        if ((bits & 0x100L) == 0) {
          cmdOptions(instance.cmdOptions());
          bits |= 0x100L;
        }
      }
      if (object instanceof MongoCommonConfig) {
        MongoCommonConfig instance = (MongoCommonConfig) object;
        if ((bits & 0x2L) == 0) {
          password(instance.password());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x100L) == 0) {
          cmdOptions(instance.cmdOptions());
          bits |= 0x100L;
        }
        if ((bits & 0x10L) == 0) {
          net(instance.net());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          userName(instance.userName());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          version(instance.version());
          bits |= 0x40L;
        }
        if ((bits & 0x1L) == 0) {
          timeout(instance.timeout());
          bits |= 0x1L;
        }
        if ((bits & 0x80L) == 0) {
          pidFile(instance.pidFile());
          bits |= 0x80L;
        }
      }
      if (object instanceof ExecutableProcessConfig) {
        ExecutableProcessConfig instance = (ExecutableProcessConfig) object;
        if ((bits & 0x4L) == 0) {
          supportConfig(instance.supportConfig());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          OptionalLong stopTimeoutInMillisOptional = instance.stopTimeoutInMillis();
          if (stopTimeoutInMillisOptional.isPresent()) {
            stopTimeoutInMillis(stopTimeoutInMillisOptional);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder stopTimeoutInMillis(long stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#stopTimeoutInMillis() stopTimeoutInMillis} to stopTimeoutInMillis.
     * @param stopTimeoutInMillis The value for stopTimeoutInMillis
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stopTimeoutInMillis(OptionalLong stopTimeoutInMillis) {
      this.stopTimeoutInMillis = stopTimeoutInMillis.isPresent() ? stopTimeoutInMillis.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(IFeatureAwareVersion version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timeout(Timeout timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#net() net} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#net() net}.</em>
     * @param net The value for net 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder net(Net net) {
      this.net = Objects.requireNonNull(net, "net");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#cmdOptions() cmdOptions} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#cmdOptions() cmdOptions}.</em>
     * @param cmdOptions The value for cmdOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cmdOptions(MongoCmdOptions cmdOptions) {
      this.cmdOptions = Objects.requireNonNull(cmdOptions, "cmdOptions");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#password() password} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#password() password}.</em>
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#userName() userName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#userName() userName}.</em>
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isVerbose() isVerbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isVerbose() isVerbose}.</em>
     * @param isVerbose The value for isVerbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      optBits |= OPT_BIT_IS_VERBOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getDatabaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for chained invocation
     */
    public final Builder databaseName(String databaseName) {
      this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getDatabaseName() databaseName} to databaseName.
     * @param databaseName The value for databaseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder databaseName(Optional<String> databaseName) {
      this.databaseName = databaseName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getCollectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for chained invocation
     */
    public final Builder collectionName(String collectionName) {
      this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getCollectionName() collectionName} to collectionName.
     * @param collectionName The value for collectionName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder collectionName(Optional<String> collectionName) {
      this.collectionName = collectionName.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getQuery() query} to query.
     * @param query The value for query
     * @return {@code this} builder for chained invocation
     */
    public final Builder query(String query) {
      this.query = Objects.requireNonNull(query, "query");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getQuery() query} to query.
     * @param query The value for query
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder query(Optional<String> query) {
      this.query = query.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getQueryFile() queryFile} to queryFile.
     * @param queryFile The value for queryFile
     * @return {@code this} builder for chained invocation
     */
    public final Builder queryFile(String queryFile) {
      this.queryFile = Objects.requireNonNull(queryFile, "queryFile");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getQueryFile() queryFile} to queryFile.
     * @param queryFile The value for queryFile
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder queryFile(Optional<String> queryFile) {
      this.queryFile = queryFile.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getReadPreference() readPreference} to readPreference.
     * @param readPreference The value for readPreference
     * @return {@code this} builder for chained invocation
     */
    public final Builder readPreference(String readPreference) {
      this.readPreference = Objects.requireNonNull(readPreference, "readPreference");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getReadPreference() readPreference} to readPreference.
     * @param readPreference The value for readPreference
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder readPreference(Optional<String> readPreference) {
      this.readPreference = readPreference.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isForceTableScan() isForceTableScan} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isForceTableScan() isForceTableScan}.</em>
     * @param isForceTableScan The value for isForceTableScan 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isForceTableScan(boolean isForceTableScan) {
      this.isForceTableScan = isForceTableScan;
      optBits |= OPT_BIT_IS_FORCE_TABLE_SCAN;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getArchive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for chained invocation
     */
    public final Builder archive(String archive) {
      this.archive = Objects.requireNonNull(archive, "archive");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getArchive() archive} to archive.
     * @param archive The value for archive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder archive(Optional<String> archive) {
      this.archive = archive.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isDumpDbUsersAndRoles() isDumpDbUsersAndRoles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isDumpDbUsersAndRoles() isDumpDbUsersAndRoles}.</em>
     * @param isDumpDbUsersAndRoles The value for isDumpDbUsersAndRoles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isDumpDbUsersAndRoles(boolean isDumpDbUsersAndRoles) {
      this.isDumpDbUsersAndRoles = isDumpDbUsersAndRoles;
      optBits |= OPT_BIT_IS_DUMP_DB_USERS_AND_ROLES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isGzip() isGzip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isGzip() isGzip}.</em>
     * @param isGzip The value for isGzip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isGzip(boolean isGzip) {
      this.isGzip = isGzip;
      optBits |= OPT_BIT_IS_GZIP;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isRepair() isRepair} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isRepair() isRepair}.</em>
     * @param isRepair The value for isRepair 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isRepair(boolean isRepair) {
      this.isRepair = isRepair;
      optBits |= OPT_BIT_IS_REPAIR;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getOut() out} to out.
     * @param out The value for out
     * @return {@code this} builder for chained invocation
     */
    public final Builder out(String out) {
      this.out = Objects.requireNonNull(out, "out");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getOut() out} to out.
     * @param out The value for out
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder out(Optional<String> out) {
      this.out = out.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#isOplog() isOplog} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#isOplog() isOplog}.</em>
     * @param isOplog The value for isOplog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isOplog(boolean isOplog) {
      this.isOplog = isOplog;
      optBits |= OPT_BIT_IS_OPLOG;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getExcludeCollection() excludeCollection} to excludeCollection.
     * @param excludeCollection The value for excludeCollection
     * @return {@code this} builder for chained invocation
     */
    public final Builder excludeCollection(String excludeCollection) {
      this.excludeCollection = Objects.requireNonNull(excludeCollection, "excludeCollection");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getExcludeCollection() excludeCollection} to excludeCollection.
     * @param excludeCollection The value for excludeCollection
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder excludeCollection(Optional<String> excludeCollection) {
      this.excludeCollection = excludeCollection.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getExcludeCollectionWithPrefix() excludeCollectionWithPrefix} to excludeCollectionWithPrefix.
     * @param excludeCollectionWithPrefix The value for excludeCollectionWithPrefix
     * @return {@code this} builder for chained invocation
     */
    public final Builder excludeCollectionWithPrefix(String excludeCollectionWithPrefix) {
      this.excludeCollectionWithPrefix = Objects.requireNonNull(excludeCollectionWithPrefix, "excludeCollectionWithPrefix");
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getExcludeCollectionWithPrefix() excludeCollectionWithPrefix} to excludeCollectionWithPrefix.
     * @param excludeCollectionWithPrefix The value for excludeCollectionWithPrefix
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder excludeCollectionWithPrefix(Optional<String> excludeCollectionWithPrefix) {
      this.excludeCollectionWithPrefix = excludeCollectionWithPrefix.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getNumberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for chained invocation
     */
    public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections;
      return this;
    }

    /**
     * Initializes the optional value {@link MongoDumpConfig#getNumberOfParallelCollections() numberOfParallelCollections} to numberOfParallelCollections.
     * @param numberOfParallelCollections The value for numberOfParallelCollections
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
      this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? numberOfParallelCollections.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#pidFile() pidFile} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#pidFile() pidFile}.</em>
     * @param pidFile The value for pidFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pidFile(String pidFile) {
      this.pidFile = Objects.requireNonNull(pidFile, "pidFile");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoDumpConfig#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoDumpConfig#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(SupportConfig supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoDumpConfig ImmutableMongoDumpConfig}.
     * @return An immutable instance of MongoDumpConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoDumpConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoDumpConfig(this);
    }

    private boolean isVerboseIsSet() {
      return (optBits & OPT_BIT_IS_VERBOSE) != 0;
    }

    private boolean isForceTableScanIsSet() {
      return (optBits & OPT_BIT_IS_FORCE_TABLE_SCAN) != 0;
    }

    private boolean isDumpDbUsersAndRolesIsSet() {
      return (optBits & OPT_BIT_IS_DUMP_DB_USERS_AND_ROLES) != 0;
    }

    private boolean isGzipIsSet() {
      return (optBits & OPT_BIT_IS_GZIP) != 0;
    }

    private boolean isRepairIsSet() {
      return (optBits & OPT_BIT_IS_REPAIR) != 0;
    }

    private boolean isOplogIsSet() {
      return (optBits & OPT_BIT_IS_OPLOG) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build MongoDumpConfig, some of required attributes are not set " + attributes;
    }
  }
}
