/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.MongoCmdOptions;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="MongoCmdOptions", generator="Immutables")
public final class ImmutableMongoCmdOptions
implements MongoCmdOptions {
    private final int syncDelay;
    private final boolean useDefaultSyncDelay;
    private final String storageEngine;
    private final boolean isVerbose;
    private final boolean useNoPrealloc;
    private final boolean useSmallFiles;
    private final boolean useNoJournal;
    private final boolean enableTextSearch;
    private final boolean auth;
    private final boolean master;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoCmdOptions(Builder builder) {
        this.storageEngine = builder.storageEngine;
        if (builder.syncDelayIsSet()) {
            this.initShim.syncDelay(builder.syncDelay);
        }
        if (builder.useDefaultSyncDelayIsSet()) {
            this.initShim.useDefaultSyncDelay(builder.useDefaultSyncDelay);
        }
        if (builder.isVerboseIsSet()) {
            this.initShim.isVerbose(builder.isVerbose);
        }
        if (builder.useNoPreallocIsSet()) {
            this.initShim.useNoPrealloc(builder.useNoPrealloc);
        }
        if (builder.useSmallFilesIsSet()) {
            this.initShim.useSmallFiles(builder.useSmallFiles);
        }
        if (builder.useNoJournalIsSet()) {
            this.initShim.useNoJournal(builder.useNoJournal);
        }
        if (builder.enableTextSearchIsSet()) {
            this.initShim.enableTextSearch(builder.enableTextSearch);
        }
        if (builder.authIsSet()) {
            this.initShim.auth(builder.auth);
        }
        if (builder.masterIsSet()) {
            this.initShim.master(builder.master);
        }
        this.syncDelay = this.initShim.syncDelay();
        this.useDefaultSyncDelay = this.initShim.useDefaultSyncDelay();
        this.isVerbose = this.initShim.isVerbose();
        this.useNoPrealloc = this.initShim.useNoPrealloc();
        this.useSmallFiles = this.initShim.useSmallFiles();
        this.useNoJournal = this.initShim.useNoJournal();
        this.enableTextSearch = this.initShim.enableTextSearch();
        this.auth = this.initShim.auth();
        this.master = this.initShim.master();
        this.initShim = null;
    }

    private ImmutableMongoCmdOptions(int syncDelay, boolean useDefaultSyncDelay, String storageEngine, boolean isVerbose, boolean useNoPrealloc, boolean useSmallFiles, boolean useNoJournal, boolean enableTextSearch, boolean auth, boolean master) {
        this.syncDelay = syncDelay;
        this.useDefaultSyncDelay = useDefaultSyncDelay;
        this.storageEngine = storageEngine;
        this.isVerbose = isVerbose;
        this.useNoPrealloc = useNoPrealloc;
        this.useSmallFiles = useSmallFiles;
        this.useNoJournal = useNoJournal;
        this.enableTextSearch = enableTextSearch;
        this.auth = auth;
        this.master = master;
        this.initShim = null;
    }

    private int syncDelayInitialize() {
        return MongoCmdOptions.super.syncDelay();
    }

    private boolean useDefaultSyncDelayInitialize() {
        return MongoCmdOptions.super.useDefaultSyncDelay();
    }

    private boolean isVerboseInitialize() {
        return MongoCmdOptions.super.isVerbose();
    }

    private boolean useNoPreallocInitialize() {
        return MongoCmdOptions.super.useNoPrealloc();
    }

    private boolean useSmallFilesInitialize() {
        return MongoCmdOptions.super.useSmallFiles();
    }

    private boolean useNoJournalInitialize() {
        return MongoCmdOptions.super.useNoJournal();
    }

    private boolean enableTextSearchInitialize() {
        return MongoCmdOptions.super.enableTextSearch();
    }

    private boolean authInitialize() {
        return MongoCmdOptions.super.auth();
    }

    private boolean masterInitialize() {
        return MongoCmdOptions.super.master();
    }

    @Override
    public int syncDelay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.syncDelay() : this.syncDelay;
    }

    @Override
    public boolean useDefaultSyncDelay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useDefaultSyncDelay() : this.useDefaultSyncDelay;
    }

    @Override
    public Optional<String> storageEngine() {
        return Optional.ofNullable(this.storageEngine);
    }

    @Override
    public boolean isVerbose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isVerbose() : this.isVerbose;
    }

    @Override
    public boolean useNoPrealloc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useNoPrealloc() : this.useNoPrealloc;
    }

    @Override
    public boolean useSmallFiles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useSmallFiles() : this.useSmallFiles;
    }

    @Override
    public boolean useNoJournal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useNoJournal() : this.useNoJournal;
    }

    @Override
    public boolean enableTextSearch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enableTextSearch() : this.enableTextSearch;
    }

    @Override
    public boolean auth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.auth() : this.auth;
    }

    @Override
    public boolean master() {
        InitShim shim = this.initShim;
        return shim != null ? shim.master() : this.master;
    }

    public final ImmutableMongoCmdOptions withSyncDelay(int value) {
        if (this.syncDelay == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(value, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withUseDefaultSyncDelay(boolean value) {
        if (this.useDefaultSyncDelay == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, value, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withStorageEngine(String value) {
        String newValue = Objects.requireNonNull(value, "storageEngine");
        if (Objects.equals(this.storageEngine, newValue)) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, newValue, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withStorageEngine(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.storageEngine, value)) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, value, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withIsVerbose(boolean value) {
        if (this.isVerbose == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, value, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withUseNoPrealloc(boolean value) {
        if (this.useNoPrealloc == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, value, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withUseSmallFiles(boolean value) {
        if (this.useSmallFiles == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, value, this.useNoJournal, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withUseNoJournal(boolean value) {
        if (this.useNoJournal == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, value, this.enableTextSearch, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withEnableTextSearch(boolean value) {
        if (this.enableTextSearch == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, value, this.auth, this.master);
    }

    public final ImmutableMongoCmdOptions withAuth(boolean value) {
        if (this.auth == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, value, this.master);
    }

    public final ImmutableMongoCmdOptions withMaster(boolean value) {
        if (this.master == value) {
            return this;
        }
        return new ImmutableMongoCmdOptions(this.syncDelay, this.useDefaultSyncDelay, this.storageEngine, this.isVerbose, this.useNoPrealloc, this.useSmallFiles, this.useNoJournal, this.enableTextSearch, this.auth, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoCmdOptions && this.equalTo(0, (ImmutableMongoCmdOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoCmdOptions another) {
        return this.syncDelay == another.syncDelay && this.useDefaultSyncDelay == another.useDefaultSyncDelay && Objects.equals(this.storageEngine, another.storageEngine) && this.isVerbose == another.isVerbose && this.useNoPrealloc == another.useNoPrealloc && this.useSmallFiles == another.useSmallFiles && this.useNoJournal == another.useNoJournal && this.enableTextSearch == another.enableTextSearch && this.auth == another.auth && this.master == another.master;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.syncDelay;
        h += (h << 5) + Boolean.hashCode(this.useDefaultSyncDelay);
        h += (h << 5) + Objects.hashCode(this.storageEngine);
        h += (h << 5) + Boolean.hashCode(this.isVerbose);
        h += (h << 5) + Boolean.hashCode(this.useNoPrealloc);
        h += (h << 5) + Boolean.hashCode(this.useSmallFiles);
        h += (h << 5) + Boolean.hashCode(this.useNoJournal);
        h += (h << 5) + Boolean.hashCode(this.enableTextSearch);
        h += (h << 5) + Boolean.hashCode(this.auth);
        h += (h << 5) + Boolean.hashCode(this.master);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoCmdOptions{");
        builder.append("syncDelay=").append(this.syncDelay);
        builder.append(", ");
        builder.append("useDefaultSyncDelay=").append(this.useDefaultSyncDelay);
        if (this.storageEngine != null) {
            builder.append(", ");
            builder.append("storageEngine=").append(this.storageEngine);
        }
        builder.append(", ");
        builder.append("isVerbose=").append(this.isVerbose);
        builder.append(", ");
        builder.append("useNoPrealloc=").append(this.useNoPrealloc);
        builder.append(", ");
        builder.append("useSmallFiles=").append(this.useSmallFiles);
        builder.append(", ");
        builder.append("useNoJournal=").append(this.useNoJournal);
        builder.append(", ");
        builder.append("enableTextSearch=").append(this.enableTextSearch);
        builder.append(", ");
        builder.append("auth=").append(this.auth);
        builder.append(", ");
        builder.append("master=").append(this.master);
        return builder.append("}").toString();
    }

    public static ImmutableMongoCmdOptions copyOf(MongoCmdOptions instance) {
        if (instance instanceof ImmutableMongoCmdOptions) {
            return (ImmutableMongoCmdOptions)instance;
        }
        return ImmutableMongoCmdOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoCmdOptions", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SYNC_DELAY = 1L;
        private static final long OPT_BIT_USE_DEFAULT_SYNC_DELAY = 2L;
        private static final long OPT_BIT_IS_VERBOSE = 4L;
        private static final long OPT_BIT_USE_NO_PREALLOC = 8L;
        private static final long OPT_BIT_USE_SMALL_FILES = 16L;
        private static final long OPT_BIT_USE_NO_JOURNAL = 32L;
        private static final long OPT_BIT_ENABLE_TEXT_SEARCH = 64L;
        private static final long OPT_BIT_AUTH = 128L;
        private static final long OPT_BIT_MASTER = 256L;
        private long optBits;
        private int syncDelay;
        private boolean useDefaultSyncDelay;
        private String storageEngine;
        private boolean isVerbose;
        private boolean useNoPrealloc;
        private boolean useSmallFiles;
        private boolean useNoJournal;
        private boolean enableTextSearch;
        private boolean auth;
        private boolean master;

        private Builder() {
        }

        public final Builder from(MongoCmdOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.syncDelay(instance.syncDelay());
            this.useDefaultSyncDelay(instance.useDefaultSyncDelay());
            Optional<String> storageEngineOptional = instance.storageEngine();
            if (storageEngineOptional.isPresent()) {
                this.storageEngine(storageEngineOptional);
            }
            this.isVerbose(instance.isVerbose());
            this.useNoPrealloc(instance.useNoPrealloc());
            this.useSmallFiles(instance.useSmallFiles());
            this.useNoJournal(instance.useNoJournal());
            this.enableTextSearch(instance.enableTextSearch());
            this.auth(instance.auth());
            this.master(instance.master());
            return this;
        }

        public final Builder syncDelay(int syncDelay) {
            this.syncDelay = syncDelay;
            this.optBits |= 1L;
            return this;
        }

        public final Builder useDefaultSyncDelay(boolean useDefaultSyncDelay) {
            this.useDefaultSyncDelay = useDefaultSyncDelay;
            this.optBits |= 2L;
            return this;
        }

        public final Builder storageEngine(String storageEngine) {
            this.storageEngine = Objects.requireNonNull(storageEngine, "storageEngine");
            return this;
        }

        public final Builder storageEngine(Optional<String> storageEngine) {
            this.storageEngine = storageEngine.orElse(null);
            return this;
        }

        public final Builder isVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            this.optBits |= 4L;
            return this;
        }

        public final Builder useNoPrealloc(boolean useNoPrealloc) {
            this.useNoPrealloc = useNoPrealloc;
            this.optBits |= 8L;
            return this;
        }

        public final Builder useSmallFiles(boolean useSmallFiles) {
            this.useSmallFiles = useSmallFiles;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder useNoJournal(boolean useNoJournal) {
            this.useNoJournal = useNoJournal;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder enableTextSearch(boolean enableTextSearch) {
            this.enableTextSearch = enableTextSearch;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder auth(boolean auth) {
            this.auth = auth;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder master(boolean master) {
            this.master = master;
            this.optBits |= 0x100L;
            return this;
        }

        public ImmutableMongoCmdOptions build() {
            return new ImmutableMongoCmdOptions(this);
        }

        private boolean syncDelayIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean useDefaultSyncDelayIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isVerboseIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean useNoPreallocIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean useSmallFilesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean useNoJournalIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean enableTextSearchIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean authIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean masterIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }
    }

    @Generated(from="MongoCmdOptions", generator="Immutables")
    private final class InitShim {
        private byte syncDelayBuildStage = 0;
        private int syncDelay;
        private byte useDefaultSyncDelayBuildStage = 0;
        private boolean useDefaultSyncDelay;
        private byte isVerboseBuildStage = 0;
        private boolean isVerbose;
        private byte useNoPreallocBuildStage = 0;
        private boolean useNoPrealloc;
        private byte useSmallFilesBuildStage = 0;
        private boolean useSmallFiles;
        private byte useNoJournalBuildStage = 0;
        private boolean useNoJournal;
        private byte enableTextSearchBuildStage = 0;
        private boolean enableTextSearch;
        private byte authBuildStage = 0;
        private boolean auth;
        private byte masterBuildStage = 0;
        private boolean master;

        private InitShim() {
        }

        int syncDelay() {
            if (this.syncDelayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.syncDelayBuildStage == 0) {
                this.syncDelayBuildStage = (byte)-1;
                this.syncDelay = ImmutableMongoCmdOptions.this.syncDelayInitialize();
                this.syncDelayBuildStage = 1;
            }
            return this.syncDelay;
        }

        void syncDelay(int syncDelay) {
            this.syncDelay = syncDelay;
            this.syncDelayBuildStage = 1;
        }

        boolean useDefaultSyncDelay() {
            if (this.useDefaultSyncDelayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useDefaultSyncDelayBuildStage == 0) {
                this.useDefaultSyncDelayBuildStage = (byte)-1;
                this.useDefaultSyncDelay = ImmutableMongoCmdOptions.this.useDefaultSyncDelayInitialize();
                this.useDefaultSyncDelayBuildStage = 1;
            }
            return this.useDefaultSyncDelay;
        }

        void useDefaultSyncDelay(boolean useDefaultSyncDelay) {
            this.useDefaultSyncDelay = useDefaultSyncDelay;
            this.useDefaultSyncDelayBuildStage = 1;
        }

        boolean isVerbose() {
            if (this.isVerboseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isVerboseBuildStage == 0) {
                this.isVerboseBuildStage = (byte)-1;
                this.isVerbose = ImmutableMongoCmdOptions.this.isVerboseInitialize();
                this.isVerboseBuildStage = 1;
            }
            return this.isVerbose;
        }

        void isVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            this.isVerboseBuildStage = 1;
        }

        boolean useNoPrealloc() {
            if (this.useNoPreallocBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useNoPreallocBuildStage == 0) {
                this.useNoPreallocBuildStage = (byte)-1;
                this.useNoPrealloc = ImmutableMongoCmdOptions.this.useNoPreallocInitialize();
                this.useNoPreallocBuildStage = 1;
            }
            return this.useNoPrealloc;
        }

        void useNoPrealloc(boolean useNoPrealloc) {
            this.useNoPrealloc = useNoPrealloc;
            this.useNoPreallocBuildStage = 1;
        }

        boolean useSmallFiles() {
            if (this.useSmallFilesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useSmallFilesBuildStage == 0) {
                this.useSmallFilesBuildStage = (byte)-1;
                this.useSmallFiles = ImmutableMongoCmdOptions.this.useSmallFilesInitialize();
                this.useSmallFilesBuildStage = 1;
            }
            return this.useSmallFiles;
        }

        void useSmallFiles(boolean useSmallFiles) {
            this.useSmallFiles = useSmallFiles;
            this.useSmallFilesBuildStage = 1;
        }

        boolean useNoJournal() {
            if (this.useNoJournalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useNoJournalBuildStage == 0) {
                this.useNoJournalBuildStage = (byte)-1;
                this.useNoJournal = ImmutableMongoCmdOptions.this.useNoJournalInitialize();
                this.useNoJournalBuildStage = 1;
            }
            return this.useNoJournal;
        }

        void useNoJournal(boolean useNoJournal) {
            this.useNoJournal = useNoJournal;
            this.useNoJournalBuildStage = 1;
        }

        boolean enableTextSearch() {
            if (this.enableTextSearchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enableTextSearchBuildStage == 0) {
                this.enableTextSearchBuildStage = (byte)-1;
                this.enableTextSearch = ImmutableMongoCmdOptions.this.enableTextSearchInitialize();
                this.enableTextSearchBuildStage = 1;
            }
            return this.enableTextSearch;
        }

        void enableTextSearch(boolean enableTextSearch) {
            this.enableTextSearch = enableTextSearch;
            this.enableTextSearchBuildStage = 1;
        }

        boolean auth() {
            if (this.authBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authBuildStage == 0) {
                this.authBuildStage = (byte)-1;
                this.auth = ImmutableMongoCmdOptions.this.authInitialize();
                this.authBuildStage = 1;
            }
            return this.auth;
        }

        void auth(boolean auth) {
            this.auth = auth;
            this.authBuildStage = 1;
        }

        boolean master() {
            if (this.masterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.masterBuildStage == 0) {
                this.masterBuildStage = (byte)-1;
                this.master = ImmutableMongoCmdOptions.this.masterInitialize();
                this.masterBuildStage = 1;
            }
            return this.master;
        }

        void master(boolean master) {
            this.master = master;
            this.masterBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.syncDelayBuildStage == -1) {
                attributes.add("syncDelay");
            }
            if (this.useDefaultSyncDelayBuildStage == -1) {
                attributes.add("useDefaultSyncDelay");
            }
            if (this.isVerboseBuildStage == -1) {
                attributes.add("isVerbose");
            }
            if (this.useNoPreallocBuildStage == -1) {
                attributes.add("useNoPrealloc");
            }
            if (this.useSmallFilesBuildStage == -1) {
                attributes.add("useSmallFiles");
            }
            if (this.useNoJournalBuildStage == -1) {
                attributes.add("useNoJournal");
            }
            if (this.enableTextSearchBuildStage == -1) {
                attributes.add("enableTextSearch");
            }
            if (this.authBuildStage == -1) {
                attributes.add("auth");
            }
            if (this.masterBuildStage == -1) {
                attributes.add("master");
            }
            return "Cannot build MongoCmdOptions, attribute initializers form cycle " + attributes;
        }
    }
}

