package de.flapdoodle.embed.mongo.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Storage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStorage.builder()}.
 */
@Generated(from = "Storage", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutableStorage extends Storage {
  private final int oplogSize;
  private final String replSetName;

  private ImmutableStorage(ImmutableStorage.Builder builder) {
    this.replSetName = builder.replSetName;
    this.oplogSize = builder.oplogSizeIsSet()
        ? builder.oplogSize
        : super.getOplogSize();
  }

  private ImmutableStorage(int oplogSize, String replSetName) {
    this.oplogSize = oplogSize;
    this.replSetName = replSetName;
  }

  /**
   * @return The value of the {@code oplogSize} attribute
   */
  @Override
  public int getOplogSize() {
    return oplogSize;
  }

  /**
   * @return The value of the {@code replSetName} attribute
   */
  @Override
  public String getReplSetName() {
    return replSetName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Storage#getOplogSize() oplogSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for oplogSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStorage withOplogSize(int value) {
    if (this.oplogSize == value) return this;
    return new ImmutableStorage(value, this.replSetName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Storage#getReplSetName() replSetName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for replSetName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStorage withReplSetName(String value) {
    String newValue = Objects.requireNonNull(value, "replSetName");
    if (this.replSetName.equals(newValue)) return this;
    return new ImmutableStorage(this.oplogSize, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStorage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStorage
        && equalTo(0, (ImmutableStorage) another);
  }

  private boolean equalTo(int synthetic, ImmutableStorage another) {
    return oplogSize == another.oplogSize
        && replSetName.equals(another.replSetName);
  }

  /**
   * Computes a hash code from attributes: {@code oplogSize}, {@code replSetName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + oplogSize;
    h += (h << 5) + replSetName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Storage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Storage{"
        + "oplogSize=" + oplogSize
        + ", replSetName=" + replSetName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Storage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Storage instance
   */
  public static ImmutableStorage copyOf(Storage instance) {
    if (instance instanceof ImmutableStorage) {
      return (ImmutableStorage) instance;
    }
    return ImmutableStorage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStorage ImmutableStorage}.
   * <pre>
   * ImmutableStorage.builder()
   *    .oplogSize(int) // optional {@link Storage#getOplogSize() oplogSize}
   *    .replSetName(String) // required {@link Storage#getReplSetName() replSetName}
   *    .build();
   * </pre>
   * @return A new ImmutableStorage builder
   */
  public static ImmutableStorage.Builder builder() {
    return new ImmutableStorage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStorage ImmutableStorage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Storage", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_REPL_SET_NAME = 0x1L;
    private static final long OPT_BIT_OPLOG_SIZE = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private int oplogSize;
    private String replSetName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Storage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Storage instance) {
      Objects.requireNonNull(instance, "instance");
      oplogSize(instance.getOplogSize());
      replSetName(instance.getReplSetName());
      return this;
    }

    /**
     * Initializes the value for the {@link Storage#getOplogSize() oplogSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Storage#getOplogSize() oplogSize}.</em>
     * @param oplogSize The value for oplogSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oplogSize(int oplogSize) {
      this.oplogSize = oplogSize;
      optBits |= OPT_BIT_OPLOG_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link Storage#getReplSetName() replSetName} attribute.
     * @param replSetName The value for replSetName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replSetName(String replSetName) {
      this.replSetName = Objects.requireNonNull(replSetName, "replSetName");
      initBits &= ~INIT_BIT_REPL_SET_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStorage ImmutableStorage}.
     * @return An immutable instance of Storage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStorage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStorage(this);
    }

    private boolean oplogSizeIsSet() {
      return (optBits & OPT_BIT_OPLOG_SIZE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPL_SET_NAME) != 0) attributes.add("replSetName");
      return "Cannot build Storage, some of required attributes are not set " + attributes;
    }
  }
}
