package de.flapdoodle.embed.mongo.types;

import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _DistributionBaseUrl}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code DistributionBaseUrl.of()}.
 */
@Generated(from = "_DistributionBaseUrl", generator = "Immutables")
@SuppressWarnings({"all"})
public final class DistributionBaseUrl extends de.flapdoodle.embed.mongo.types._DistributionBaseUrl {
  private final String value;

  private DistributionBaseUrl(String value) {
    this.value = Objects.requireNonNull(value, "value");
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String value() {
    return value;
  }

  /**
   * This instance is equal to all instances of {@code DistributionBaseUrl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DistributionBaseUrl
        && equalTo(0, (DistributionBaseUrl) another);
  }

  private boolean equalTo(int synthetic, DistributionBaseUrl another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DistributionBaseUrl} instance.
   * @param value The value for the {@code value} attribute
   * @return An immutable DistributionBaseUrl instance
   */
  public static DistributionBaseUrl of(String value) {
    return new DistributionBaseUrl(value);
  }
}
