/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.transitions.CommandProcessArguments;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongodProcessArguments;
import de.flapdoodle.embed.mongo.types.DatabaseDir;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.List;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MongodProcessArguments
implements CommandProcessArguments<MongodArguments>,
HasLabel {
    @Value.Auxiliary
    public String transitionLabel() {
        return "Create mongod arguments";
    }

    @Value.Default
    public StateID<ProcessArguments> destination() {
        return StateID.of(ProcessArguments.class);
    }

    @Override
    @Value.Default
    public StateID<MongodArguments> arguments() {
        return StateID.of(MongodArguments.class);
    }

    @Value.Default
    public StateID<Platform> platform() {
        return StateID.of(Platform.class);
    }

    @Value.Default
    public StateID<Version> version() {
        return StateID.of(Version.class);
    }

    @Value.Default
    public StateID<Net> net() {
        return StateID.of(Net.class);
    }

    @Value.Default
    public StateID<DatabaseDir> databaseDir() {
        return StateID.of(DatabaseDir.class);
    }

    @Value.Auxiliary
    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.arguments(), this.platform(), this.version(), this.net(), this.databaseDir()});
    }

    public State<ProcessArguments> result(StateLookup lookup) {
        MongodArguments arguments = (MongodArguments)lookup.of(this.arguments());
        Platform platform = (Platform)lookup.of(this.platform());
        Version version = (Version)lookup.of(this.version());
        Preconditions.checkArgument((boolean)(version instanceof IFeatureAwareVersion), (String)"invalid type: %s does not implement %s", (Object[])new Object[]{version, IFeatureAwareVersion.class});
        IFeatureAwareVersion featureAwareVersion = (IFeatureAwareVersion)version;
        Net net = (Net)lookup.of(this.net());
        DatabaseDir databaseDir = (DatabaseDir)((Object)lookup.of(this.databaseDir()));
        List<String> commandLine = arguments.asArguments(platform, featureAwareVersion, net, databaseDir);
        return State.of((Object)ProcessArguments.of(commandLine), (TearDown[])new TearDown[0]);
    }

    public static ImmutableMongodProcessArguments withDefaults() {
        return MongodProcessArguments.builder().build();
    }

    public static ImmutableMongodProcessArguments.Builder builder() {
        return ImmutableMongodProcessArguments.builder();
    }
}

