package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.config.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Immutable implementation of {@link MongodArguments}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongodArguments.builder()}.
 */
@SuppressWarnings({"all"})
public final class ImmutableMongodArguments extends MongodArguments {
  private final int syncDelay;
  private final boolean useDefaultSyncDelay;
  private final String storageEngine;
  private final boolean isVerbose;
  private final int verbosityLevel;
  private final boolean isQuiet;
  private final boolean useNoPrealloc;
  private final boolean useSmallFiles;
  private final boolean useNoJournal;
  private final boolean enableTextSearch;
  private final boolean auth;
  private final boolean master;
  private final Storage replication;
  private final boolean isConfigServer;
  private final boolean isShardServer;
  private final Map<String, String> params;
  private final Map<String, String> args;

  private ImmutableMongodArguments(ImmutableMongodArguments.Builder builder) {
    this.storageEngine = builder.storageEngine;
    this.replication = builder.replication;
    this.params = createUnmodifiableMap(false, false, builder.params);
    this.args = createUnmodifiableMap(false, false, builder.args);
    if (builder.syncDelayIsSet()) {
      initShim.syncDelay(builder.syncDelay);
    }
    if (builder.useDefaultSyncDelayIsSet()) {
      initShim.useDefaultSyncDelay(builder.useDefaultSyncDelay);
    }
    if (builder.isVerboseIsSet()) {
      initShim.isVerbose(builder.isVerbose);
    }
    if (builder.verbosityLevelIsSet()) {
      initShim.verbosityLevel(builder.verbosityLevel);
    }
    if (builder.isQuietIsSet()) {
      initShim.isQuiet(builder.isQuiet);
    }
    if (builder.useNoPreallocIsSet()) {
      initShim.useNoPrealloc(builder.useNoPrealloc);
    }
    if (builder.useSmallFilesIsSet()) {
      initShim.useSmallFiles(builder.useSmallFiles);
    }
    if (builder.useNoJournalIsSet()) {
      initShim.useNoJournal(builder.useNoJournal);
    }
    if (builder.enableTextSearchIsSet()) {
      initShim.enableTextSearch(builder.enableTextSearch);
    }
    if (builder.authIsSet()) {
      initShim.auth(builder.auth);
    }
    if (builder.masterIsSet()) {
      initShim.master(builder.master);
    }
    if (builder.isConfigServerIsSet()) {
      initShim.isConfigServer(builder.isConfigServer);
    }
    if (builder.isShardServerIsSet()) {
      initShim.isShardServer(builder.isShardServer);
    }
    this.syncDelay = initShim.syncDelay();
    this.useDefaultSyncDelay = initShim.useDefaultSyncDelay();
    this.isVerbose = initShim.isVerbose();
    this.verbosityLevel = initShim.verbosityLevel();
    this.isQuiet = initShim.isQuiet();
    this.useNoPrealloc = initShim.useNoPrealloc();
    this.useSmallFiles = initShim.useSmallFiles();
    this.useNoJournal = initShim.useNoJournal();
    this.enableTextSearch = initShim.enableTextSearch();
    this.auth = initShim.auth();
    this.master = initShim.master();
    this.isConfigServer = initShim.isConfigServer();
    this.isShardServer = initShim.isShardServer();
    this.initShim = null;
  }

  private ImmutableMongodArguments(
      int syncDelay,
      boolean useDefaultSyncDelay,
      String storageEngine,
      boolean isVerbose,
      int verbosityLevel,
      boolean isQuiet,
      boolean useNoPrealloc,
      boolean useSmallFiles,
      boolean useNoJournal,
      boolean enableTextSearch,
      boolean auth,
      boolean master,
      Storage replication,
      boolean isConfigServer,
      boolean isShardServer,
      Map<String, String> params,
      Map<String, String> args) {
    this.syncDelay = syncDelay;
    this.useDefaultSyncDelay = useDefaultSyncDelay;
    this.storageEngine = storageEngine;
    this.isVerbose = isVerbose;
    this.verbosityLevel = verbosityLevel;
    this.isQuiet = isQuiet;
    this.useNoPrealloc = useNoPrealloc;
    this.useSmallFiles = useSmallFiles;
    this.useNoJournal = useNoJournal;
    this.enableTextSearch = enableTextSearch;
    this.auth = auth;
    this.master = master;
    this.replication = replication;
    this.isConfigServer = isConfigServer;
    this.isShardServer = isShardServer;
    this.params = params;
    this.args = args;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private byte syncDelayBuildStage = STAGE_UNINITIALIZED;
    private int syncDelay;

    int syncDelay() {
      if (syncDelayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (syncDelayBuildStage == STAGE_UNINITIALIZED) {
        syncDelayBuildStage = STAGE_INITIALIZING;
        this.syncDelay = ImmutableMongodArguments.super.syncDelay();
        syncDelayBuildStage = STAGE_INITIALIZED;
      }
      return this.syncDelay;
    }

    void syncDelay(int syncDelay) {
      this.syncDelay = syncDelay;
      syncDelayBuildStage = STAGE_INITIALIZED;
    }

    private byte useDefaultSyncDelayBuildStage = STAGE_UNINITIALIZED;
    private boolean useDefaultSyncDelay;

    boolean useDefaultSyncDelay() {
      if (useDefaultSyncDelayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useDefaultSyncDelayBuildStage == STAGE_UNINITIALIZED) {
        useDefaultSyncDelayBuildStage = STAGE_INITIALIZING;
        this.useDefaultSyncDelay = ImmutableMongodArguments.super.useDefaultSyncDelay();
        useDefaultSyncDelayBuildStage = STAGE_INITIALIZED;
      }
      return this.useDefaultSyncDelay;
    }

    void useDefaultSyncDelay(boolean useDefaultSyncDelay) {
      this.useDefaultSyncDelay = useDefaultSyncDelay;
      useDefaultSyncDelayBuildStage = STAGE_INITIALIZED;
    }

    private byte isVerboseBuildStage = STAGE_UNINITIALIZED;
    private boolean isVerbose;

    boolean isVerbose() {
      if (isVerboseBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isVerboseBuildStage == STAGE_UNINITIALIZED) {
        isVerboseBuildStage = STAGE_INITIALIZING;
        this.isVerbose = ImmutableMongodArguments.super.isVerbose();
        isVerboseBuildStage = STAGE_INITIALIZED;
      }
      return this.isVerbose;
    }

    void isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      isVerboseBuildStage = STAGE_INITIALIZED;
    }

    private byte verbosityLevelBuildStage = STAGE_UNINITIALIZED;
    private int verbosityLevel;

    int verbosityLevel() {
      if (verbosityLevelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (verbosityLevelBuildStage == STAGE_UNINITIALIZED) {
        verbosityLevelBuildStage = STAGE_INITIALIZING;
        this.verbosityLevel = ImmutableMongodArguments.super.verbosityLevel();
        verbosityLevelBuildStage = STAGE_INITIALIZED;
      }
      return this.verbosityLevel;
    }

    void verbosityLevel(int verbosityLevel) {
      this.verbosityLevel = verbosityLevel;
      verbosityLevelBuildStage = STAGE_INITIALIZED;
    }

    private byte isQuietBuildStage = STAGE_UNINITIALIZED;
    private boolean isQuiet;

    boolean isQuiet() {
      if (isQuietBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isQuietBuildStage == STAGE_UNINITIALIZED) {
        isQuietBuildStage = STAGE_INITIALIZING;
        this.isQuiet = ImmutableMongodArguments.super.isQuiet();
        isQuietBuildStage = STAGE_INITIALIZED;
      }
      return this.isQuiet;
    }

    void isQuiet(boolean isQuiet) {
      this.isQuiet = isQuiet;
      isQuietBuildStage = STAGE_INITIALIZED;
    }

    private byte useNoPreallocBuildStage = STAGE_UNINITIALIZED;
    private boolean useNoPrealloc;

    boolean useNoPrealloc() {
      if (useNoPreallocBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useNoPreallocBuildStage == STAGE_UNINITIALIZED) {
        useNoPreallocBuildStage = STAGE_INITIALIZING;
        this.useNoPrealloc = ImmutableMongodArguments.super.useNoPrealloc();
        useNoPreallocBuildStage = STAGE_INITIALIZED;
      }
      return this.useNoPrealloc;
    }

    void useNoPrealloc(boolean useNoPrealloc) {
      this.useNoPrealloc = useNoPrealloc;
      useNoPreallocBuildStage = STAGE_INITIALIZED;
    }

    private byte useSmallFilesBuildStage = STAGE_UNINITIALIZED;
    private boolean useSmallFiles;

    boolean useSmallFiles() {
      if (useSmallFilesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useSmallFilesBuildStage == STAGE_UNINITIALIZED) {
        useSmallFilesBuildStage = STAGE_INITIALIZING;
        this.useSmallFiles = ImmutableMongodArguments.super.useSmallFiles();
        useSmallFilesBuildStage = STAGE_INITIALIZED;
      }
      return this.useSmallFiles;
    }

    void useSmallFiles(boolean useSmallFiles) {
      this.useSmallFiles = useSmallFiles;
      useSmallFilesBuildStage = STAGE_INITIALIZED;
    }

    private byte useNoJournalBuildStage = STAGE_UNINITIALIZED;
    private boolean useNoJournal;

    boolean useNoJournal() {
      if (useNoJournalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useNoJournalBuildStage == STAGE_UNINITIALIZED) {
        useNoJournalBuildStage = STAGE_INITIALIZING;
        this.useNoJournal = ImmutableMongodArguments.super.useNoJournal();
        useNoJournalBuildStage = STAGE_INITIALIZED;
      }
      return this.useNoJournal;
    }

    void useNoJournal(boolean useNoJournal) {
      this.useNoJournal = useNoJournal;
      useNoJournalBuildStage = STAGE_INITIALIZED;
    }

    private byte enableTextSearchBuildStage = STAGE_UNINITIALIZED;
    private boolean enableTextSearch;

    boolean enableTextSearch() {
      if (enableTextSearchBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (enableTextSearchBuildStage == STAGE_UNINITIALIZED) {
        enableTextSearchBuildStage = STAGE_INITIALIZING;
        this.enableTextSearch = ImmutableMongodArguments.super.enableTextSearch();
        enableTextSearchBuildStage = STAGE_INITIALIZED;
      }
      return this.enableTextSearch;
    }

    void enableTextSearch(boolean enableTextSearch) {
      this.enableTextSearch = enableTextSearch;
      enableTextSearchBuildStage = STAGE_INITIALIZED;
    }

    private byte authBuildStage = STAGE_UNINITIALIZED;
    private boolean auth;

    boolean auth() {
      if (authBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (authBuildStage == STAGE_UNINITIALIZED) {
        authBuildStage = STAGE_INITIALIZING;
        this.auth = ImmutableMongodArguments.super.auth();
        authBuildStage = STAGE_INITIALIZED;
      }
      return this.auth;
    }

    void auth(boolean auth) {
      this.auth = auth;
      authBuildStage = STAGE_INITIALIZED;
    }

    private byte masterBuildStage = STAGE_UNINITIALIZED;
    private boolean master;

    boolean master() {
      if (masterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (masterBuildStage == STAGE_UNINITIALIZED) {
        masterBuildStage = STAGE_INITIALIZING;
        this.master = ImmutableMongodArguments.super.master();
        masterBuildStage = STAGE_INITIALIZED;
      }
      return this.master;
    }

    void master(boolean master) {
      this.master = master;
      masterBuildStage = STAGE_INITIALIZED;
    }

    private byte isConfigServerBuildStage = STAGE_UNINITIALIZED;
    private boolean isConfigServer;

    boolean isConfigServer() {
      if (isConfigServerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isConfigServerBuildStage == STAGE_UNINITIALIZED) {
        isConfigServerBuildStage = STAGE_INITIALIZING;
        this.isConfigServer = ImmutableMongodArguments.super.isConfigServer();
        isConfigServerBuildStage = STAGE_INITIALIZED;
      }
      return this.isConfigServer;
    }

    void isConfigServer(boolean isConfigServer) {
      this.isConfigServer = isConfigServer;
      isConfigServerBuildStage = STAGE_INITIALIZED;
    }

    private byte isShardServerBuildStage = STAGE_UNINITIALIZED;
    private boolean isShardServer;

    boolean isShardServer() {
      if (isShardServerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isShardServerBuildStage == STAGE_UNINITIALIZED) {
        isShardServerBuildStage = STAGE_INITIALIZING;
        this.isShardServer = ImmutableMongodArguments.super.isShardServer();
        isShardServerBuildStage = STAGE_INITIALIZED;
      }
      return this.isShardServer;
    }

    void isShardServer(boolean isShardServer) {
      this.isShardServer = isShardServer;
      isShardServerBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (syncDelayBuildStage == STAGE_INITIALIZING) attributes.add("syncDelay");
      if (useDefaultSyncDelayBuildStage == STAGE_INITIALIZING) attributes.add("useDefaultSyncDelay");
      if (isVerboseBuildStage == STAGE_INITIALIZING) attributes.add("isVerbose");
      if (verbosityLevelBuildStage == STAGE_INITIALIZING) attributes.add("verbosityLevel");
      if (isQuietBuildStage == STAGE_INITIALIZING) attributes.add("isQuiet");
      if (useNoPreallocBuildStage == STAGE_INITIALIZING) attributes.add("useNoPrealloc");
      if (useSmallFilesBuildStage == STAGE_INITIALIZING) attributes.add("useSmallFiles");
      if (useNoJournalBuildStage == STAGE_INITIALIZING) attributes.add("useNoJournal");
      if (enableTextSearchBuildStage == STAGE_INITIALIZING) attributes.add("enableTextSearch");
      if (authBuildStage == STAGE_INITIALIZING) attributes.add("auth");
      if (masterBuildStage == STAGE_INITIALIZING) attributes.add("master");
      if (isConfigServerBuildStage == STAGE_INITIALIZING) attributes.add("isConfigServer");
      if (isShardServerBuildStage == STAGE_INITIALIZING) attributes.add("isShardServer");
      return "Cannot build MongodArguments, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code syncDelay} attribute
   */
  @Override
  public int syncDelay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.syncDelay()
        : this.syncDelay;
  }

  /**
   * @return The value of the {@code useDefaultSyncDelay} attribute
   */
  @Override
  public boolean useDefaultSyncDelay() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useDefaultSyncDelay()
        : this.useDefaultSyncDelay;
  }

  /**
   * @return The value of the {@code storageEngine} attribute
   */
  @Override
  public Optional<String> storageEngine() {
    return Optional.ofNullable(storageEngine);
  }

  /**
   * @return The value of the {@code isVerbose} attribute
   */
  @Override
  public boolean isVerbose() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVerbose()
        : this.isVerbose;
  }

  /**
   * @return The value of the {@code verbosityLevel} attribute
   */
  @Override
  public int verbosityLevel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.verbosityLevel()
        : this.verbosityLevel;
  }

  /**
   * @return The value of the {@code isQuiet} attribute
   */
  @Override
  public boolean isQuiet() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isQuiet()
        : this.isQuiet;
  }

  /**
   * @return The value of the {@code useNoPrealloc} attribute
   */
  @Override
  public boolean useNoPrealloc() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useNoPrealloc()
        : this.useNoPrealloc;
  }

  /**
   * @return The value of the {@code useSmallFiles} attribute
   */
  @Override
  public boolean useSmallFiles() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useSmallFiles()
        : this.useSmallFiles;
  }

  /**
   * @return The value of the {@code useNoJournal} attribute
   */
  @Override
  public boolean useNoJournal() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useNoJournal()
        : this.useNoJournal;
  }

  /**
   * @return The value of the {@code enableTextSearch} attribute
   */
  @Override
  public boolean enableTextSearch() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.enableTextSearch()
        : this.enableTextSearch;
  }

  /**
   * @return The value of the {@code auth} attribute
   */
  @Override
  public boolean auth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.auth()
        : this.auth;
  }

  /**
   * @return The value of the {@code master} attribute
   */
  @Override
  public boolean master() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.master()
        : this.master;
  }

  /**
   * @return The value of the {@code replication} attribute
   */
  @Override
  public Optional<Storage> replication() {
    return Optional.ofNullable(replication);
  }

  /**
   * @return The value of the {@code isConfigServer} attribute
   */
  @Override
  public boolean isConfigServer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isConfigServer()
        : this.isConfigServer;
  }

  /**
   * @return The value of the {@code isShardServer} attribute
   */
  @Override
  public boolean isShardServer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isShardServer()
        : this.isShardServer;
  }

  /**
   * @return The value of the {@code params} attribute
   */
  @Override
  public Map<String, String> params() {
    return params;
  }

  /**
   * @return The value of the {@code args} attribute
   */
  @Override
  public Map<String, String> args() {
    return args;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#syncDelay() syncDelay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for syncDelay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withSyncDelay(int value) {
    if (this.syncDelay == value) return this;
    return new ImmutableMongodArguments(
        value,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#useDefaultSyncDelay() useDefaultSyncDelay} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useDefaultSyncDelay
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withUseDefaultSyncDelay(boolean value) {
    if (this.useDefaultSyncDelay == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        value,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongodArguments#storageEngine() storageEngine} attribute.
   * @param value The value for storageEngine
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodArguments withStorageEngine(String value) {
    String newValue = Objects.requireNonNull(value, "storageEngine");
    if (Objects.equals(this.storageEngine, newValue)) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        newValue,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongodArguments#storageEngine() storageEngine} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for storageEngine
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodArguments withStorageEngine(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.storageEngine, value)) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        value,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#isVerbose() isVerbose} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVerbose
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withIsVerbose(boolean value) {
    if (this.isVerbose == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        value,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#verbosityLevel() verbosityLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for verbosityLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withVerbosityLevel(int value) {
    if (this.verbosityLevel == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        value,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#isQuiet() isQuiet} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isQuiet
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withIsQuiet(boolean value) {
    if (this.isQuiet == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        value,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#useNoPrealloc() useNoPrealloc} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useNoPrealloc
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withUseNoPrealloc(boolean value) {
    if (this.useNoPrealloc == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        value,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#useSmallFiles() useSmallFiles} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useSmallFiles
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withUseSmallFiles(boolean value) {
    if (this.useSmallFiles == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        value,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#useNoJournal() useNoJournal} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useNoJournal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withUseNoJournal(boolean value) {
    if (this.useNoJournal == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        value,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#enableTextSearch() enableTextSearch} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableTextSearch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withEnableTextSearch(boolean value) {
    if (this.enableTextSearch == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        value,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#auth() auth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for auth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withAuth(boolean value) {
    if (this.auth == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        value,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#master() master} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for master
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withMaster(boolean value) {
    if (this.master == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        value,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MongodArguments#replication() replication} attribute.
   * @param value The value for replication
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodArguments withReplication(Storage value) {
    Storage newValue = Objects.requireNonNull(value, "replication");
    if (this.replication == newValue) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        newValue,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MongodArguments#replication() replication} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replication
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableMongodArguments withReplication(Optional<? extends Storage> optional) {
    Storage value = optional.orElse(null);
    if (this.replication == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        value,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#isConfigServer() isConfigServer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isConfigServer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withIsConfigServer(boolean value) {
    if (this.isConfigServer == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        value,
        this.isShardServer,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongodArguments#isShardServer() isShardServer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isShardServer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongodArguments withIsShardServer(boolean value) {
    if (this.isShardServer == value) return this;
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        value,
        this.params,
        this.args);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongodArguments#params() params} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the params map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodArguments withParams(Map<String, ? extends String> entries) {
    if (this.params == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        newValue,
        this.args);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongodArguments#args() args} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the args map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongodArguments withArgs(Map<String, ? extends String> entries) {
    if (this.args == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongodArguments(
        this.syncDelay,
        this.useDefaultSyncDelay,
        this.storageEngine,
        this.isVerbose,
        this.verbosityLevel,
        this.isQuiet,
        this.useNoPrealloc,
        this.useSmallFiles,
        this.useNoJournal,
        this.enableTextSearch,
        this.auth,
        this.master,
        this.replication,
        this.isConfigServer,
        this.isShardServer,
        this.params,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongodArguments} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongodArguments
        && equalTo(0, (ImmutableMongodArguments) another);
  }

  private boolean equalTo(int synthetic, ImmutableMongodArguments another) {
    return syncDelay == another.syncDelay
        && useDefaultSyncDelay == another.useDefaultSyncDelay
        && Objects.equals(storageEngine, another.storageEngine)
        && isVerbose == another.isVerbose
        && verbosityLevel == another.verbosityLevel
        && isQuiet == another.isQuiet
        && useNoPrealloc == another.useNoPrealloc
        && useSmallFiles == another.useSmallFiles
        && useNoJournal == another.useNoJournal
        && enableTextSearch == another.enableTextSearch
        && auth == another.auth
        && master == another.master
        && Objects.equals(replication, another.replication)
        && isConfigServer == another.isConfigServer
        && isShardServer == another.isShardServer
        && params.equals(another.params)
        && args.equals(another.args);
  }

  /**
   * Computes a hash code from attributes: {@code syncDelay}, {@code useDefaultSyncDelay}, {@code storageEngine}, {@code isVerbose}, {@code verbosityLevel}, {@code isQuiet}, {@code useNoPrealloc}, {@code useSmallFiles}, {@code useNoJournal}, {@code enableTextSearch}, {@code auth}, {@code master}, {@code replication}, {@code isConfigServer}, {@code isShardServer}, {@code params}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + syncDelay;
    h += (h << 5) + Boolean.hashCode(useDefaultSyncDelay);
    h += (h << 5) + Objects.hashCode(storageEngine);
    h += (h << 5) + Boolean.hashCode(isVerbose);
    h += (h << 5) + verbosityLevel;
    h += (h << 5) + Boolean.hashCode(isQuiet);
    h += (h << 5) + Boolean.hashCode(useNoPrealloc);
    h += (h << 5) + Boolean.hashCode(useSmallFiles);
    h += (h << 5) + Boolean.hashCode(useNoJournal);
    h += (h << 5) + Boolean.hashCode(enableTextSearch);
    h += (h << 5) + Boolean.hashCode(auth);
    h += (h << 5) + Boolean.hashCode(master);
    h += (h << 5) + Objects.hashCode(replication);
    h += (h << 5) + Boolean.hashCode(isConfigServer);
    h += (h << 5) + Boolean.hashCode(isShardServer);
    h += (h << 5) + params.hashCode();
    h += (h << 5) + args.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongodArguments} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MongodArguments{");
    builder.append("syncDelay=").append(syncDelay);
    builder.append(", ");
    builder.append("useDefaultSyncDelay=").append(useDefaultSyncDelay);
    if (storageEngine != null) {
      builder.append(", ");
      builder.append("storageEngine=").append(storageEngine);
    }
    builder.append(", ");
    builder.append("isVerbose=").append(isVerbose);
    builder.append(", ");
    builder.append("verbosityLevel=").append(verbosityLevel);
    builder.append(", ");
    builder.append("isQuiet=").append(isQuiet);
    builder.append(", ");
    builder.append("useNoPrealloc=").append(useNoPrealloc);
    builder.append(", ");
    builder.append("useSmallFiles=").append(useSmallFiles);
    builder.append(", ");
    builder.append("useNoJournal=").append(useNoJournal);
    builder.append(", ");
    builder.append("enableTextSearch=").append(enableTextSearch);
    builder.append(", ");
    builder.append("auth=").append(auth);
    builder.append(", ");
    builder.append("master=").append(master);
    if (replication != null) {
      builder.append(", ");
      builder.append("replication=").append(replication);
    }
    builder.append(", ");
    builder.append("isConfigServer=").append(isConfigServer);
    builder.append(", ");
    builder.append("isShardServer=").append(isShardServer);
    builder.append(", ");
    builder.append("params=").append(params);
    builder.append(", ");
    builder.append("args=").append(args);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MongodArguments} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongodArguments instance
   */
  public static ImmutableMongodArguments copyOf(MongodArguments instance) {
    if (instance instanceof ImmutableMongodArguments) {
      return (ImmutableMongodArguments) instance;
    }
    return ImmutableMongodArguments.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongodArguments ImmutableMongodArguments}.
   * <pre>
   * ImmutableMongodArguments.builder()
   *    .syncDelay(int) // optional {@link MongodArguments#syncDelay() syncDelay}
   *    .useDefaultSyncDelay(boolean) // optional {@link MongodArguments#useDefaultSyncDelay() useDefaultSyncDelay}
   *    .storageEngine(String) // optional {@link MongodArguments#storageEngine() storageEngine}
   *    .isVerbose(boolean) // optional {@link MongodArguments#isVerbose() isVerbose}
   *    .verbosityLevel(int) // optional {@link MongodArguments#verbosityLevel() verbosityLevel}
   *    .isQuiet(boolean) // optional {@link MongodArguments#isQuiet() isQuiet}
   *    .useNoPrealloc(boolean) // optional {@link MongodArguments#useNoPrealloc() useNoPrealloc}
   *    .useSmallFiles(boolean) // optional {@link MongodArguments#useSmallFiles() useSmallFiles}
   *    .useNoJournal(boolean) // optional {@link MongodArguments#useNoJournal() useNoJournal}
   *    .enableTextSearch(boolean) // optional {@link MongodArguments#enableTextSearch() enableTextSearch}
   *    .auth(boolean) // optional {@link MongodArguments#auth() auth}
   *    .master(boolean) // optional {@link MongodArguments#master() master}
   *    .replication(de.flapdoodle.embed.mongo.config.Storage) // optional {@link MongodArguments#replication() replication}
   *    .isConfigServer(boolean) // optional {@link MongodArguments#isConfigServer() isConfigServer}
   *    .isShardServer(boolean) // optional {@link MongodArguments#isShardServer() isShardServer}
   *    .putParams|putAllParams(String =&gt; String) // {@link MongodArguments#params() params} mappings
   *    .putArgs|putAllArgs(String =&gt; String) // {@link MongodArguments#args() args} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableMongodArguments builder
   */
  public static ImmutableMongodArguments.Builder builder() {
    return new ImmutableMongodArguments.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongodArguments ImmutableMongodArguments}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long OPT_BIT_SYNC_DELAY = 0x1L;
    private static final long OPT_BIT_USE_DEFAULT_SYNC_DELAY = 0x2L;
    private static final long OPT_BIT_IS_VERBOSE = 0x4L;
    private static final long OPT_BIT_VERBOSITY_LEVEL = 0x8L;
    private static final long OPT_BIT_IS_QUIET = 0x10L;
    private static final long OPT_BIT_USE_NO_PREALLOC = 0x20L;
    private static final long OPT_BIT_USE_SMALL_FILES = 0x40L;
    private static final long OPT_BIT_USE_NO_JOURNAL = 0x80L;
    private static final long OPT_BIT_ENABLE_TEXT_SEARCH = 0x100L;
    private static final long OPT_BIT_AUTH = 0x200L;
    private static final long OPT_BIT_MASTER = 0x400L;
    private static final long OPT_BIT_IS_CONFIG_SERVER = 0x800L;
    private static final long OPT_BIT_IS_SHARD_SERVER = 0x1000L;
    private long optBits;

    private int syncDelay;
    private boolean useDefaultSyncDelay;
    private String storageEngine;
    private boolean isVerbose;
    private int verbosityLevel;
    private boolean isQuiet;
    private boolean useNoPrealloc;
    private boolean useSmallFiles;
    private boolean useNoJournal;
    private boolean enableTextSearch;
    private boolean auth;
    private boolean master;
    private Storage replication;
    private boolean isConfigServer;
    private boolean isShardServer;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private Map<String, String> args = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongodArguments} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongodArguments instance) {
      Objects.requireNonNull(instance, "instance");
      syncDelay(instance.syncDelay());
      useDefaultSyncDelay(instance.useDefaultSyncDelay());
      Optional<String> storageEngineOptional = instance.storageEngine();
      if (storageEngineOptional.isPresent()) {
        storageEngine(storageEngineOptional);
      }
      isVerbose(instance.isVerbose());
      verbosityLevel(instance.verbosityLevel());
      isQuiet(instance.isQuiet());
      useNoPrealloc(instance.useNoPrealloc());
      useSmallFiles(instance.useSmallFiles());
      useNoJournal(instance.useNoJournal());
      enableTextSearch(instance.enableTextSearch());
      auth(instance.auth());
      master(instance.master());
      Optional<Storage> replicationOptional = instance.replication();
      if (replicationOptional.isPresent()) {
        replication(replicationOptional);
      }
      isConfigServer(instance.isConfigServer());
      isShardServer(instance.isShardServer());
      putAllParams(instance.params());
      putAllArgs(instance.args());
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#syncDelay() syncDelay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#syncDelay() syncDelay}.</em>
     * @param syncDelay The value for syncDelay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder syncDelay(int syncDelay) {
      this.syncDelay = syncDelay;
      optBits |= OPT_BIT_SYNC_DELAY;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#useDefaultSyncDelay() useDefaultSyncDelay} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#useDefaultSyncDelay() useDefaultSyncDelay}.</em>
     * @param useDefaultSyncDelay The value for useDefaultSyncDelay 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useDefaultSyncDelay(boolean useDefaultSyncDelay) {
      this.useDefaultSyncDelay = useDefaultSyncDelay;
      optBits |= OPT_BIT_USE_DEFAULT_SYNC_DELAY;
      return this;
    }

    /**
     * Initializes the optional value {@link MongodArguments#storageEngine() storageEngine} to storageEngine.
     * @param storageEngine The value for storageEngine
     * @return {@code this} builder for chained invocation
     */
    public final Builder storageEngine(String storageEngine) {
      this.storageEngine = Objects.requireNonNull(storageEngine, "storageEngine");
      return this;
    }

    /**
     * Initializes the optional value {@link MongodArguments#storageEngine() storageEngine} to storageEngine.
     * @param storageEngine The value for storageEngine
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder storageEngine(Optional<String> storageEngine) {
      this.storageEngine = storageEngine.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#isVerbose() isVerbose} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#isVerbose() isVerbose}.</em>
     * @param isVerbose The value for isVerbose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isVerbose(boolean isVerbose) {
      this.isVerbose = isVerbose;
      optBits |= OPT_BIT_IS_VERBOSE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#verbosityLevel() verbosityLevel} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#verbosityLevel() verbosityLevel}.</em>
     * @param verbosityLevel The value for verbosityLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verbosityLevel(int verbosityLevel) {
      this.verbosityLevel = verbosityLevel;
      optBits |= OPT_BIT_VERBOSITY_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#isQuiet() isQuiet} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#isQuiet() isQuiet}.</em>
     * @param isQuiet The value for isQuiet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isQuiet(boolean isQuiet) {
      this.isQuiet = isQuiet;
      optBits |= OPT_BIT_IS_QUIET;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#useNoPrealloc() useNoPrealloc} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#useNoPrealloc() useNoPrealloc}.</em>
     * @param useNoPrealloc The value for useNoPrealloc 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useNoPrealloc(boolean useNoPrealloc) {
      this.useNoPrealloc = useNoPrealloc;
      optBits |= OPT_BIT_USE_NO_PREALLOC;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#useSmallFiles() useSmallFiles} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#useSmallFiles() useSmallFiles}.</em>
     * @param useSmallFiles The value for useSmallFiles 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useSmallFiles(boolean useSmallFiles) {
      this.useSmallFiles = useSmallFiles;
      optBits |= OPT_BIT_USE_SMALL_FILES;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#useNoJournal() useNoJournal} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#useNoJournal() useNoJournal}.</em>
     * @param useNoJournal The value for useNoJournal 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder useNoJournal(boolean useNoJournal) {
      this.useNoJournal = useNoJournal;
      optBits |= OPT_BIT_USE_NO_JOURNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#enableTextSearch() enableTextSearch} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#enableTextSearch() enableTextSearch}.</em>
     * @param enableTextSearch The value for enableTextSearch 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableTextSearch(boolean enableTextSearch) {
      this.enableTextSearch = enableTextSearch;
      optBits |= OPT_BIT_ENABLE_TEXT_SEARCH;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#auth() auth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#auth() auth}.</em>
     * @param auth The value for auth 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auth(boolean auth) {
      this.auth = auth;
      optBits |= OPT_BIT_AUTH;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#master() master} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#master() master}.</em>
     * @param master The value for master 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder master(boolean master) {
      this.master = master;
      optBits |= OPT_BIT_MASTER;
      return this;
    }

    /**
     * Initializes the optional value {@link MongodArguments#replication() replication} to replication.
     * @param replication The value for replication
     * @return {@code this} builder for chained invocation
     */
    public final Builder replication(Storage replication) {
      this.replication = Objects.requireNonNull(replication, "replication");
      return this;
    }

    /**
     * Initializes the optional value {@link MongodArguments#replication() replication} to replication.
     * @param replication The value for replication
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder replication(Optional<? extends Storage> replication) {
      this.replication = replication.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#isConfigServer() isConfigServer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#isConfigServer() isConfigServer}.</em>
     * @param isConfigServer The value for isConfigServer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isConfigServer(boolean isConfigServer) {
      this.isConfigServer = isConfigServer;
      optBits |= OPT_BIT_IS_CONFIG_SERVER;
      return this;
    }

    /**
     * Initializes the value for the {@link MongodArguments#isShardServer() isShardServer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongodArguments#isShardServer() isShardServer}.</em>
     * @param isShardServer The value for isShardServer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isShardServer(boolean isShardServer) {
      this.isShardServer = isShardServer;
      optBits |= OPT_BIT_IS_SHARD_SERVER;
      return this;
    }

    /**
     * Put one entry to the {@link MongodArguments#params() params} map.
     * @param key The key in the params map
     * @param value The associated value in the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParams(String key, String value) {
      this.params.put(
          Objects.requireNonNull(key, "params key"),
          Objects.requireNonNull(value, value == null ? "params value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link MongodArguments#params() params} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParams(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.params.put(
          Objects.requireNonNull(k, "params key"),
          Objects.requireNonNull(v, v == null ? "params value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongodArguments#params() params} map. Nulls are not permitted
     * @param entries The entries that will be added to the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder params(Map<String, ? extends String> entries) {
      this.params.clear();
      return putAllParams(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongodArguments#params() params} map. Nulls are not permitted
     * @param entries The entries that will be added to the params map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParams(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.params.put(
            Objects.requireNonNull(k, "params key"),
            Objects.requireNonNull(v, v == null ? "params value for key: " + k : null));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongodArguments#args() args} map.
     * @param key The key in the args map
     * @param value The associated value in the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(String key, String value) {
      this.args.put(
          Objects.requireNonNull(key, "args key"),
          Objects.requireNonNull(value, value == null ? "args value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link MongodArguments#args() args} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putArgs(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.args.put(
          Objects.requireNonNull(k, "args key"),
          Objects.requireNonNull(v, v == null ? "args value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongodArguments#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder args(Map<String, ? extends String> entries) {
      this.args.clear();
      return putAllArgs(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongodArguments#args() args} map. Nulls are not permitted
     * @param entries The entries that will be added to the args map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllArgs(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.args.put(
            Objects.requireNonNull(k, "args key"),
            Objects.requireNonNull(v, v == null ? "args value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongodArguments ImmutableMongodArguments}.
     * @return An immutable instance of MongodArguments
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongodArguments build() {
      return new ImmutableMongodArguments(this);
    }

    private boolean syncDelayIsSet() {
      return (optBits & OPT_BIT_SYNC_DELAY) != 0;
    }

    private boolean useDefaultSyncDelayIsSet() {
      return (optBits & OPT_BIT_USE_DEFAULT_SYNC_DELAY) != 0;
    }

    private boolean isVerboseIsSet() {
      return (optBits & OPT_BIT_IS_VERBOSE) != 0;
    }

    private boolean verbosityLevelIsSet() {
      return (optBits & OPT_BIT_VERBOSITY_LEVEL) != 0;
    }

    private boolean isQuietIsSet() {
      return (optBits & OPT_BIT_IS_QUIET) != 0;
    }

    private boolean useNoPreallocIsSet() {
      return (optBits & OPT_BIT_USE_NO_PREALLOC) != 0;
    }

    private boolean useSmallFilesIsSet() {
      return (optBits & OPT_BIT_USE_SMALL_FILES) != 0;
    }

    private boolean useNoJournalIsSet() {
      return (optBits & OPT_BIT_USE_NO_JOURNAL) != 0;
    }

    private boolean enableTextSearchIsSet() {
      return (optBits & OPT_BIT_ENABLE_TEXT_SEARCH) != 0;
    }

    private boolean authIsSet() {
      return (optBits & OPT_BIT_AUTH) != 0;
    }

    private boolean masterIsSet() {
      return (optBits & OPT_BIT_MASTER) != 0;
    }

    private boolean isConfigServerIsSet() {
      return (optBits & OPT_BIT_IS_CONFIG_SERVER) != 0;
    }

    private boolean isShardServerIsSet() {
      return (optBits & OPT_BIT_IS_SHARD_SERVER) != 0;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
