/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.types;

import de.flapdoodle.embed.mongo.types._SystemEnv;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class SystemEnv
extends _SystemEnv {
    private final Map<String, String> value;

    private SystemEnv(Map<String, ? extends String> value) {
        this.value = SystemEnv.createUnmodifiableMap(true, false, value);
    }

    public Map<String, String> value() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SystemEnv && this.equalTo(0, (SystemEnv)((Object)another));
    }

    private boolean equalTo(int synthetic, SystemEnv another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public static SystemEnv of(Map<String, ? extends String> value) {
        return new SystemEnv(value);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

