/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.transitions.CommandName;
import de.flapdoodle.embed.mongo.transitions.Environment;
import de.flapdoodle.embed.mongo.transitions.ExtractFileSet;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.MongodProcessArguments;
import de.flapdoodle.embed.mongo.transitions.MongodStarter;
import de.flapdoodle.embed.mongo.transitions.ProcessDefaults;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.mongo.transitions.VersionAndPlatform;
import de.flapdoodle.embed.mongo.transitions.WorkspaceDefaults;
import de.flapdoodle.embed.mongo.types.DatabaseDir;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.transitions.Directories;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.transitions.Derive;
import de.flapdoodle.reverse.transitions.Start;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public class Mongod
implements Environment,
WorkspaceDefaults,
VersionAndPlatform,
ProcessDefaults,
CommandName,
ExtractFileSet {
    @Value.Default
    public Transition<MongodArguments> mongodArguments() {
        return Start.to(MongodArguments.class).initializedWith((Object)MongodArguments.defaults());
    }

    @Value.Default
    public Transition<Net> net() {
        return Start.to(Net.class).providedBy(Net::defaults);
    }

    @Value.Default
    public Transition<DatabaseDir> databaseDir() {
        return Derive.given(TempDir.class).state(DatabaseDir.class).with(Directories.deleteOnTearDown((Function)TempDir.createDirectoryWith((String)"mongod-database", (FileAttribute[])new FileAttribute[0]), DatabaseDir::of));
    }

    @Value.Default
    protected MongodProcessArguments mongodProcessArguments() {
        return MongodProcessArguments.withDefaults();
    }

    @Value.Default
    protected MongodStarter mongodStarter() {
        return MongodStarter.withDefaults();
    }

    @Value.Auxiliary
    public Transitions transitions(Version version) {
        return this.workspaceDefaults().addAll(this.environment()).addAll(this.versionAndPlatform()).addAll(this.processDefaults()).addAll(this.commandNames()).addAll(this.extractFileSet()).addAll(new Transition[]{Start.to(Command.class).initializedWith((Object)Command.MongoD).withTransitionLabel("provide Command"), Start.to(Version.class).initializedWith((Object)version), this.net(), this.databaseDir(), this.mongodArguments(), this.mongodProcessArguments(), this.mongodStarter()});
    }

    @Value.Auxiliary
    public TransitionWalker.ReachedState<RunningMongodProcess> start(Version version, Listener ... listener) {
        return this.transitions(version).walker().initState(StateID.of(RunningMongodProcess.class), listener);
    }

    @Value.Auxiliary
    public TransitionWalker.ReachedState<RunningMongodProcess> start(Version version, Collection<Listener> listener) {
        return this.transitions(version).walker().initState(StateID.of(RunningMongodProcess.class), listener);
    }

    @Value.Auxiliary
    public void start(Version version, Consumer<RunningMongodProcess> withRunningMongod, Listener ... listener) {
        this.start(version, withRunningMongod, Arrays.asList(listener));
    }

    @Value.Auxiliary
    public void start(Version version, Consumer<RunningMongodProcess> withRunningMongod, Collection<Listener> listener) {
        try (TransitionWalker.ReachedState<RunningMongodProcess> state = this.start(version, listener);){
            withRunningMongod.accept((RunningMongodProcess)((Object)state.current()));
        }
    }

    public static ImmutableMongod instance() {
        return Mongod.builder().build();
    }

    public static ImmutableMongod.Builder builder() {
        return ImmutableMongod.builder();
    }
}

