
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.types.DistributionBaseUrl;
import de.flapdoodle.embed.mongo.types.StartTimeout;
import de.flapdoodle.embed.mongo.types.SystemEnv;
import de.flapdoodle.embed.mongo.types.SystemProperties;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.directories.PersistentDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.store.ExtractedFileSetStore;
import de.flapdoodle.embed.process.transitions.DownloadPackage;
import de.flapdoodle.embed.process.transitions.InitTempDirectory;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.ImmutableStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link MongoImport}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoImport.builder()}.
 */
@SuppressWarnings({"all"})
public final class ImmutableMongoImport extends MongoImport {
  private final Transition<SystemEnv> systemEnv;
  private final Transition<SystemProperties> systemProperties;
  private final InitTempDirectory initTempDirectory;
  private final Transition<ProcessWorkingDir> processWorkingDir;
  private final Transition<Platform> platform;
  private final Transition<Distribution> distribution;
  private final Transition<DistributionBaseUrl> distributionBaseUrl;
  private final ImmutableStart<ProcessConfig> processConfig;
  private final Transition<ProcessEnv> processEnv;
  private final Transition<StartTimeout> startTimeout;
  private final Transition<ProcessOutput> processOutput;
  private final Transition<SupportConfig> supportConfig;
  private final Transition<Name> commandName;
  private final Transition<PersistentDir> persistentBaseDir;
  private final Transition<DownloadCache> downloadCache;
  private final Transition<ExtractedFileSetStore> extractedFileSetStore;
  private final DownloadPackage downloadPackage;
  private final Transition<ProgressListener> progressListener;
  private final Transition<ExtractedFileSet> extractPackage;
  private final Transition<Package> packageOfDistribution;

  private ImmutableMongoImport(ImmutableMongoImport.Builder builder) {
    if (builder.systemEnv != null) {
      initShim.systemEnv(builder.systemEnv);
    }
    if (builder.systemProperties != null) {
      initShim.systemProperties(builder.systemProperties);
    }
    if (builder.initTempDirectory != null) {
      initShim.initTempDirectory(builder.initTempDirectory);
    }
    if (builder.processWorkingDir != null) {
      initShim.processWorkingDir(builder.processWorkingDir);
    }
    if (builder.platform != null) {
      initShim.platform(builder.platform);
    }
    if (builder.distribution != null) {
      initShim.distribution(builder.distribution);
    }
    if (builder.distributionBaseUrl != null) {
      initShim.distributionBaseUrl(builder.distributionBaseUrl);
    }
    if (builder.processConfig != null) {
      initShim.processConfig(builder.processConfig);
    }
    if (builder.processEnv != null) {
      initShim.processEnv(builder.processEnv);
    }
    if (builder.startTimeout != null) {
      initShim.startTimeout(builder.startTimeout);
    }
    if (builder.processOutput != null) {
      initShim.processOutput(builder.processOutput);
    }
    if (builder.supportConfig != null) {
      initShim.supportConfig(builder.supportConfig);
    }
    if (builder.commandName != null) {
      initShim.commandName(builder.commandName);
    }
    if (builder.persistentBaseDir != null) {
      initShim.persistentBaseDir(builder.persistentBaseDir);
    }
    if (builder.downloadCache != null) {
      initShim.downloadCache(builder.downloadCache);
    }
    if (builder.extractedFileSetStore != null) {
      initShim.extractedFileSetStore(builder.extractedFileSetStore);
    }
    if (builder.downloadPackage != null) {
      initShim.downloadPackage(builder.downloadPackage);
    }
    if (builder.progressListener != null) {
      initShim.progressListener(builder.progressListener);
    }
    if (builder.extractPackage != null) {
      initShim.extractPackage(builder.extractPackage);
    }
    if (builder.packageOfDistribution != null) {
      initShim.packageOfDistribution(builder.packageOfDistribution);
    }
    this.systemEnv = initShim.systemEnv();
    this.systemProperties = initShim.systemProperties();
    this.initTempDirectory = initShim.initTempDirectory();
    this.processWorkingDir = initShim.processWorkingDir();
    this.platform = initShim.platform();
    this.distribution = initShim.distribution();
    this.distributionBaseUrl = initShim.distributionBaseUrl();
    this.processConfig = initShim.processConfig();
    this.processEnv = initShim.processEnv();
    this.startTimeout = initShim.startTimeout();
    this.processOutput = initShim.processOutput();
    this.supportConfig = initShim.supportConfig();
    this.commandName = initShim.commandName();
    this.persistentBaseDir = initShim.persistentBaseDir();
    this.downloadCache = initShim.downloadCache();
    this.extractedFileSetStore = initShim.extractedFileSetStore();
    this.downloadPackage = initShim.downloadPackage();
    this.progressListener = initShim.progressListener();
    this.extractPackage = initShim.extractPackage();
    this.packageOfDistribution = initShim.packageOfDistribution();
    this.initShim = null;
  }

  private ImmutableMongoImport(
      Transition<SystemEnv> systemEnv,
      Transition<SystemProperties> systemProperties,
      InitTempDirectory initTempDirectory,
      Transition<ProcessWorkingDir> processWorkingDir,
      Transition<Platform> platform,
      Transition<Distribution> distribution,
      Transition<DistributionBaseUrl> distributionBaseUrl,
      ImmutableStart<ProcessConfig> processConfig,
      Transition<ProcessEnv> processEnv,
      Transition<StartTimeout> startTimeout,
      Transition<ProcessOutput> processOutput,
      Transition<SupportConfig> supportConfig,
      Transition<Name> commandName,
      Transition<PersistentDir> persistentBaseDir,
      Transition<DownloadCache> downloadCache,
      Transition<ExtractedFileSetStore> extractedFileSetStore,
      DownloadPackage downloadPackage,
      Transition<ProgressListener> progressListener,
      Transition<ExtractedFileSet> extractPackage,
      Transition<Package> packageOfDistribution) {
    this.systemEnv = systemEnv;
    this.systemProperties = systemProperties;
    this.initTempDirectory = initTempDirectory;
    this.processWorkingDir = processWorkingDir;
    this.platform = platform;
    this.distribution = distribution;
    this.distributionBaseUrl = distributionBaseUrl;
    this.processConfig = processConfig;
    this.processEnv = processEnv;
    this.startTimeout = startTimeout;
    this.processOutput = processOutput;
    this.supportConfig = supportConfig;
    this.commandName = commandName;
    this.persistentBaseDir = persistentBaseDir;
    this.downloadCache = downloadCache;
    this.extractedFileSetStore = extractedFileSetStore;
    this.downloadPackage = downloadPackage;
    this.progressListener = progressListener;
    this.extractPackage = extractPackage;
    this.packageOfDistribution = packageOfDistribution;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private byte systemEnvBuildStage = STAGE_UNINITIALIZED;
    private Transition<SystemEnv> systemEnv;

    Transition<SystemEnv> systemEnv() {
      if (systemEnvBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (systemEnvBuildStage == STAGE_UNINITIALIZED) {
        systemEnvBuildStage = STAGE_INITIALIZING;
        this.systemEnv = Objects.requireNonNull(ImmutableMongoImport.super.systemEnv(), "systemEnv");
        systemEnvBuildStage = STAGE_INITIALIZED;
      }
      return this.systemEnv;
    }

    void systemEnv(Transition<SystemEnv> systemEnv) {
      this.systemEnv = systemEnv;
      systemEnvBuildStage = STAGE_INITIALIZED;
    }

    private byte systemPropertiesBuildStage = STAGE_UNINITIALIZED;
    private Transition<SystemProperties> systemProperties;

    Transition<SystemProperties> systemProperties() {
      if (systemPropertiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (systemPropertiesBuildStage == STAGE_UNINITIALIZED) {
        systemPropertiesBuildStage = STAGE_INITIALIZING;
        this.systemProperties = Objects.requireNonNull(ImmutableMongoImport.super.systemProperties(), "systemProperties");
        systemPropertiesBuildStage = STAGE_INITIALIZED;
      }
      return this.systemProperties;
    }

    void systemProperties(Transition<SystemProperties> systemProperties) {
      this.systemProperties = systemProperties;
      systemPropertiesBuildStage = STAGE_INITIALIZED;
    }

    private byte initTempDirectoryBuildStage = STAGE_UNINITIALIZED;
    private InitTempDirectory initTempDirectory;

    InitTempDirectory initTempDirectory() {
      if (initTempDirectoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (initTempDirectoryBuildStage == STAGE_UNINITIALIZED) {
        initTempDirectoryBuildStage = STAGE_INITIALIZING;
        this.initTempDirectory = Objects.requireNonNull(ImmutableMongoImport.super.initTempDirectory(), "initTempDirectory");
        initTempDirectoryBuildStage = STAGE_INITIALIZED;
      }
      return this.initTempDirectory;
    }

    void initTempDirectory(InitTempDirectory initTempDirectory) {
      this.initTempDirectory = initTempDirectory;
      initTempDirectoryBuildStage = STAGE_INITIALIZED;
    }

    private byte processWorkingDirBuildStage = STAGE_UNINITIALIZED;
    private Transition<ProcessWorkingDir> processWorkingDir;

    Transition<ProcessWorkingDir> processWorkingDir() {
      if (processWorkingDirBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processWorkingDirBuildStage == STAGE_UNINITIALIZED) {
        processWorkingDirBuildStage = STAGE_INITIALIZING;
        this.processWorkingDir = Objects.requireNonNull(ImmutableMongoImport.super.processWorkingDir(), "processWorkingDir");
        processWorkingDirBuildStage = STAGE_INITIALIZED;
      }
      return this.processWorkingDir;
    }

    void processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
      this.processWorkingDir = processWorkingDir;
      processWorkingDirBuildStage = STAGE_INITIALIZED;
    }

    private byte platformBuildStage = STAGE_UNINITIALIZED;
    private Transition<Platform> platform;

    Transition<Platform> platform() {
      if (platformBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (platformBuildStage == STAGE_UNINITIALIZED) {
        platformBuildStage = STAGE_INITIALIZING;
        this.platform = Objects.requireNonNull(ImmutableMongoImport.super.platform(), "platform");
        platformBuildStage = STAGE_INITIALIZED;
      }
      return this.platform;
    }

    void platform(Transition<Platform> platform) {
      this.platform = platform;
      platformBuildStage = STAGE_INITIALIZED;
    }

    private byte distributionBuildStage = STAGE_UNINITIALIZED;
    private Transition<Distribution> distribution;

    Transition<Distribution> distribution() {
      if (distributionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (distributionBuildStage == STAGE_UNINITIALIZED) {
        distributionBuildStage = STAGE_INITIALIZING;
        this.distribution = Objects.requireNonNull(ImmutableMongoImport.super.distribution(), "distribution");
        distributionBuildStage = STAGE_INITIALIZED;
      }
      return this.distribution;
    }

    void distribution(Transition<Distribution> distribution) {
      this.distribution = distribution;
      distributionBuildStage = STAGE_INITIALIZED;
    }

    private byte distributionBaseUrlBuildStage = STAGE_UNINITIALIZED;
    private Transition<DistributionBaseUrl> distributionBaseUrl;

    Transition<DistributionBaseUrl> distributionBaseUrl() {
      if (distributionBaseUrlBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (distributionBaseUrlBuildStage == STAGE_UNINITIALIZED) {
        distributionBaseUrlBuildStage = STAGE_INITIALIZING;
        this.distributionBaseUrl = Objects.requireNonNull(ImmutableMongoImport.super.distributionBaseUrl(), "distributionBaseUrl");
        distributionBaseUrlBuildStage = STAGE_INITIALIZED;
      }
      return this.distributionBaseUrl;
    }

    void distributionBaseUrl(Transition<DistributionBaseUrl> distributionBaseUrl) {
      this.distributionBaseUrl = distributionBaseUrl;
      distributionBaseUrlBuildStage = STAGE_INITIALIZED;
    }

    private byte processConfigBuildStage = STAGE_UNINITIALIZED;
    private ImmutableStart<ProcessConfig> processConfig;

    ImmutableStart<ProcessConfig> processConfig() {
      if (processConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processConfigBuildStage == STAGE_UNINITIALIZED) {
        processConfigBuildStage = STAGE_INITIALIZING;
        this.processConfig = Objects.requireNonNull(ImmutableMongoImport.super.processConfig(), "processConfig");
        processConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.processConfig;
    }

    void processConfig(ImmutableStart<ProcessConfig> processConfig) {
      this.processConfig = processConfig;
      processConfigBuildStage = STAGE_INITIALIZED;
    }

    private byte processEnvBuildStage = STAGE_UNINITIALIZED;
    private Transition<ProcessEnv> processEnv;

    Transition<ProcessEnv> processEnv() {
      if (processEnvBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processEnvBuildStage == STAGE_UNINITIALIZED) {
        processEnvBuildStage = STAGE_INITIALIZING;
        this.processEnv = Objects.requireNonNull(ImmutableMongoImport.super.processEnv(), "processEnv");
        processEnvBuildStage = STAGE_INITIALIZED;
      }
      return this.processEnv;
    }

    void processEnv(Transition<ProcessEnv> processEnv) {
      this.processEnv = processEnv;
      processEnvBuildStage = STAGE_INITIALIZED;
    }

    private byte startTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Transition<StartTimeout> startTimeout;

    Transition<StartTimeout> startTimeout() {
      if (startTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (startTimeoutBuildStage == STAGE_UNINITIALIZED) {
        startTimeoutBuildStage = STAGE_INITIALIZING;
        this.startTimeout = Objects.requireNonNull(ImmutableMongoImport.super.startTimeout(), "startTimeout");
        startTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.startTimeout;
    }

    void startTimeout(Transition<StartTimeout> startTimeout) {
      this.startTimeout = startTimeout;
      startTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte processOutputBuildStage = STAGE_UNINITIALIZED;
    private Transition<ProcessOutput> processOutput;

    Transition<ProcessOutput> processOutput() {
      if (processOutputBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (processOutputBuildStage == STAGE_UNINITIALIZED) {
        processOutputBuildStage = STAGE_INITIALIZING;
        this.processOutput = Objects.requireNonNull(ImmutableMongoImport.super.processOutput(), "processOutput");
        processOutputBuildStage = STAGE_INITIALIZED;
      }
      return this.processOutput;
    }

    void processOutput(Transition<ProcessOutput> processOutput) {
      this.processOutput = processOutput;
      processOutputBuildStage = STAGE_INITIALIZED;
    }

    private byte supportConfigBuildStage = STAGE_UNINITIALIZED;
    private Transition<SupportConfig> supportConfig;

    Transition<SupportConfig> supportConfig() {
      if (supportConfigBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (supportConfigBuildStage == STAGE_UNINITIALIZED) {
        supportConfigBuildStage = STAGE_INITIALIZING;
        this.supportConfig = Objects.requireNonNull(ImmutableMongoImport.super.supportConfig(), "supportConfig");
        supportConfigBuildStage = STAGE_INITIALIZED;
      }
      return this.supportConfig;
    }

    void supportConfig(Transition<SupportConfig> supportConfig) {
      this.supportConfig = supportConfig;
      supportConfigBuildStage = STAGE_INITIALIZED;
    }

    private byte commandNameBuildStage = STAGE_UNINITIALIZED;
    private Transition<Name> commandName;

    Transition<Name> commandName() {
      if (commandNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (commandNameBuildStage == STAGE_UNINITIALIZED) {
        commandNameBuildStage = STAGE_INITIALIZING;
        this.commandName = Objects.requireNonNull(ImmutableMongoImport.super.commandName(), "commandName");
        commandNameBuildStage = STAGE_INITIALIZED;
      }
      return this.commandName;
    }

    void commandName(Transition<Name> commandName) {
      this.commandName = commandName;
      commandNameBuildStage = STAGE_INITIALIZED;
    }

    private byte persistentBaseDirBuildStage = STAGE_UNINITIALIZED;
    private Transition<PersistentDir> persistentBaseDir;

    Transition<PersistentDir> persistentBaseDir() {
      if (persistentBaseDirBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (persistentBaseDirBuildStage == STAGE_UNINITIALIZED) {
        persistentBaseDirBuildStage = STAGE_INITIALIZING;
        this.persistentBaseDir = Objects.requireNonNull(ImmutableMongoImport.super.persistentBaseDir(), "persistentBaseDir");
        persistentBaseDirBuildStage = STAGE_INITIALIZED;
      }
      return this.persistentBaseDir;
    }

    void persistentBaseDir(Transition<PersistentDir> persistentBaseDir) {
      this.persistentBaseDir = persistentBaseDir;
      persistentBaseDirBuildStage = STAGE_INITIALIZED;
    }

    private byte downloadCacheBuildStage = STAGE_UNINITIALIZED;
    private Transition<DownloadCache> downloadCache;

    Transition<DownloadCache> downloadCache() {
      if (downloadCacheBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (downloadCacheBuildStage == STAGE_UNINITIALIZED) {
        downloadCacheBuildStage = STAGE_INITIALIZING;
        this.downloadCache = Objects.requireNonNull(ImmutableMongoImport.super.downloadCache(), "downloadCache");
        downloadCacheBuildStage = STAGE_INITIALIZED;
      }
      return this.downloadCache;
    }

    void downloadCache(Transition<DownloadCache> downloadCache) {
      this.downloadCache = downloadCache;
      downloadCacheBuildStage = STAGE_INITIALIZED;
    }

    private byte extractedFileSetStoreBuildStage = STAGE_UNINITIALIZED;
    private Transition<ExtractedFileSetStore> extractedFileSetStore;

    Transition<ExtractedFileSetStore> extractedFileSetStore() {
      if (extractedFileSetStoreBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extractedFileSetStoreBuildStage == STAGE_UNINITIALIZED) {
        extractedFileSetStoreBuildStage = STAGE_INITIALIZING;
        this.extractedFileSetStore = Objects.requireNonNull(ImmutableMongoImport.super.extractedFileSetStore(), "extractedFileSetStore");
        extractedFileSetStoreBuildStage = STAGE_INITIALIZED;
      }
      return this.extractedFileSetStore;
    }

    void extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
      this.extractedFileSetStore = extractedFileSetStore;
      extractedFileSetStoreBuildStage = STAGE_INITIALIZED;
    }

    private byte downloadPackageBuildStage = STAGE_UNINITIALIZED;
    private DownloadPackage downloadPackage;

    DownloadPackage downloadPackage() {
      if (downloadPackageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (downloadPackageBuildStage == STAGE_UNINITIALIZED) {
        downloadPackageBuildStage = STAGE_INITIALIZING;
        this.downloadPackage = Objects.requireNonNull(ImmutableMongoImport.super.downloadPackage(), "downloadPackage");
        downloadPackageBuildStage = STAGE_INITIALIZED;
      }
      return this.downloadPackage;
    }

    void downloadPackage(DownloadPackage downloadPackage) {
      this.downloadPackage = downloadPackage;
      downloadPackageBuildStage = STAGE_INITIALIZED;
    }

    private byte progressListenerBuildStage = STAGE_UNINITIALIZED;
    private Transition<ProgressListener> progressListener;

    Transition<ProgressListener> progressListener() {
      if (progressListenerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (progressListenerBuildStage == STAGE_UNINITIALIZED) {
        progressListenerBuildStage = STAGE_INITIALIZING;
        this.progressListener = Objects.requireNonNull(ImmutableMongoImport.super.progressListener(), "progressListener");
        progressListenerBuildStage = STAGE_INITIALIZED;
      }
      return this.progressListener;
    }

    void progressListener(Transition<ProgressListener> progressListener) {
      this.progressListener = progressListener;
      progressListenerBuildStage = STAGE_INITIALIZED;
    }

    private byte extractPackageBuildStage = STAGE_UNINITIALIZED;
    private Transition<ExtractedFileSet> extractPackage;

    Transition<ExtractedFileSet> extractPackage() {
      if (extractPackageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (extractPackageBuildStage == STAGE_UNINITIALIZED) {
        extractPackageBuildStage = STAGE_INITIALIZING;
        this.extractPackage = Objects.requireNonNull(ImmutableMongoImport.super.extractPackage(), "extractPackage");
        extractPackageBuildStage = STAGE_INITIALIZED;
      }
      return this.extractPackage;
    }

    void extractPackage(Transition<ExtractedFileSet> extractPackage) {
      this.extractPackage = extractPackage;
      extractPackageBuildStage = STAGE_INITIALIZED;
    }

    private byte packageOfDistributionBuildStage = STAGE_UNINITIALIZED;
    private Transition<Package> packageOfDistribution;

    Transition<Package> packageOfDistribution() {
      if (packageOfDistributionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (packageOfDistributionBuildStage == STAGE_UNINITIALIZED) {
        packageOfDistributionBuildStage = STAGE_INITIALIZING;
        this.packageOfDistribution = Objects.requireNonNull(ImmutableMongoImport.super.packageOfDistribution(), "packageOfDistribution");
        packageOfDistributionBuildStage = STAGE_INITIALIZED;
      }
      return this.packageOfDistribution;
    }

    void packageOfDistribution(Transition<Package> packageOfDistribution) {
      this.packageOfDistribution = packageOfDistribution;
      packageOfDistributionBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (systemEnvBuildStage == STAGE_INITIALIZING) attributes.add("systemEnv");
      if (systemPropertiesBuildStage == STAGE_INITIALIZING) attributes.add("systemProperties");
      if (initTempDirectoryBuildStage == STAGE_INITIALIZING) attributes.add("initTempDirectory");
      if (processWorkingDirBuildStage == STAGE_INITIALIZING) attributes.add("processWorkingDir");
      if (platformBuildStage == STAGE_INITIALIZING) attributes.add("platform");
      if (distributionBuildStage == STAGE_INITIALIZING) attributes.add("distribution");
      if (distributionBaseUrlBuildStage == STAGE_INITIALIZING) attributes.add("distributionBaseUrl");
      if (processConfigBuildStage == STAGE_INITIALIZING) attributes.add("processConfig");
      if (processEnvBuildStage == STAGE_INITIALIZING) attributes.add("processEnv");
      if (startTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("startTimeout");
      if (processOutputBuildStage == STAGE_INITIALIZING) attributes.add("processOutput");
      if (supportConfigBuildStage == STAGE_INITIALIZING) attributes.add("supportConfig");
      if (commandNameBuildStage == STAGE_INITIALIZING) attributes.add("commandName");
      if (persistentBaseDirBuildStage == STAGE_INITIALIZING) attributes.add("persistentBaseDir");
      if (downloadCacheBuildStage == STAGE_INITIALIZING) attributes.add("downloadCache");
      if (extractedFileSetStoreBuildStage == STAGE_INITIALIZING) attributes.add("extractedFileSetStore");
      if (downloadPackageBuildStage == STAGE_INITIALIZING) attributes.add("downloadPackage");
      if (progressListenerBuildStage == STAGE_INITIALIZING) attributes.add("progressListener");
      if (extractPackageBuildStage == STAGE_INITIALIZING) attributes.add("extractPackage");
      if (packageOfDistributionBuildStage == STAGE_INITIALIZING) attributes.add("packageOfDistribution");
      return "Cannot build MongoImport, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code systemEnv} attribute
   */
  @Override
  public Transition<SystemEnv> systemEnv() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.systemEnv()
        : this.systemEnv;
  }

  /**
   * @return The value of the {@code systemProperties} attribute
   */
  @Override
  public Transition<SystemProperties> systemProperties() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.systemProperties()
        : this.systemProperties;
  }

  /**
   * @return The value of the {@code initTempDirectory} attribute
   */
  @Override
  public InitTempDirectory initTempDirectory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.initTempDirectory()
        : this.initTempDirectory;
  }

  /**
   * @return The value of the {@code processWorkingDir} attribute
   */
  @Override
  public Transition<ProcessWorkingDir> processWorkingDir() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processWorkingDir()
        : this.processWorkingDir;
  }

  /**
   * @return The value of the {@code platform} attribute
   */
  @Override
  public Transition<Platform> platform() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.platform()
        : this.platform;
  }

  /**
   * @return The value of the {@code distribution} attribute
   */
  @Override
  public Transition<Distribution> distribution() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.distribution()
        : this.distribution;
  }

  /**
   * @return The value of the {@code distributionBaseUrl} attribute
   */
  @Override
  public Transition<DistributionBaseUrl> distributionBaseUrl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.distributionBaseUrl()
        : this.distributionBaseUrl;
  }

  /**
   * @return The value of the {@code processConfig} attribute
   */
  @Override
  public ImmutableStart<ProcessConfig> processConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processConfig()
        : this.processConfig;
  }

  /**
   * @return The value of the {@code processEnv} attribute
   */
  @Override
  public Transition<ProcessEnv> processEnv() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processEnv()
        : this.processEnv;
  }

  /**
   * @return The value of the {@code startTimeout} attribute
   */
  @Override
  public Transition<StartTimeout> startTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.startTimeout()
        : this.startTimeout;
  }

  /**
   * @return The value of the {@code processOutput} attribute
   */
  @Override
  public Transition<ProcessOutput> processOutput() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.processOutput()
        : this.processOutput;
  }

  /**
   * @return The value of the {@code supportConfig} attribute
   */
  @Override
  public Transition<SupportConfig> supportConfig() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.supportConfig()
        : this.supportConfig;
  }

  /**
   * @return The value of the {@code commandName} attribute
   */
  @Override
  public Transition<Name> commandName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.commandName()
        : this.commandName;
  }

  /**
   * @return The value of the {@code persistentBaseDir} attribute
   */
  @Override
  public Transition<PersistentDir> persistentBaseDir() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.persistentBaseDir()
        : this.persistentBaseDir;
  }

  /**
   * @return The value of the {@code downloadCache} attribute
   */
  @Override
  public Transition<DownloadCache> downloadCache() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.downloadCache()
        : this.downloadCache;
  }

  /**
   * @return The value of the {@code extractedFileSetStore} attribute
   */
  @Override
  public Transition<ExtractedFileSetStore> extractedFileSetStore() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.extractedFileSetStore()
        : this.extractedFileSetStore;
  }

  /**
   * @return The value of the {@code downloadPackage} attribute
   */
  @Override
  public DownloadPackage downloadPackage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.downloadPackage()
        : this.downloadPackage;
  }

  /**
   * @return The value of the {@code progressListener} attribute
   */
  @Override
  public Transition<ProgressListener> progressListener() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.progressListener()
        : this.progressListener;
  }

  /**
   * @return The value of the {@code extractPackage} attribute
   */
  @Override
  public Transition<ExtractedFileSet> extractPackage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.extractPackage()
        : this.extractPackage;
  }

  /**
   * @return The value of the {@code packageOfDistribution} attribute
   */
  @Override
  public Transition<Package> packageOfDistribution() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.packageOfDistribution()
        : this.packageOfDistribution;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#systemEnv() systemEnv} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for systemEnv
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withSystemEnv(Transition<SystemEnv> value) {
    if (this.systemEnv == value) return this;
    Transition<SystemEnv> newValue = Objects.requireNonNull(value, "systemEnv");
    return new ImmutableMongoImport(
        newValue,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#systemProperties() systemProperties} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for systemProperties
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withSystemProperties(Transition<SystemProperties> value) {
    if (this.systemProperties == value) return this;
    Transition<SystemProperties> newValue = Objects.requireNonNull(value, "systemProperties");
    return new ImmutableMongoImport(
        this.systemEnv,
        newValue,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#initTempDirectory() initTempDirectory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for initTempDirectory
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withInitTempDirectory(InitTempDirectory value) {
    if (this.initTempDirectory == value) return this;
    InitTempDirectory newValue = Objects.requireNonNull(value, "initTempDirectory");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        newValue,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#processWorkingDir() processWorkingDir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processWorkingDir
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withProcessWorkingDir(Transition<ProcessWorkingDir> value) {
    if (this.processWorkingDir == value) return this;
    Transition<ProcessWorkingDir> newValue = Objects.requireNonNull(value, "processWorkingDir");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        newValue,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#platform() platform} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for platform
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withPlatform(Transition<Platform> value) {
    if (this.platform == value) return this;
    Transition<Platform> newValue = Objects.requireNonNull(value, "platform");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        newValue,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#distribution() distribution} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for distribution
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withDistribution(Transition<Distribution> value) {
    if (this.distribution == value) return this;
    Transition<Distribution> newValue = Objects.requireNonNull(value, "distribution");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        newValue,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#distributionBaseUrl() distributionBaseUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for distributionBaseUrl
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withDistributionBaseUrl(Transition<DistributionBaseUrl> value) {
    if (this.distributionBaseUrl == value) return this;
    Transition<DistributionBaseUrl> newValue = Objects.requireNonNull(value, "distributionBaseUrl");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        newValue,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#processConfig() processConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processConfig
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withProcessConfig(ImmutableStart<ProcessConfig> value) {
    if (this.processConfig == value) return this;
    ImmutableStart<ProcessConfig> newValue = Objects.requireNonNull(value, "processConfig");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        newValue,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#processEnv() processEnv} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processEnv
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withProcessEnv(Transition<ProcessEnv> value) {
    if (this.processEnv == value) return this;
    Transition<ProcessEnv> newValue = Objects.requireNonNull(value, "processEnv");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        newValue,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#startTimeout() startTimeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startTimeout
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withStartTimeout(Transition<StartTimeout> value) {
    if (this.startTimeout == value) return this;
    Transition<StartTimeout> newValue = Objects.requireNonNull(value, "startTimeout");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        newValue,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#processOutput() processOutput} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processOutput
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withProcessOutput(Transition<ProcessOutput> value) {
    if (this.processOutput == value) return this;
    Transition<ProcessOutput> newValue = Objects.requireNonNull(value, "processOutput");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        newValue,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#supportConfig() supportConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for supportConfig
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withSupportConfig(Transition<SupportConfig> value) {
    if (this.supportConfig == value) return this;
    Transition<SupportConfig> newValue = Objects.requireNonNull(value, "supportConfig");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        newValue,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#commandName() commandName} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commandName
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withCommandName(Transition<Name> value) {
    if (this.commandName == value) return this;
    Transition<Name> newValue = Objects.requireNonNull(value, "commandName");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        newValue,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#persistentBaseDir() persistentBaseDir} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for persistentBaseDir
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withPersistentBaseDir(Transition<PersistentDir> value) {
    if (this.persistentBaseDir == value) return this;
    Transition<PersistentDir> newValue = Objects.requireNonNull(value, "persistentBaseDir");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        newValue,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#downloadCache() downloadCache} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadCache
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withDownloadCache(Transition<DownloadCache> value) {
    if (this.downloadCache == value) return this;
    Transition<DownloadCache> newValue = Objects.requireNonNull(value, "downloadCache");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        newValue,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#extractedFileSetStore() extractedFileSetStore} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for extractedFileSetStore
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withExtractedFileSetStore(Transition<ExtractedFileSetStore> value) {
    if (this.extractedFileSetStore == value) return this;
    Transition<ExtractedFileSetStore> newValue = Objects.requireNonNull(value, "extractedFileSetStore");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        newValue,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#downloadPackage() downloadPackage} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadPackage
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withDownloadPackage(DownloadPackage value) {
    if (this.downloadPackage == value) return this;
    DownloadPackage newValue = Objects.requireNonNull(value, "downloadPackage");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        newValue,
        this.progressListener,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#progressListener() progressListener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for progressListener
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withProgressListener(Transition<ProgressListener> value) {
    if (this.progressListener == value) return this;
    Transition<ProgressListener> newValue = Objects.requireNonNull(value, "progressListener");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        newValue,
        this.extractPackage,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#extractPackage() extractPackage} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for extractPackage
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withExtractPackage(Transition<ExtractedFileSet> value) {
    if (this.extractPackage == value) return this;
    Transition<ExtractedFileSet> newValue = Objects.requireNonNull(value, "extractPackage");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        newValue,
        this.packageOfDistribution);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoImport#packageOfDistribution() packageOfDistribution} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for packageOfDistribution
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableMongoImport withPackageOfDistribution(Transition<Package> value) {
    if (this.packageOfDistribution == value) return this;
    Transition<Package> newValue = Objects.requireNonNull(value, "packageOfDistribution");
    return new ImmutableMongoImport(
        this.systemEnv,
        this.systemProperties,
        this.initTempDirectory,
        this.processWorkingDir,
        this.platform,
        this.distribution,
        this.distributionBaseUrl,
        this.processConfig,
        this.processEnv,
        this.startTimeout,
        this.processOutput,
        this.supportConfig,
        this.commandName,
        this.persistentBaseDir,
        this.downloadCache,
        this.extractedFileSetStore,
        this.downloadPackage,
        this.progressListener,
        this.extractPackage,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoImport} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoImport
        && equalsByValue((ImmutableMongoImport) another);
  }

  private boolean equalsByValue(ImmutableMongoImport another) {
    return systemEnv.equals(another.systemEnv)
        && systemProperties.equals(another.systemProperties)
        && initTempDirectory.equals(another.initTempDirectory)
        && processWorkingDir.equals(another.processWorkingDir)
        && platform.equals(another.platform)
        && distribution.equals(another.distribution)
        && distributionBaseUrl.equals(another.distributionBaseUrl)
        && processConfig.equals(another.processConfig)
        && processEnv.equals(another.processEnv)
        && startTimeout.equals(another.startTimeout)
        && processOutput.equals(another.processOutput)
        && supportConfig.equals(another.supportConfig)
        && commandName.equals(another.commandName)
        && persistentBaseDir.equals(another.persistentBaseDir)
        && downloadCache.equals(another.downloadCache)
        && extractedFileSetStore.equals(another.extractedFileSetStore)
        && downloadPackage.equals(another.downloadPackage)
        && progressListener.equals(another.progressListener)
        && extractPackage.equals(another.extractPackage)
        && packageOfDistribution.equals(another.packageOfDistribution);
  }

  /**
   * Computes a hash code from attributes: {@code systemEnv}, {@code systemProperties}, {@code initTempDirectory}, {@code processWorkingDir}, {@code platform}, {@code distribution}, {@code distributionBaseUrl}, {@code processConfig}, {@code processEnv}, {@code startTimeout}, {@code processOutput}, {@code supportConfig}, {@code commandName}, {@code persistentBaseDir}, {@code downloadCache}, {@code extractedFileSetStore}, {@code downloadPackage}, {@code progressListener}, {@code extractPackage}, {@code packageOfDistribution}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + systemEnv.hashCode();
    h += (h << 5) + systemProperties.hashCode();
    h += (h << 5) + initTempDirectory.hashCode();
    h += (h << 5) + processWorkingDir.hashCode();
    h += (h << 5) + platform.hashCode();
    h += (h << 5) + distribution.hashCode();
    h += (h << 5) + distributionBaseUrl.hashCode();
    h += (h << 5) + processConfig.hashCode();
    h += (h << 5) + processEnv.hashCode();
    h += (h << 5) + startTimeout.hashCode();
    h += (h << 5) + processOutput.hashCode();
    h += (h << 5) + supportConfig.hashCode();
    h += (h << 5) + commandName.hashCode();
    h += (h << 5) + persistentBaseDir.hashCode();
    h += (h << 5) + downloadCache.hashCode();
    h += (h << 5) + extractedFileSetStore.hashCode();
    h += (h << 5) + downloadPackage.hashCode();
    h += (h << 5) + progressListener.hashCode();
    h += (h << 5) + extractPackage.hashCode();
    h += (h << 5) + packageOfDistribution.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoImport} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MongoImport{"
        + "systemEnv=" + systemEnv
        + ", systemProperties=" + systemProperties
        + ", initTempDirectory=" + initTempDirectory
        + ", processWorkingDir=" + processWorkingDir
        + ", platform=" + platform
        + ", distribution=" + distribution
        + ", distributionBaseUrl=" + distributionBaseUrl
        + ", processConfig=" + processConfig
        + ", processEnv=" + processEnv
        + ", startTimeout=" + startTimeout
        + ", processOutput=" + processOutput
        + ", supportConfig=" + supportConfig
        + ", commandName=" + commandName
        + ", persistentBaseDir=" + persistentBaseDir
        + ", downloadCache=" + downloadCache
        + ", extractedFileSetStore=" + extractedFileSetStore
        + ", downloadPackage=" + downloadPackage
        + ", progressListener=" + progressListener
        + ", extractPackage=" + extractPackage
        + ", packageOfDistribution=" + packageOfDistribution
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongoImport} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoImport instance
   */
  public static ImmutableMongoImport copyOf(MongoImport instance) {
    if (instance instanceof ImmutableMongoImport) {
      return (ImmutableMongoImport) instance;
    }
    return ImmutableMongoImport.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoImport ImmutableMongoImport}.
   * <pre>
   * ImmutableMongoImport.builder()
   *    .systemEnv(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.mongo.types.SystemEnv&gt;) // optional {@link MongoImport#systemEnv() systemEnv}
   *    .systemProperties(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.mongo.types.SystemProperties&gt;) // optional {@link MongoImport#systemProperties() systemProperties}
   *    .initTempDirectory(de.flapdoodle.embed.process.transitions.InitTempDirectory) // optional {@link MongoImport#initTempDirectory() initTempDirectory}
   *    .processWorkingDir(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.types.ProcessWorkingDir&gt;) // optional {@link MongoImport#processWorkingDir() processWorkingDir}
   *    .platform(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.os.Platform&gt;) // optional {@link MongoImport#platform() platform}
   *    .distribution(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.distribution.Distribution&gt;) // optional {@link MongoImport#distribution() distribution}
   *    .distributionBaseUrl(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.mongo.types.DistributionBaseUrl&gt;) // optional {@link MongoImport#distributionBaseUrl() distributionBaseUrl}
   *    .processConfig(de.flapdoodle.reverse.transitions.ImmutableStart&lt;de.flapdoodle.embed.process.types.ProcessConfig&gt;) // optional {@link MongoImport#processConfig() processConfig}
   *    .processEnv(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.types.ProcessEnv&gt;) // optional {@link MongoImport#processEnv() processEnv}
   *    .startTimeout(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.mongo.types.StartTimeout&gt;) // optional {@link MongoImport#startTimeout() startTimeout}
   *    .processOutput(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.io.ProcessOutput&gt;) // optional {@link MongoImport#processOutput() processOutput}
   *    .supportConfig(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.config.SupportConfig&gt;) // optional {@link MongoImport#supportConfig() supportConfig}
   *    .commandName(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.types.Name&gt;) // optional {@link MongoImport#commandName() commandName}
   *    .persistentBaseDir(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.io.directories.PersistentDir&gt;) // optional {@link MongoImport#persistentBaseDir() persistentBaseDir}
   *    .downloadCache(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.store.DownloadCache&gt;) // optional {@link MongoImport#downloadCache() downloadCache}
   *    .extractedFileSetStore(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.store.ExtractedFileSetStore&gt;) // optional {@link MongoImport#extractedFileSetStore() extractedFileSetStore}
   *    .downloadPackage(de.flapdoodle.embed.process.transitions.DownloadPackage) // optional {@link MongoImport#downloadPackage() downloadPackage}
   *    .progressListener(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.io.progress.ProgressListener&gt;) // optional {@link MongoImport#progressListener() progressListener}
   *    .extractPackage(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.archives.ExtractedFileSet&gt;) // optional {@link MongoImport#extractPackage() extractPackage}
   *    .packageOfDistribution(de.flapdoodle.reverse.Transition&lt;de.flapdoodle.embed.process.config.store.Package&gt;) // optional {@link MongoImport#packageOfDistribution() packageOfDistribution}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoImport builder
   */
  public static ImmutableMongoImport.Builder builder() {
    return new ImmutableMongoImport.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoImport ImmutableMongoImport}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Transition<SystemEnv> systemEnv;
    private Transition<SystemProperties> systemProperties;
    private InitTempDirectory initTempDirectory;
    private Transition<ProcessWorkingDir> processWorkingDir;
    private Transition<Platform> platform;
    private Transition<Distribution> distribution;
    private Transition<DistributionBaseUrl> distributionBaseUrl;
    private ImmutableStart<ProcessConfig> processConfig;
    private Transition<ProcessEnv> processEnv;
    private Transition<StartTimeout> startTimeout;
    private Transition<ProcessOutput> processOutput;
    private Transition<SupportConfig> supportConfig;
    private Transition<Name> commandName;
    private Transition<PersistentDir> persistentBaseDir;
    private Transition<DownloadCache> downloadCache;
    private Transition<ExtractedFileSetStore> extractedFileSetStore;
    private DownloadPackage downloadPackage;
    private Transition<ProgressListener> progressListener;
    private Transition<ExtractedFileSet> extractPackage;
    private Transition<Package> packageOfDistribution;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.ExtractFileSet} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExtractFileSet instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.Environment} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Environment instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.CommandName} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CommandName instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.ProcessDefaults} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessDefaults instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.WorkspaceDefaults} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WorkspaceDefaults instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.MongoImport} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoImport instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.mongo.transitions.VersionAndPlatform} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VersionAndPlatform instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      long bits = 0;
      if (object instanceof ExtractFileSet) {
        ExtractFileSet instance = (ExtractFileSet) object;
        if ((bits & 0x80L) == 0) {
          this.progressListener(instance.progressListener());
          bits |= 0x80L;
        }
        if ((bits & 0x400L) == 0) {
          this.packageOfDistribution(instance.packageOfDistribution());
          bits |= 0x400L;
        }
        if ((bits & 0x2000L) == 0) {
          this.extractedFileSetStore(instance.extractedFileSetStore());
          bits |= 0x2000L;
        }
        if ((bits & 0x8000L) == 0) {
          this.extractPackage(instance.extractPackage());
          bits |= 0x8000L;
        }
        if ((bits & 0x2L) == 0) {
          this.downloadCache(instance.downloadCache());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.persistentBaseDir(instance.persistentBaseDir());
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          this.downloadPackage(instance.downloadPackage());
          bits |= 0x20L;
        }
      }
      if (object instanceof Environment) {
        Environment instance = (Environment) object;
        if ((bits & 0x40L) == 0) {
          this.systemProperties(instance.systemProperties());
          bits |= 0x40L;
        }
        if ((bits & 0x100L) == 0) {
          this.systemEnv(instance.systemEnv());
          bits |= 0x100L;
        }
      }
      if (object instanceof CommandName) {
        CommandName instance = (CommandName) object;
        if ((bits & 0x200L) == 0) {
          this.commandName(instance.commandName());
          bits |= 0x200L;
        }
      }
      if (object instanceof ProcessDefaults) {
        ProcessDefaults instance = (ProcessDefaults) object;
        if ((bits & 0x20000L) == 0) {
          this.processOutput(instance.processOutput());
          bits |= 0x20000L;
        }
        if ((bits & 0x800L) == 0) {
          this.startTimeout(instance.startTimeout());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          this.supportConfig(instance.supportConfig());
          bits |= 0x1000L;
        }
        if ((bits & 0x1L) == 0) {
          this.processConfig(instance.processConfig());
          bits |= 0x1L;
        }
        if ((bits & 0x10000L) == 0) {
          this.processEnv(instance.processEnv());
          bits |= 0x10000L;
        }
      }
      if (object instanceof WorkspaceDefaults) {
        WorkspaceDefaults instance = (WorkspaceDefaults) object;
        if ((bits & 0x40000L) == 0) {
          this.processWorkingDir(instance.processWorkingDir());
          bits |= 0x40000L;
        }
        if ((bits & 0x4000L) == 0) {
          this.initTempDirectory(instance.initTempDirectory());
          bits |= 0x4000L;
        }
      }
      if (object instanceof MongoImport) {
        MongoImport instance = (MongoImport) object;
        if ((bits & 0x1L) == 0) {
          this.processConfig(instance.processConfig());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          this.downloadCache(instance.downloadCache());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.persistentBaseDir(instance.persistentBaseDir());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          this.distribution(instance.distribution());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          this.platform(instance.platform());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.downloadPackage(instance.downloadPackage());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          this.systemProperties(instance.systemProperties());
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          this.progressListener(instance.progressListener());
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          this.systemEnv(instance.systemEnv());
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          this.commandName(instance.commandName());
          bits |= 0x200L;
        }
        if ((bits & 0x400L) == 0) {
          this.packageOfDistribution(instance.packageOfDistribution());
          bits |= 0x400L;
        }
        if ((bits & 0x800L) == 0) {
          this.startTimeout(instance.startTimeout());
          bits |= 0x800L;
        }
        if ((bits & 0x1000L) == 0) {
          this.supportConfig(instance.supportConfig());
          bits |= 0x1000L;
        }
        if ((bits & 0x2000L) == 0) {
          this.extractedFileSetStore(instance.extractedFileSetStore());
          bits |= 0x2000L;
        }
        if ((bits & 0x4000L) == 0) {
          this.initTempDirectory(instance.initTempDirectory());
          bits |= 0x4000L;
        }
        if ((bits & 0x8000L) == 0) {
          this.extractPackage(instance.extractPackage());
          bits |= 0x8000L;
        }
        if ((bits & 0x10000L) == 0) {
          this.processEnv(instance.processEnv());
          bits |= 0x10000L;
        }
        if ((bits & 0x20000L) == 0) {
          this.processOutput(instance.processOutput());
          bits |= 0x20000L;
        }
        if ((bits & 0x40000L) == 0) {
          this.processWorkingDir(instance.processWorkingDir());
          bits |= 0x40000L;
        }
        if ((bits & 0x80000L) == 0) {
          this.distributionBaseUrl(instance.distributionBaseUrl());
          bits |= 0x80000L;
        }
      }
      if (object instanceof VersionAndPlatform) {
        VersionAndPlatform instance = (VersionAndPlatform) object;
        if ((bits & 0x8L) == 0) {
          this.distribution(instance.distribution());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          this.platform(instance.platform());
          bits |= 0x10L;
        }
        if ((bits & 0x80000L) == 0) {
          this.distributionBaseUrl(instance.distributionBaseUrl());
          bits |= 0x80000L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MongoImport#systemEnv() systemEnv} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#systemEnv() systemEnv}.</em>
     * @param systemEnv The value for systemEnv 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemEnv(Transition<SystemEnv> systemEnv) {
      this.systemEnv = Objects.requireNonNull(systemEnv, "systemEnv");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#systemProperties() systemProperties} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#systemProperties() systemProperties}.</em>
     * @param systemProperties The value for systemProperties 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder systemProperties(Transition<SystemProperties> systemProperties) {
      this.systemProperties = Objects.requireNonNull(systemProperties, "systemProperties");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#initTempDirectory() initTempDirectory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#initTempDirectory() initTempDirectory}.</em>
     * @param initTempDirectory The value for initTempDirectory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder initTempDirectory(InitTempDirectory initTempDirectory) {
      this.initTempDirectory = Objects.requireNonNull(initTempDirectory, "initTempDirectory");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#processWorkingDir() processWorkingDir} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#processWorkingDir() processWorkingDir}.</em>
     * @param processWorkingDir The value for processWorkingDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processWorkingDir(Transition<ProcessWorkingDir> processWorkingDir) {
      this.processWorkingDir = Objects.requireNonNull(processWorkingDir, "processWorkingDir");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#platform() platform} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#platform() platform}.</em>
     * @param platform The value for platform 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder platform(Transition<Platform> platform) {
      this.platform = Objects.requireNonNull(platform, "platform");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#distribution() distribution} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#distribution() distribution}.</em>
     * @param distribution The value for distribution 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder distribution(Transition<Distribution> distribution) {
      this.distribution = Objects.requireNonNull(distribution, "distribution");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#distributionBaseUrl() distributionBaseUrl} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#distributionBaseUrl() distributionBaseUrl}.</em>
     * @param distributionBaseUrl The value for distributionBaseUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder distributionBaseUrl(Transition<DistributionBaseUrl> distributionBaseUrl) {
      this.distributionBaseUrl = Objects.requireNonNull(distributionBaseUrl, "distributionBaseUrl");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#processConfig() processConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#processConfig() processConfig}.</em>
     * @param processConfig The value for processConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processConfig(ImmutableStart<ProcessConfig> processConfig) {
      this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#processEnv() processEnv} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#processEnv() processEnv}.</em>
     * @param processEnv The value for processEnv 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processEnv(Transition<ProcessEnv> processEnv) {
      this.processEnv = Objects.requireNonNull(processEnv, "processEnv");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#startTimeout() startTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#startTimeout() startTimeout}.</em>
     * @param startTimeout The value for startTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startTimeout(Transition<StartTimeout> startTimeout) {
      this.startTimeout = Objects.requireNonNull(startTimeout, "startTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#processOutput() processOutput} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#processOutput() processOutput}.</em>
     * @param processOutput The value for processOutput 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processOutput(Transition<ProcessOutput> processOutput) {
      this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#supportConfig() supportConfig} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#supportConfig() supportConfig}.</em>
     * @param supportConfig The value for supportConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder supportConfig(Transition<SupportConfig> supportConfig) {
      this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#commandName() commandName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#commandName() commandName}.</em>
     * @param commandName The value for commandName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder commandName(Transition<Name> commandName) {
      this.commandName = Objects.requireNonNull(commandName, "commandName");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#persistentBaseDir() persistentBaseDir} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#persistentBaseDir() persistentBaseDir}.</em>
     * @param persistentBaseDir The value for persistentBaseDir 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder persistentBaseDir(Transition<PersistentDir> persistentBaseDir) {
      this.persistentBaseDir = Objects.requireNonNull(persistentBaseDir, "persistentBaseDir");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#downloadCache() downloadCache} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#downloadCache() downloadCache}.</em>
     * @param downloadCache The value for downloadCache 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadCache(Transition<DownloadCache> downloadCache) {
      this.downloadCache = Objects.requireNonNull(downloadCache, "downloadCache");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#extractedFileSetStore() extractedFileSetStore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#extractedFileSetStore() extractedFileSetStore}.</em>
     * @param extractedFileSetStore The value for extractedFileSetStore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extractedFileSetStore(Transition<ExtractedFileSetStore> extractedFileSetStore) {
      this.extractedFileSetStore = Objects.requireNonNull(extractedFileSetStore, "extractedFileSetStore");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#downloadPackage() downloadPackage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#downloadPackage() downloadPackage}.</em>
     * @param downloadPackage The value for downloadPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadPackage(DownloadPackage downloadPackage) {
      this.downloadPackage = Objects.requireNonNull(downloadPackage, "downloadPackage");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#progressListener() progressListener} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#progressListener() progressListener}.</em>
     * @param progressListener The value for progressListener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder progressListener(Transition<ProgressListener> progressListener) {
      this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#extractPackage() extractPackage} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#extractPackage() extractPackage}.</em>
     * @param extractPackage The value for extractPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extractPackage(Transition<ExtractedFileSet> extractPackage) {
      this.extractPackage = Objects.requireNonNull(extractPackage, "extractPackage");
      return this;
    }

    /**
     * Initializes the value for the {@link MongoImport#packageOfDistribution() packageOfDistribution} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MongoImport#packageOfDistribution() packageOfDistribution}.</em>
     * @param packageOfDistribution The value for packageOfDistribution 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageOfDistribution(Transition<Package> packageOfDistribution) {
      this.packageOfDistribution = Objects.requireNonNull(packageOfDistribution, "packageOfDistribution");
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoImport ImmutableMongoImport}.
     * @return An immutable instance of MongoImport
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoImport build() {
      return new ImmutableMongoImport(this);
    }
  }
}
