/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.AuthenticationSetup;
import de.flapdoodle.embed.mongo.client.UsernamePassword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ImmutableUser
implements AuthenticationSetup.User {
    private final String database;
    private final UsernamePassword user;
    private final List<String> roles;

    private ImmutableUser(String database, UsernamePassword user) {
        this.database = Objects.requireNonNull(database, "database");
        this.user = Objects.requireNonNull(user, "user");
        this.roles = Collections.emptyList();
    }

    private ImmutableUser(String database, UsernamePassword user, List<String> roles) {
        this.database = database;
        this.user = user;
        this.roles = roles;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public UsernamePassword user() {
        return this.user;
    }

    @Override
    public List<String> roles() {
        return this.roles;
    }

    public final ImmutableUser withDatabase(String value) {
        String newValue = Objects.requireNonNull(value, "database");
        if (this.database.equals(newValue)) {
            return this;
        }
        return new ImmutableUser(newValue, this.user, this.roles);
    }

    public final ImmutableUser withUser(UsernamePassword value) {
        if (this.user == value) {
            return this;
        }
        UsernamePassword newValue = Objects.requireNonNull(value, "user");
        return new ImmutableUser(this.database, newValue, this.roles);
    }

    public final ImmutableUser withRoles(String ... elements) {
        List<String> newValue = ImmutableUser.createUnmodifiableList(false, ImmutableUser.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUser(this.database, this.user, newValue);
    }

    public final ImmutableUser withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutableUser.createUnmodifiableList(false, ImmutableUser.createSafeList(elements, true, false));
        return new ImmutableUser(this.database, this.user, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUser && this.equalsByValue((ImmutableUser)another);
    }

    private boolean equalsByValue(ImmutableUser another) {
        return this.database.equals(another.database) && this.user.equals(another.user) && this.roles.equals(another.roles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.database.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.roles.hashCode();
        return h;
    }

    public String toString() {
        return "User{database=" + this.database + ", user=" + this.user + ", roles=" + this.roles + "}";
    }

    public static ImmutableUser of(String database, UsernamePassword user) {
        return new ImmutableUser(database, user);
    }

    public static ImmutableUser copyOf(AuthenticationSetup.User instance) {
        if (instance instanceof ImmutableUser) {
            return (ImmutableUser)instance;
        }
        return ImmutableUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATABASE = 1L;
        private static final long INIT_BIT_USER = 2L;
        private long initBits = 3L;
        private String database;
        private UsernamePassword user;
        private List<String> roles = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(AuthenticationSetup.User instance) {
            Objects.requireNonNull(instance, "instance");
            this.database(instance.database());
            this.user(instance.user());
            this.addAllRoles(instance.roles());
            return this;
        }

        public final Builder database(String database) {
            this.database = Objects.requireNonNull(database, "database");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder user(UsernamePassword user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRoles(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        public ImmutableUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUser(this.database, this.user, ImmutableUser.createUnmodifiableList(true, this.roles));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("database");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build User, some of required attributes are not set " + attributes;
        }
    }
}

