package de.flapdoodle.embed.process.distribution;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Version.GenericVersion}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericVersion.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableGenericVersion.of()}.
 */
@Generated(from = "Version.GenericVersion", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableGenericVersion
    implements Version.GenericVersion {
  private final String asInDownloadPath;

  private ImmutableGenericVersion(String asInDownloadPath) {
    this.asInDownloadPath = Objects.requireNonNull(asInDownloadPath, "asInDownloadPath");
  }

  private ImmutableGenericVersion(ImmutableGenericVersion original, String asInDownloadPath) {
    this.asInDownloadPath = asInDownloadPath;
  }

  /**
   * @return The value of the {@code asInDownloadPath} attribute
   */
  @Override
  public String asInDownloadPath() {
    return asInDownloadPath;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Version.GenericVersion#asInDownloadPath() asInDownloadPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for asInDownloadPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericVersion withAsInDownloadPath(String value) {
    String newValue = Objects.requireNonNull(value, "asInDownloadPath");
    if (this.asInDownloadPath.equals(newValue)) return this;
    return new ImmutableGenericVersion(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericVersion} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericVersion
        && equalTo((ImmutableGenericVersion) another);
  }

  private boolean equalTo(ImmutableGenericVersion another) {
    return asInDownloadPath.equals(another.asInDownloadPath);
  }

  /**
   * Computes a hash code from attributes: {@code asInDownloadPath}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + asInDownloadPath.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GenericVersion} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GenericVersion{"
        + "asInDownloadPath=" + asInDownloadPath
        + "}";
  }

  /**
   * Construct a new immutable {@code GenericVersion} instance.
   * @param asInDownloadPath The value for the {@code asInDownloadPath} attribute
   * @return An immutable GenericVersion instance
   */
  public static ImmutableGenericVersion of(String asInDownloadPath) {
    return new ImmutableGenericVersion(asInDownloadPath);
  }

  /**
   * Creates an immutable copy of a {@link Version.GenericVersion} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GenericVersion instance
   */
  public static ImmutableGenericVersion copyOf(Version.GenericVersion instance) {
    if (instance instanceof ImmutableGenericVersion) {
      return (ImmutableGenericVersion) instance;
    }
    return ImmutableGenericVersion.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericVersion ImmutableGenericVersion}.
   * <pre>
   * ImmutableGenericVersion.builder()
   *    .asInDownloadPath(String) // required {@link Version.GenericVersion#asInDownloadPath() asInDownloadPath}
   *    .build();
   * </pre>
   * @return A new ImmutableGenericVersion builder
   */
  public static ImmutableGenericVersion.Builder builder() {
    return new ImmutableGenericVersion.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGenericVersion ImmutableGenericVersion}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Version.GenericVersion", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_AS_IN_DOWNLOAD_PATH = 0x1L;
    private long initBits = 0x1L;

    private String asInDownloadPath;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.distribution.Version.GenericVersion} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Version.GenericVersion instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.embed.process.distribution.Version} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Version instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Version.GenericVersion) {
        Version.GenericVersion instance = (Version.GenericVersion) object;
        if ((bits & 0x1L) == 0) {
          asInDownloadPath(instance.asInDownloadPath());
          bits |= 0x1L;
        }
      }
      if (object instanceof Version) {
        Version instance = (Version) object;
        if ((bits & 0x1L) == 0) {
          asInDownloadPath(instance.asInDownloadPath());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Version.GenericVersion#asInDownloadPath() asInDownloadPath} attribute.
     * @param asInDownloadPath The value for asInDownloadPath 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder asInDownloadPath(String asInDownloadPath) {
      this.asInDownloadPath = Objects.requireNonNull(asInDownloadPath, "asInDownloadPath");
      initBits &= ~INIT_BIT_AS_IN_DOWNLOAD_PATH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericVersion ImmutableGenericVersion}.
     * @return An immutable instance of GenericVersion
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericVersion build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenericVersion(null, asInDownloadPath);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_AS_IN_DOWNLOAD_PATH) != 0) attributes.add("asInDownloadPath");
      return "Cannot build GenericVersion, some of required attributes are not set " + attributes;
    }
  }
}
