package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.io.directories.Directory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DirectoryAndExecutableNaming}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDirectoryAndExecutableNaming.builder()}.
 */
@Generated(from = "DirectoryAndExecutableNaming", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDirectoryAndExecutableNaming
    extends DirectoryAndExecutableNaming {
  private final Directory directory;
  private final TempNaming executableNaming;

  private ImmutableDirectoryAndExecutableNaming(
      Directory directory,
      TempNaming executableNaming) {
    this.directory = directory;
    this.executableNaming = executableNaming;
  }

  /**
   * @return The value of the {@code directory} attribute
   */
  @Override
  public Directory getDirectory() {
    return directory;
  }

  /**
   * @return The value of the {@code executableNaming} attribute
   */
  @Override
  public TempNaming getExecutableNaming() {
    return executableNaming;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DirectoryAndExecutableNaming#getDirectory() directory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for directory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDirectoryAndExecutableNaming withDirectory(Directory value) {
    if (this.directory == value) return this;
    Directory newValue = Objects.requireNonNull(value, "directory");
    return new ImmutableDirectoryAndExecutableNaming(newValue, this.executableNaming);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DirectoryAndExecutableNaming#getExecutableNaming() executableNaming} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for executableNaming
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDirectoryAndExecutableNaming withExecutableNaming(TempNaming value) {
    if (this.executableNaming == value) return this;
    TempNaming newValue = Objects.requireNonNull(value, "executableNaming");
    return new ImmutableDirectoryAndExecutableNaming(this.directory, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDirectoryAndExecutableNaming} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDirectoryAndExecutableNaming
        && equalTo((ImmutableDirectoryAndExecutableNaming) another);
  }

  private boolean equalTo(ImmutableDirectoryAndExecutableNaming another) {
    return directory.equals(another.directory)
        && executableNaming.equals(another.executableNaming);
  }

  /**
   * Computes a hash code from attributes: {@code directory}, {@code executableNaming}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + directory.hashCode();
    h += (h << 5) + executableNaming.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DirectoryAndExecutableNaming} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DirectoryAndExecutableNaming{"
        + "directory=" + directory
        + ", executableNaming=" + executableNaming
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DirectoryAndExecutableNaming} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DirectoryAndExecutableNaming instance
   */
  public static ImmutableDirectoryAndExecutableNaming copyOf(DirectoryAndExecutableNaming instance) {
    if (instance instanceof ImmutableDirectoryAndExecutableNaming) {
      return (ImmutableDirectoryAndExecutableNaming) instance;
    }
    return ImmutableDirectoryAndExecutableNaming.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDirectoryAndExecutableNaming ImmutableDirectoryAndExecutableNaming}.
   * <pre>
   * ImmutableDirectoryAndExecutableNaming.builder()
   *    .directory(de.flapdoodle.embed.process.io.directories.Directory) // required {@link DirectoryAndExecutableNaming#getDirectory() directory}
   *    .executableNaming(de.flapdoodle.embed.process.extract.TempNaming) // required {@link DirectoryAndExecutableNaming#getExecutableNaming() executableNaming}
   *    .build();
   * </pre>
   * @return A new ImmutableDirectoryAndExecutableNaming builder
   */
  public static ImmutableDirectoryAndExecutableNaming.Builder builder() {
    return new ImmutableDirectoryAndExecutableNaming.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDirectoryAndExecutableNaming ImmutableDirectoryAndExecutableNaming}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DirectoryAndExecutableNaming", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DIRECTORY = 0x1L;
    private static final long INIT_BIT_EXECUTABLE_NAMING = 0x2L;
    private long initBits = 0x3L;

    private Directory directory;
    private TempNaming executableNaming;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DirectoryAndExecutableNaming} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DirectoryAndExecutableNaming instance) {
      Objects.requireNonNull(instance, "instance");
      directory(instance.getDirectory());
      executableNaming(instance.getExecutableNaming());
      return this;
    }

    /**
     * Initializes the value for the {@link DirectoryAndExecutableNaming#getDirectory() directory} attribute.
     * @param directory The value for directory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder directory(Directory directory) {
      this.directory = Objects.requireNonNull(directory, "directory");
      initBits &= ~INIT_BIT_DIRECTORY;
      return this;
    }

    /**
     * Initializes the value for the {@link DirectoryAndExecutableNaming#getExecutableNaming() executableNaming} attribute.
     * @param executableNaming The value for executableNaming 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder executableNaming(TempNaming executableNaming) {
      this.executableNaming = Objects.requireNonNull(executableNaming, "executableNaming");
      initBits &= ~INIT_BIT_EXECUTABLE_NAMING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDirectoryAndExecutableNaming ImmutableDirectoryAndExecutableNaming}.
     * @return An immutable instance of DirectoryAndExecutableNaming
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDirectoryAndExecutableNaming build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDirectoryAndExecutableNaming(directory, executableNaming);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DIRECTORY) != 0) attributes.add("directory");
      if ((initBits & INIT_BIT_EXECUTABLE_NAMING) != 0) attributes.add("executableNaming");
      return "Cannot build DirectoryAndExecutableNaming, some of required attributes are not set " + attributes;
    }
  }
}
