package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExtractedArtifactStore}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExtractedArtifactStore.builder()}.
 */
@Generated(from = "ExtractedArtifactStore", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableExtractedArtifactStore
    extends ExtractedArtifactStore {
  private final DownloadConfig downloadConfig;
  private final Downloader downloader;
  private final DirectoryAndExecutableNaming extraction;
  private final DirectoryAndExecutableNaming temp;

  private ImmutableExtractedArtifactStore(
      DownloadConfig downloadConfig,
      Downloader downloader,
      DirectoryAndExecutableNaming extraction,
      DirectoryAndExecutableNaming temp) {
    this.downloadConfig = downloadConfig;
    this.downloader = downloader;
    this.extraction = extraction;
    this.temp = temp;
  }

  /**
   * @return The value of the {@code downloadConfig} attribute
   */
  @Override
  DownloadConfig downloadConfig() {
    return downloadConfig;
  }

  /**
   * @return The value of the {@code downloader} attribute
   */
  @Override
  Downloader downloader() {
    return downloader;
  }

  /**
   * @return The value of the {@code extraction} attribute
   */
  @Override
  DirectoryAndExecutableNaming extraction() {
    return extraction;
  }

  /**
   * @return The value of the {@code temp} attribute
   */
  @Override
  DirectoryAndExecutableNaming temp() {
    return temp;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedArtifactStore#downloadConfig() downloadConfig} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloadConfig
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedArtifactStore withDownloadConfig(DownloadConfig value) {
    if (this.downloadConfig == value) return this;
    DownloadConfig newValue = Objects.requireNonNull(value, "downloadConfig");
    return new ImmutableExtractedArtifactStore(newValue, this.downloader, this.extraction, this.temp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedArtifactStore#downloader() downloader} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for downloader
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedArtifactStore withDownloader(Downloader value) {
    if (this.downloader == value) return this;
    Downloader newValue = Objects.requireNonNull(value, "downloader");
    return new ImmutableExtractedArtifactStore(this.downloadConfig, newValue, this.extraction, this.temp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedArtifactStore#extraction() extraction} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for extraction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedArtifactStore withExtraction(DirectoryAndExecutableNaming value) {
    if (this.extraction == value) return this;
    DirectoryAndExecutableNaming newValue = Objects.requireNonNull(value, "extraction");
    return new ImmutableExtractedArtifactStore(this.downloadConfig, this.downloader, newValue, this.temp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExtractedArtifactStore#temp() temp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExtractedArtifactStore withTemp(DirectoryAndExecutableNaming value) {
    if (this.temp == value) return this;
    DirectoryAndExecutableNaming newValue = Objects.requireNonNull(value, "temp");
    return new ImmutableExtractedArtifactStore(this.downloadConfig, this.downloader, this.extraction, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExtractedArtifactStore} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExtractedArtifactStore
        && equalTo((ImmutableExtractedArtifactStore) another);
  }

  private boolean equalTo(ImmutableExtractedArtifactStore another) {
    return downloadConfig.equals(another.downloadConfig)
        && downloader.equals(another.downloader)
        && extraction.equals(another.extraction)
        && temp.equals(another.temp);
  }

  /**
   * Computes a hash code from attributes: {@code downloadConfig}, {@code downloader}, {@code extraction}, {@code temp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + downloadConfig.hashCode();
    h += (h << 5) + downloader.hashCode();
    h += (h << 5) + extraction.hashCode();
    h += (h << 5) + temp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExtractedArtifactStore} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExtractedArtifactStore{"
        + "downloadConfig=" + downloadConfig
        + ", downloader=" + downloader
        + ", extraction=" + extraction
        + ", temp=" + temp
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExtractedArtifactStore} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExtractedArtifactStore instance
   */
  public static ImmutableExtractedArtifactStore copyOf(ExtractedArtifactStore instance) {
    if (instance instanceof ImmutableExtractedArtifactStore) {
      return (ImmutableExtractedArtifactStore) instance;
    }
    return ImmutableExtractedArtifactStore.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExtractedArtifactStore ImmutableExtractedArtifactStore}.
   * <pre>
   * ImmutableExtractedArtifactStore.builder()
   *    .downloadConfig(de.flapdoodle.embed.process.config.store.DownloadConfig) // required {@link ExtractedArtifactStore#downloadConfig() downloadConfig}
   *    .downloader(de.flapdoodle.embed.process.store.Downloader) // required {@link ExtractedArtifactStore#downloader() downloader}
   *    .extraction(de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming) // required {@link ExtractedArtifactStore#extraction() extraction}
   *    .temp(de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming) // required {@link ExtractedArtifactStore#temp() temp}
   *    .build();
   * </pre>
   * @return A new ImmutableExtractedArtifactStore builder
   */
  public static ImmutableExtractedArtifactStore.Builder builder() {
    return new ImmutableExtractedArtifactStore.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExtractedArtifactStore ImmutableExtractedArtifactStore}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExtractedArtifactStore", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOWNLOAD_CONFIG = 0x1L;
    private static final long INIT_BIT_DOWNLOADER = 0x2L;
    private static final long INIT_BIT_EXTRACTION = 0x4L;
    private static final long INIT_BIT_TEMP = 0x8L;
    private long initBits = 0xfL;

    private DownloadConfig downloadConfig;
    private Downloader downloader;
    private DirectoryAndExecutableNaming extraction;
    private DirectoryAndExecutableNaming temp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExtractedArtifactStore} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExtractedArtifactStore instance) {
      Objects.requireNonNull(instance, "instance");
      downloadConfig(instance.downloadConfig());
      downloader(instance.downloader());
      extraction(instance.extraction());
      temp(instance.temp());
      return this;
    }

    /**
     * Initializes the value for the {@link ExtractedArtifactStore#downloadConfig() downloadConfig} attribute.
     * @param downloadConfig The value for downloadConfig 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloadConfig(DownloadConfig downloadConfig) {
      this.downloadConfig = Objects.requireNonNull(downloadConfig, "downloadConfig");
      initBits &= ~INIT_BIT_DOWNLOAD_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtractedArtifactStore#downloader() downloader} attribute.
     * @param downloader The value for downloader 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder downloader(Downloader downloader) {
      this.downloader = Objects.requireNonNull(downloader, "downloader");
      initBits &= ~INIT_BIT_DOWNLOADER;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtractedArtifactStore#extraction() extraction} attribute.
     * @param extraction The value for extraction 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder extraction(DirectoryAndExecutableNaming extraction) {
      this.extraction = Objects.requireNonNull(extraction, "extraction");
      initBits &= ~INIT_BIT_EXTRACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link ExtractedArtifactStore#temp() temp} attribute.
     * @param temp The value for temp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temp(DirectoryAndExecutableNaming temp) {
      this.temp = Objects.requireNonNull(temp, "temp");
      initBits &= ~INIT_BIT_TEMP;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExtractedArtifactStore ImmutableExtractedArtifactStore}.
     * @return An immutable instance of ExtractedArtifactStore
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExtractedArtifactStore build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExtractedArtifactStore(downloadConfig, downloader, extraction, temp);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOWNLOAD_CONFIG) != 0) attributes.add("downloadConfig");
      if ((initBits & INIT_BIT_DOWNLOADER) != 0) attributes.add("downloader");
      if ((initBits & INIT_BIT_EXTRACTION) != 0) attributes.add("extraction");
      if ((initBits & INIT_BIT_TEMP) != 0) attributes.add("temp");
      return "Cannot build ExtractedArtifactStore, some of required attributes are not set " + attributes;
    }
  }
}
