/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.extract.ExtractedFileSets;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.ImmutableDirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.file.FileAlreadyExistsException;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableExtractedArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ExtractedArtifactStore
implements IArtifactStore {
    abstract DownloadConfig downloadConfig();

    abstract Downloader downloader();

    abstract DirectoryAndExecutableNaming extraction();

    abstract DirectoryAndExecutableNaming temp();

    private ArtifactStore store(Directory withDistribution, TempNaming naming) {
        return ArtifactStore.builder().downloadConfig(this.downloadConfig()).tempDirFactory(withDistribution).executableNaming(naming).downloader(this.downloader()).build();
    }

    @Deprecated
    public ExtractedArtifactStore executableNaming(TempNaming tempNaming) {
        return ImmutableExtractedArtifactStore.copyOf(this).withExtraction(ImmutableDirectoryAndExecutableNaming.copyOf(this.extraction()).withExecutableNaming(tempNaming));
    }

    @Deprecated
    public ExtractedArtifactStore download(ImmutableDownloadConfig.Builder downloadConfigBuilder) {
        return ImmutableExtractedArtifactStore.copyOf(this).withDownloadConfig(downloadConfigBuilder.build());
    }

    @Override
    public Optional<ExtractedFileSet> extractFileSet(Distribution distribution) throws IOException {
        ExtractedFileSet extractedFileSet;
        Directory withDistribution = ExtractedArtifactStore.withDistribution(this.extraction().getDirectory(), distribution);
        ArtifactStore baseStore = this.store(withDistribution, this.extraction().getExecutableNaming());
        boolean foundExecutable = false;
        File destinationDir = withDistribution.asFile();
        ImmutableExtractedFileSet.Builder fileSetBuilder = ExtractedFileSet.builder(destinationDir).baseDirIsGenerated(withDistribution.isGenerated());
        FilesToExtract filesToExtract = baseStore.filesToExtract(distribution);
        for (FileSet.Entry file : filesToExtract.files()) {
            if (file.type() == FileType.Executable) {
                String executableName = FilesToExtract.executableName(this.extraction().getExecutableNaming(), file);
                File executableFile = new File(executableName);
                File resolvedExecutableFile = new File(destinationDir, executableName);
                if (resolvedExecutableFile.isFile()) {
                    foundExecutable = true;
                }
                fileSetBuilder.executable(executableFile);
                continue;
            }
            fileSetBuilder.addLibraryFiles(new File(FilesToExtract.fileName(file)));
        }
        if (!foundExecutable) {
            try {
                extractedFileSet = baseStore.extractFileSet(distribution).get();
            }
            catch (FileAlreadyExistsException fx) {
                throw new RuntimeException("extraction to " + destinationDir + " has failed", fx);
            }
        } else {
            extractedFileSet = fileSetBuilder.build();
        }
        return Optional.ofNullable(ExtractedFileSets.copy(extractedFileSet, this.temp().getDirectory(), this.temp().getExecutableNaming()));
    }

    private static Directory withDistribution(final Directory dir, final Distribution distribution) {
        return new Directory(){

            @Override
            public boolean isGenerated() {
                return dir.isGenerated();
            }

            @Override
            public File asFile() {
                File file = new File(dir.asFile(), ExtractedArtifactStore.asPath(distribution));
                if (!file.exists() && !file.mkdirs()) {
                    throw new RuntimeException("could not create dir " + file);
                }
                return file;
            }
        };
    }

    static String asPath(Distribution distribution) {
        return distribution.platform().name() + "-" + distribution.bitsize().name() + "--" + distribution.version().asInDownloadPath();
    }

    @Override
    public void removeFileSet(Distribution distribution, ExtractedFileSet files) {
        ExtractedFileSets.delete(files);
    }

    public static ImmutableExtractedArtifactStore.Builder builder() {
        return ImmutableExtractedArtifactStore.builder();
    }

    public static ExtractedArtifactStore of(DownloadConfig downloadConfig, Downloader downloader, DirectoryAndExecutableNaming extract, DirectoryAndExecutableNaming temp) {
        return ExtractedArtifactStore.builder().downloadConfig(downloadConfig).downloader(downloader).extraction(extract).temp(temp).build();
    }
}

