/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.process;

import de.flapdoodle.embed.process.config.process.ImmutableProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.StreamProcessor;
import org.immutables.value.Value;
import org.slf4j.Logger;

@Value.Immutable
public interface ProcessOutput {
    public StreamProcessor output();

    public StreamProcessor error();

    public StreamProcessor commands();

    public static ProcessOutput namedConsole(String label) {
        return ProcessOutput.builder().output(Processors.namedConsole("[" + label + " output]")).error(Processors.namedConsole("[" + label + " error]")).commands(Processors.console()).build();
    }

    public static ProcessOutput silent() {
        return ProcessOutput.builder().output(Processors.silent()).error(Processors.silent()).commands(Processors.silent()).build();
    }

    public static ProcessOutput named(String label, Logger logger) {
        return ProcessOutput.builder().output(Processors.named("[" + label + " output]", Processors.logTo(logger, Slf4jLevel.INFO))).error(Processors.named("[" + label + " error]", Processors.logTo(logger, Slf4jLevel.ERROR))).commands(Processors.logTo(logger, Slf4jLevel.DEBUG)).build();
    }

    public static ImmutableProcessOutput.Builder builder() {
        return ImmutableProcessOutput.builder();
    }
}

