/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="FileSet", generator="Immutables")
public final class ImmutableFileSet
implements FileSet {
    private final List<FileSet.Entry> entries;

    private ImmutableFileSet(List<FileSet.Entry> entries) {
        this.entries = entries;
    }

    @Override
    public List<FileSet.Entry> entries() {
        return this.entries;
    }

    public final ImmutableFileSet withEntries(FileSet.Entry ... elements) {
        List<FileSet.Entry> newValue = ImmutableFileSet.createUnmodifiableList(false, ImmutableFileSet.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableFileSet.validate(new ImmutableFileSet(newValue));
    }

    public final ImmutableFileSet withEntries(Iterable<? extends FileSet.Entry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<FileSet.Entry> newValue = ImmutableFileSet.createUnmodifiableList(false, ImmutableFileSet.createSafeList(elements, true, false));
        return ImmutableFileSet.validate(new ImmutableFileSet(newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileSet && this.equalTo((ImmutableFileSet)another);
    }

    private boolean equalTo(ImmutableFileSet another) {
        return this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return "FileSet{entries=" + this.entries + "}";
    }

    private static ImmutableFileSet validate(ImmutableFileSet instance) {
        instance.shouldContainOneMoreExecutable();
        return instance;
    }

    public static ImmutableFileSet copyOf(FileSet instance) {
        if (instance instanceof ImmutableFileSet) {
            return (ImmutableFileSet)instance;
        }
        return new FileSet.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FileSet", generator="Immutables")
    public static class Builder {
        private List<FileSet.Entry> entries = new ArrayList<FileSet.Entry>();

        public Builder() {
            if (!(this instanceof FileSet.Builder)) {
                throw new UnsupportedOperationException("Use: new FileSet.Builder()");
            }
        }

        public final FileSet.Builder from(FileSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEntries(instance.entries());
            return (FileSet.Builder)this;
        }

        public final FileSet.Builder addEntries(FileSet.Entry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return (FileSet.Builder)this;
        }

        public final FileSet.Builder addEntries(FileSet.Entry ... elements) {
            for (FileSet.Entry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return (FileSet.Builder)this;
        }

        public final FileSet.Builder entries(Iterable<? extends FileSet.Entry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final FileSet.Builder addAllEntries(Iterable<? extends FileSet.Entry> elements) {
            for (FileSet.Entry entry : elements) {
                this.entries.add(Objects.requireNonNull(entry, "entries element"));
            }
            return (FileSet.Builder)this;
        }

        public ImmutableFileSet build() {
            return ImmutableFileSet.validate(new ImmutableFileSet(ImmutableFileSet.createUnmodifiableList(true, this.entries)));
        }
    }
}

