/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.ExtractedFileSet;
import de.flapdoodle.embed.process.extract.ExtractedFileSets;
import de.flapdoodle.embed.process.extract.Extractor;
import de.flapdoodle.embed.process.extract.Extractors;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.store.CachingArtifactStore;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableArtifactStore;
import de.flapdoodle.embed.process.store.LocalArtifactStore;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ArtifactStore
implements IArtifactStore {
    abstract DownloadConfig downloadConfig();

    abstract Directory tempDirFactory();

    abstract TempNaming executableNaming();

    abstract Downloader downloader();

    @Value.Auxiliary
    public ArtifactStore with(Directory tempDirFactory, TempNaming executableNaming) {
        return ImmutableArtifactStore.copyOf(this).withTempDirFactory(tempDirFactory).withExecutableNaming(executableNaming);
    }

    @Deprecated
    public ArtifactStore executableNaming(TempNaming tempNaming) {
        return ImmutableArtifactStore.copyOf(this).withExecutableNaming(tempNaming);
    }

    public CachingArtifactStore withCache() {
        return new CachingArtifactStore(this);
    }

    private boolean checkDistribution(Distribution distribution) throws IOException {
        return LocalArtifactStore.checkArtifact(this.downloadConfig(), distribution) || LocalArtifactStore.store(this.downloadConfig(), distribution, this.downloader().download(this.downloadConfig(), distribution));
    }

    @Override
    public Optional<ExtractedFileSet> extractFileSet(Distribution distribution) throws IOException {
        if (this.checkDistribution(distribution)) {
            PackageResolver packageResolver = this.downloadConfig().getPackageResolver();
            FilesToExtract toExtract = this.filesToExtract(distribution);
            Extractor extractor = Extractors.getExtractor(packageResolver.packageFor(distribution).archiveType());
            File artifact = LocalArtifactStore.getArtifact(this.downloadConfig(), distribution);
            return Optional.of(extractor.extract(this.downloadConfig(), artifact, toExtract));
        }
        return Optional.empty();
    }

    FilesToExtract filesToExtract(Distribution distribution) {
        return new FilesToExtract(this.tempDirFactory(), this.executableNaming(), this.downloadConfig().getPackageResolver().packageFor(distribution).fileSet());
    }

    @Override
    public void removeFileSet(Distribution distribution, ExtractedFileSet all) {
        ExtractedFileSets.delete(all);
    }

    public static ImmutableArtifactStore.Builder builder() {
        return ImmutableArtifactStore.builder();
    }
}

