/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.distribution;

import de.flapdoodle.embed.process.distribution.ImmutableDistribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.os.Platform;
import java.util.List;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public abstract class Distribution {
    private static final Logger logger = LoggerFactory.getLogger(Distribution.class);

    @Value.Parameter
    public abstract Version version();

    @Value.Parameter
    public abstract Platform platform();

    public String toString() {
        return "" + this.version() + ":" + this.platform();
    }

    public static Distribution detectFor(Version version) {
        List platforms = Platform.guess();
        if (platforms.isEmpty()) {
            throw new IllegalArgumentException("could not detect platform");
        }
        Platform platform = (Platform)platforms.get(0);
        if (platforms.size() != 1) {
            logger.info("more than one platform detected: {}", (Object)platforms);
            logger.info("use {}", (Object)platform);
        }
        return Distribution.of(version, platform);
    }

    public static Distribution of(Version version, Platform platform) {
        return ImmutableDistribution.of(version, platform);
    }
}

