/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.parts;

import de.flapdoodle.embed.process.config.TimeoutConfig;
import de.flapdoodle.embed.process.net.UrlStreams;
import de.flapdoodle.embed.process.parts.ArtifactPathForUrl;
import de.flapdoodle.embed.process.types.ArtifactPath;
import de.flapdoodle.embed.process.types.ArtifactUrl;
import de.flapdoodle.embed.process.types.ArtifactsBasePath;
import de.flapdoodle.embed.process.types.LocalArtifactPath;
import de.flapdoodle.types.Try;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.Optional;

public class CachingArtifactDownloader
implements ArtifactPathForUrl {
    private final TimeoutConfig timeoutConfig = TimeoutConfig.defaults();
    private final UrlStreams.DownloadCopyListener listener;

    public CachingArtifactDownloader(UrlStreams.DownloadCopyListener listener) {
        this.listener = listener;
    }

    @Override
    public ArtifactPath apply(ArtifactsBasePath basePath, ArtifactUrl url, LocalArtifactPath localPath) {
        Path artifactPath = basePath.value().resolve(localPath.value());
        if (!artifactPath.toFile().exists()) {
            return (ArtifactPath)Try.supplier(() -> {
                URL downloadUrl = new URL(url.value());
                URLConnection connection = UrlStreams.urlConnectionOf(downloadUrl, "flapdoodle-user-agent", this.timeoutConfig, Optional.empty());
                UrlStreams.downloadTo(connection, artifactPath, this.listener);
                return ArtifactPath.of(artifactPath);
            }).mapCheckedException(RuntimeException::new).get();
        }
        return ArtifactPath.of(artifactPath);
    }
}

