/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.io.directories;

import de.flapdoodle.embed.process.io.directories.ImmutablePersistentDir;
import de.flapdoodle.embed.process.types.Wrapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PersistentDir
extends Wrapper<Path> {
    public static PersistentDir of(Path path) {
        return ImmutablePersistentDir.of(path);
    }

    public static Path userHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static Supplier<PersistentDir> userHome(String subDir) {
        return () -> PersistentDir.of(PersistentDir.userHome().resolve(subDir));
    }
}

