package de.flapdoodle.embed.process.config.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link UncompiledPattern}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUncompiledPattern.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUncompiledPattern.of()}.
 */
@SuppressWarnings({"all"})
public final class ImmutableUncompiledPattern
    implements UncompiledPattern {
  private final String regex;
  private final int flags;

  private ImmutableUncompiledPattern(String regex, int flags) {
    this.regex = Objects.requireNonNull(regex, "regex");
    this.flags = flags;
  }

  private ImmutableUncompiledPattern(ImmutableUncompiledPattern original, String regex, int flags) {
    this.regex = regex;
    this.flags = flags;
  }

  /**
   * @return The value of the {@code regex} attribute
   */
  @Override
  public String regex() {
    return regex;
  }

  /**
   * @return The value of the {@code flags} attribute
   */
  @Override
  public int flags() {
    return flags;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UncompiledPattern#regex() regex} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for regex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUncompiledPattern withRegex(String value) {
    String newValue = Objects.requireNonNull(value, "regex");
    if (this.regex.equals(newValue)) return this;
    return new ImmutableUncompiledPattern(this, newValue, this.flags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UncompiledPattern#flags() flags} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUncompiledPattern withFlags(int value) {
    if (this.flags == value) return this;
    return new ImmutableUncompiledPattern(this, this.regex, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUncompiledPattern} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUncompiledPattern
        && equalTo(0, (ImmutableUncompiledPattern) another);
  }

  private boolean equalTo(int synthetic, ImmutableUncompiledPattern another) {
    return regex.equals(another.regex)
        && flags == another.flags;
  }

  /**
   * Computes a hash code from attributes: {@code regex}, {@code flags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + regex.hashCode();
    h += (h << 5) + flags;
    return h;
  }

  /**
   * Prints the immutable value {@code UncompiledPattern} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UncompiledPattern{"
        + "regex=" + regex
        + ", flags=" + flags
        + "}";
  }

  /**
   * Construct a new immutable {@code UncompiledPattern} instance.
   * @param regex The value for the {@code regex} attribute
   * @param flags The value for the {@code flags} attribute
   * @return An immutable UncompiledPattern instance
   */
  public static ImmutableUncompiledPattern of(String regex, int flags) {
    return new ImmutableUncompiledPattern(regex, flags);
  }

  /**
   * Creates an immutable copy of a {@link UncompiledPattern} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UncompiledPattern instance
   */
  public static ImmutableUncompiledPattern copyOf(UncompiledPattern instance) {
    if (instance instanceof ImmutableUncompiledPattern) {
      return (ImmutableUncompiledPattern) instance;
    }
    return ImmutableUncompiledPattern.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUncompiledPattern ImmutableUncompiledPattern}.
   * <pre>
   * ImmutableUncompiledPattern.builder()
   *    .regex(String) // required {@link UncompiledPattern#regex() regex}
   *    .flags(int) // required {@link UncompiledPattern#flags() flags}
   *    .build();
   * </pre>
   * @return A new ImmutableUncompiledPattern builder
   */
  public static ImmutableUncompiledPattern.Builder builder() {
    return new ImmutableUncompiledPattern.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUncompiledPattern ImmutableUncompiledPattern}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_REGEX = 0x1L;
    private static final long INIT_BIT_FLAGS = 0x2L;
    private long initBits = 0x3L;

    private String regex;
    private int flags;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UncompiledPattern} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UncompiledPattern instance) {
      Objects.requireNonNull(instance, "instance");
      regex(instance.regex());
      flags(instance.flags());
      return this;
    }

    /**
     * Initializes the value for the {@link UncompiledPattern#regex() regex} attribute.
     * @param regex The value for regex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder regex(String regex) {
      this.regex = Objects.requireNonNull(regex, "regex");
      initBits &= ~INIT_BIT_REGEX;
      return this;
    }

    /**
     * Initializes the value for the {@link UncompiledPattern#flags() flags} attribute.
     * @param flags The value for flags 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder flags(int flags) {
      this.flags = flags;
      initBits &= ~INIT_BIT_FLAGS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUncompiledPattern ImmutableUncompiledPattern}.
     * @return An immutable instance of UncompiledPattern
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUncompiledPattern build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUncompiledPattern(null, regex, flags);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REGEX) != 0) attributes.add("regex");
      if ((initBits & INIT_BIT_FLAGS) != 0) attributes.add("flags");
      return "Cannot build UncompiledPattern, some of required attributes are not set " + attributes;
    }
  }
}
