/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.types;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.process.types.ImmutablePercent;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Percent {
    private static final int MIN = 0;
    private static final int MAX = 100;

    @Value.Parameter
    public abstract int value();

    @Value.Auxiliary
    public boolean isMax() {
        return this.value() == 100;
    }

    @Value.Auxiliary
    public boolean isMin() {
        return this.value() == 0;
    }

    @Value.Check
    protected void check() {
        Preconditions.checkArgument((this.value() >= 0 ? 1 : 0) != 0, (String)"%s < 0", (Object[])new Object[]{this.value()});
        Preconditions.checkArgument((this.value() <= 100 ? 1 : 0) != 0, (String)"%s > 100", (Object[])new Object[]{this.value()});
    }

    public static Percent of(int value) {
        return ImmutablePercent.of(value);
    }

    public static Percent max() {
        return Percent.of(100);
    }

    public static Percent min() {
        return Percent.of(0);
    }
}

