/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.transitions.Starter;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.embed.process.types.RunningProcess;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Starter", generator="Immutables")
public final class ImmutableStarter<T extends RunningProcess>
extends Starter<T> {
    private final StateID<ExtractedFileSet> processExecutable;
    private final StateID<ProcessWorkingDir> processWorkingDir;
    private final StateID<ProcessConfig> processConfig;
    private final StateID<ProcessEnv> processEnv;
    private final StateID<ProcessArguments> arguments;
    private final StateID<ProcessOutput> processOutput;
    private final StateID<SupportConfig> supportConfig;
    private final String transitionLabel;
    private final StateID<T> destination;
    private final RunningProcessFactory<T> runningProcessFactory;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStarter(Builder<T> builder) {
        this.destination = ((Builder)builder).destination;
        this.runningProcessFactory = ((Builder)builder).runningProcessFactory;
        if (((Builder)builder).processExecutable != null) {
            this.initShim.processExecutable((StateID<ExtractedFileSet>)((Builder)builder).processExecutable);
        }
        if (((Builder)builder).processWorkingDir != null) {
            this.initShim.processWorkingDir((StateID<ProcessWorkingDir>)((Builder)builder).processWorkingDir);
        }
        if (((Builder)builder).processConfig != null) {
            this.initShim.processConfig((StateID<ProcessConfig>)((Builder)builder).processConfig);
        }
        if (((Builder)builder).processEnv != null) {
            this.initShim.processEnv((StateID<ProcessEnv>)((Builder)builder).processEnv);
        }
        if (((Builder)builder).arguments != null) {
            this.initShim.arguments((StateID<ProcessArguments>)((Builder)builder).arguments);
        }
        if (((Builder)builder).processOutput != null) {
            this.initShim.processOutput((StateID<ProcessOutput>)((Builder)builder).processOutput);
        }
        if (((Builder)builder).supportConfig != null) {
            this.initShim.supportConfig((StateID<SupportConfig>)((Builder)builder).supportConfig);
        }
        if (((Builder)builder).transitionLabel != null) {
            this.initShim.transitionLabel(((Builder)builder).transitionLabel);
        }
        this.processExecutable = this.initShim.processExecutable();
        this.processWorkingDir = this.initShim.processWorkingDir();
        this.processConfig = this.initShim.processConfig();
        this.processEnv = this.initShim.processEnv();
        this.arguments = this.initShim.arguments();
        this.processOutput = this.initShim.processOutput();
        this.supportConfig = this.initShim.supportConfig();
        this.transitionLabel = this.initShim.transitionLabel();
        this.initShim = null;
    }

    private ImmutableStarter(StateID<ExtractedFileSet> processExecutable, StateID<ProcessWorkingDir> processWorkingDir, StateID<ProcessConfig> processConfig, StateID<ProcessEnv> processEnv, StateID<ProcessArguments> arguments, StateID<ProcessOutput> processOutput, StateID<SupportConfig> supportConfig, String transitionLabel, StateID<T> destination, RunningProcessFactory<T> runningProcessFactory) {
        this.processExecutable = processExecutable;
        this.processWorkingDir = processWorkingDir;
        this.processConfig = processConfig;
        this.processEnv = processEnv;
        this.arguments = arguments;
        this.processOutput = processOutput;
        this.supportConfig = supportConfig;
        this.transitionLabel = transitionLabel;
        this.destination = destination;
        this.runningProcessFactory = runningProcessFactory;
        this.initShim = null;
    }

    @Override
    public StateID<ExtractedFileSet> processExecutable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processExecutable() : this.processExecutable;
    }

    @Override
    public StateID<ProcessWorkingDir> processWorkingDir() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processWorkingDir() : this.processWorkingDir;
    }

    @Override
    public StateID<ProcessConfig> processConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processConfig() : this.processConfig;
    }

    @Override
    public StateID<ProcessEnv> processEnv() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processEnv() : this.processEnv;
    }

    @Override
    public StateID<ProcessArguments> arguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.arguments() : this.arguments;
    }

    @Override
    public StateID<ProcessOutput> processOutput() {
        InitShim shim = this.initShim;
        return shim != null ? shim.processOutput() : this.processOutput;
    }

    @Override
    public StateID<SupportConfig> supportConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportConfig() : this.supportConfig;
    }

    @Override
    public String transitionLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transitionLabel() : this.transitionLabel;
    }

    @Override
    public StateID<T> destination() {
        return this.destination;
    }

    @Override
    protected RunningProcessFactory<T> runningProcessFactory() {
        return this.runningProcessFactory;
    }

    public final ImmutableStarter<T> withProcessExecutable(StateID<ExtractedFileSet> value) {
        if (this.processExecutable == value) {
            return this;
        }
        StateID<ExtractedFileSet> newValue = Objects.requireNonNull(value, "processExecutable");
        return new ImmutableStarter<T>(newValue, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withProcessWorkingDir(StateID<ProcessWorkingDir> value) {
        if (this.processWorkingDir == value) {
            return this;
        }
        StateID<ProcessWorkingDir> newValue = Objects.requireNonNull(value, "processWorkingDir");
        return new ImmutableStarter<T>(this.processExecutable, newValue, this.processConfig, this.processEnv, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withProcessConfig(StateID<ProcessConfig> value) {
        if (this.processConfig == value) {
            return this;
        }
        StateID<ProcessConfig> newValue = Objects.requireNonNull(value, "processConfig");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, newValue, this.processEnv, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withProcessEnv(StateID<ProcessEnv> value) {
        if (this.processEnv == value) {
            return this;
        }
        StateID<ProcessEnv> newValue = Objects.requireNonNull(value, "processEnv");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, newValue, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withArguments(StateID<ProcessArguments> value) {
        if (this.arguments == value) {
            return this;
        }
        StateID<ProcessArguments> newValue = Objects.requireNonNull(value, "arguments");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, newValue, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withProcessOutput(StateID<ProcessOutput> value) {
        if (this.processOutput == value) {
            return this;
        }
        StateID<ProcessOutput> newValue = Objects.requireNonNull(value, "processOutput");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, newValue, this.supportConfig, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withSupportConfig(StateID<SupportConfig> value) {
        if (this.supportConfig == value) {
            return this;
        }
        StateID<SupportConfig> newValue = Objects.requireNonNull(value, "supportConfig");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, this.processOutput, newValue, this.transitionLabel, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, this.processOutput, this.supportConfig, newValue, this.destination, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withDestination(StateID<T> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<T> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, newValue, this.runningProcessFactory);
    }

    public final ImmutableStarter<T> withRunningProcessFactory(RunningProcessFactory<T> value) {
        if (this.runningProcessFactory == value) {
            return this;
        }
        RunningProcessFactory<T> newValue = Objects.requireNonNull(value, "runningProcessFactory");
        return new ImmutableStarter<T>(this.processExecutable, this.processWorkingDir, this.processConfig, this.processEnv, this.arguments, this.processOutput, this.supportConfig, this.transitionLabel, this.destination, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStarter && this.equalTo(0, (ImmutableStarter)another);
    }

    private boolean equalTo(int synthetic, ImmutableStarter<?> another) {
        return this.processExecutable.equals(another.processExecutable) && this.processWorkingDir.equals(another.processWorkingDir) && this.processConfig.equals(another.processConfig) && this.processEnv.equals(another.processEnv) && this.arguments.equals(another.arguments) && this.processOutput.equals(another.processOutput) && this.supportConfig.equals(another.supportConfig) && this.transitionLabel.equals(another.transitionLabel) && this.destination.equals(another.destination) && this.runningProcessFactory.equals(another.runningProcessFactory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.processExecutable.hashCode();
        h += (h << 5) + this.processWorkingDir.hashCode();
        h += (h << 5) + this.processConfig.hashCode();
        h += (h << 5) + this.processEnv.hashCode();
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + this.processOutput.hashCode();
        h += (h << 5) + this.supportConfig.hashCode();
        h += (h << 5) + this.transitionLabel.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.runningProcessFactory.hashCode();
        return h;
    }

    public String toString() {
        return "Starter{processExecutable=" + this.processExecutable + ", processWorkingDir=" + this.processWorkingDir + ", processConfig=" + this.processConfig + ", processEnv=" + this.processEnv + ", arguments=" + this.arguments + ", processOutput=" + this.processOutput + ", supportConfig=" + this.supportConfig + ", transitionLabel=" + this.transitionLabel + ", destination=" + this.destination + ", runningProcessFactory=" + this.runningProcessFactory + "}";
    }

    public static <T extends RunningProcess> ImmutableStarter<T> copyOf(Starter<T> instance) {
        if (instance instanceof ImmutableStarter) {
            return (ImmutableStarter)instance;
        }
        return ImmutableStarter.builder().from(instance).build();
    }

    public static <T extends RunningProcess> Builder<T> builder(RunningProcessFactory<T> runningProcessFactory) {
        return new Builder(runningProcessFactory);
    }

    static <T extends RunningProcess> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="Starter", generator="Immutables")
    public static final class Builder<T extends RunningProcess> {
        private static final long INIT_BIT_DESTINATION = 1L;
        private static final long INIT_BIT_RUNNING_PROCESS_FACTORY = 2L;
        private long initBits = 3L;
        private StateID<ExtractedFileSet> processExecutable;
        private StateID<ProcessWorkingDir> processWorkingDir;
        private StateID<ProcessConfig> processConfig;
        private StateID<ProcessEnv> processEnv;
        private StateID<ProcessArguments> arguments;
        private StateID<ProcessOutput> processOutput;
        private StateID<SupportConfig> supportConfig;
        private String transitionLabel;
        private StateID<T> destination;
        private RunningProcessFactory<T> runningProcessFactory;

        private Builder(RunningProcessFactory<T> runningProcessFactory) {
            this.runningProcessFactory(runningProcessFactory);
        }

        private Builder() {
        }

        public final Builder<T> from(Starter<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<T> from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Starter instance;
            long bits = 0L;
            if (object instanceof Starter) {
                instance = (Starter)object;
                this.supportConfig(instance.supportConfig());
                this.processExecutable(instance.processExecutable());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
                this.runningProcessFactory(instance.runningProcessFactory());
                this.processConfig(instance.processConfig());
                this.processEnv(instance.processEnv());
                this.processOutput(instance.processOutput());
                this.destination(instance.destination());
                this.arguments(instance.arguments());
                this.processWorkingDir(instance.processWorkingDir());
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder<T> processExecutable(StateID<ExtractedFileSet> processExecutable) {
            this.processExecutable = Objects.requireNonNull(processExecutable, "processExecutable");
            return this;
        }

        public final Builder<T> processWorkingDir(StateID<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = Objects.requireNonNull(processWorkingDir, "processWorkingDir");
            return this;
        }

        public final Builder<T> processConfig(StateID<ProcessConfig> processConfig) {
            this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
            return this;
        }

        public final Builder<T> processEnv(StateID<ProcessEnv> processEnv) {
            this.processEnv = Objects.requireNonNull(processEnv, "processEnv");
            return this;
        }

        public final Builder<T> arguments(StateID<ProcessArguments> arguments) {
            this.arguments = Objects.requireNonNull(arguments, "arguments");
            return this;
        }

        public final Builder<T> processOutput(StateID<ProcessOutput> processOutput) {
            this.processOutput = Objects.requireNonNull(processOutput, "processOutput");
            return this;
        }

        public final Builder<T> supportConfig(StateID<SupportConfig> supportConfig) {
            this.supportConfig = Objects.requireNonNull(supportConfig, "supportConfig");
            return this;
        }

        public final Builder<T> transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public final Builder<T> destination(StateID<T> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        final Builder<T> runningProcessFactory(RunningProcessFactory<T> runningProcessFactory) {
            this.runningProcessFactory = Objects.requireNonNull(runningProcessFactory, "runningProcessFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStarter<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStarter(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("runningProcessFactory");
            }
            return "Cannot build Starter, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Starter", generator="Immutables")
    private final class InitShim {
        private byte processExecutableBuildStage = 0;
        private StateID<ExtractedFileSet> processExecutable;
        private byte processWorkingDirBuildStage = 0;
        private StateID<ProcessWorkingDir> processWorkingDir;
        private byte processConfigBuildStage = 0;
        private StateID<ProcessConfig> processConfig;
        private byte processEnvBuildStage = 0;
        private StateID<ProcessEnv> processEnv;
        private byte argumentsBuildStage = 0;
        private StateID<ProcessArguments> arguments;
        private byte processOutputBuildStage = 0;
        private StateID<ProcessOutput> processOutput;
        private byte supportConfigBuildStage = 0;
        private StateID<SupportConfig> supportConfig;
        private byte transitionLabelBuildStage = 0;
        private String transitionLabel;

        private InitShim() {
        }

        StateID<ExtractedFileSet> processExecutable() {
            if (this.processExecutableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processExecutableBuildStage == 0) {
                this.processExecutableBuildStage = (byte)-1;
                this.processExecutable = Objects.requireNonNull(ImmutableStarter.super.processExecutable(), "processExecutable");
                this.processExecutableBuildStage = 1;
            }
            return this.processExecutable;
        }

        void processExecutable(StateID<ExtractedFileSet> processExecutable) {
            this.processExecutable = processExecutable;
            this.processExecutableBuildStage = 1;
        }

        StateID<ProcessWorkingDir> processWorkingDir() {
            if (this.processWorkingDirBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processWorkingDirBuildStage == 0) {
                this.processWorkingDirBuildStage = (byte)-1;
                this.processWorkingDir = Objects.requireNonNull(ImmutableStarter.super.processWorkingDir(), "processWorkingDir");
                this.processWorkingDirBuildStage = 1;
            }
            return this.processWorkingDir;
        }

        void processWorkingDir(StateID<ProcessWorkingDir> processWorkingDir) {
            this.processWorkingDir = processWorkingDir;
            this.processWorkingDirBuildStage = 1;
        }

        StateID<ProcessConfig> processConfig() {
            if (this.processConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processConfigBuildStage == 0) {
                this.processConfigBuildStage = (byte)-1;
                this.processConfig = Objects.requireNonNull(ImmutableStarter.super.processConfig(), "processConfig");
                this.processConfigBuildStage = 1;
            }
            return this.processConfig;
        }

        void processConfig(StateID<ProcessConfig> processConfig) {
            this.processConfig = processConfig;
            this.processConfigBuildStage = 1;
        }

        StateID<ProcessEnv> processEnv() {
            if (this.processEnvBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processEnvBuildStage == 0) {
                this.processEnvBuildStage = (byte)-1;
                this.processEnv = Objects.requireNonNull(ImmutableStarter.super.processEnv(), "processEnv");
                this.processEnvBuildStage = 1;
            }
            return this.processEnv;
        }

        void processEnv(StateID<ProcessEnv> processEnv) {
            this.processEnv = processEnv;
            this.processEnvBuildStage = 1;
        }

        StateID<ProcessArguments> arguments() {
            if (this.argumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.argumentsBuildStage == 0) {
                this.argumentsBuildStage = (byte)-1;
                this.arguments = Objects.requireNonNull(ImmutableStarter.super.arguments(), "arguments");
                this.argumentsBuildStage = 1;
            }
            return this.arguments;
        }

        void arguments(StateID<ProcessArguments> arguments) {
            this.arguments = arguments;
            this.argumentsBuildStage = 1;
        }

        StateID<ProcessOutput> processOutput() {
            if (this.processOutputBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.processOutputBuildStage == 0) {
                this.processOutputBuildStage = (byte)-1;
                this.processOutput = Objects.requireNonNull(ImmutableStarter.super.processOutput(), "processOutput");
                this.processOutputBuildStage = 1;
            }
            return this.processOutput;
        }

        void processOutput(StateID<ProcessOutput> processOutput) {
            this.processOutput = processOutput;
            this.processOutputBuildStage = 1;
        }

        StateID<SupportConfig> supportConfig() {
            if (this.supportConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportConfigBuildStage == 0) {
                this.supportConfigBuildStage = (byte)-1;
                this.supportConfig = Objects.requireNonNull(ImmutableStarter.super.supportConfig(), "supportConfig");
                this.supportConfigBuildStage = 1;
            }
            return this.supportConfig;
        }

        void supportConfig(StateID<SupportConfig> supportConfig) {
            this.supportConfig = supportConfig;
            this.supportConfigBuildStage = 1;
        }

        String transitionLabel() {
            if (this.transitionLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transitionLabelBuildStage == 0) {
                this.transitionLabelBuildStage = (byte)-1;
                this.transitionLabel = Objects.requireNonNull(ImmutableStarter.super.transitionLabel(), "transitionLabel");
                this.transitionLabelBuildStage = 1;
            }
            return this.transitionLabel;
        }

        void transitionLabel(String transitionLabel) {
            this.transitionLabel = transitionLabel;
            this.transitionLabelBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.processExecutableBuildStage == -1) {
                attributes.add("processExecutable");
            }
            if (this.processWorkingDirBuildStage == -1) {
                attributes.add("processWorkingDir");
            }
            if (this.processConfigBuildStage == -1) {
                attributes.add("processConfig");
            }
            if (this.processEnvBuildStage == -1) {
                attributes.add("processEnv");
            }
            if (this.argumentsBuildStage == -1) {
                attributes.add("arguments");
            }
            if (this.processOutputBuildStage == -1) {
                attributes.add("processOutput");
            }
            if (this.supportConfigBuildStage == -1) {
                attributes.add("supportConfig");
            }
            if (this.transitionLabelBuildStage == -1) {
                attributes.add("transitionLabel");
            }
            return "Cannot build Starter, attribute initializers form cycle " + attributes;
        }
    }
}

