/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.transitions;

import de.flapdoodle.embed.process.config.DownloadConfig;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.TempDir;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.net.DownloadToPath;
import de.flapdoodle.embed.process.net.ProxyFactory;
import de.flapdoodle.embed.process.net.UrlStreams;
import de.flapdoodle.embed.process.store.DownloadCache;
import de.flapdoodle.embed.process.transitions.ImmutableDownloadPackage;
import de.flapdoodle.embed.process.types.Archive;
import de.flapdoodle.embed.process.types.Name;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.naming.HasLabel;
import de.flapdoodle.types.Try;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.immutables.value.Value;

@Value.Immutable
public abstract class DownloadPackage
implements Transition<Archive>,
HasLabel {
    @Value.Default
    public String transitionLabel() {
        return "DownloadPackage";
    }

    @Value.Default
    protected StateID<Name> name() {
        return StateID.of(Name.class);
    }

    @Value.Default
    protected StateID<DownloadCache> downloadCache() {
        return StateID.of(DownloadCache.class);
    }

    @Value.Default
    protected StateID<ProgressListener> progressListener() {
        return StateID.of(ProgressListener.class);
    }

    @Value.Default
    protected DownloadConfig downloadConfig() {
        return DownloadConfig.defaults();
    }

    @Value.Default
    protected StateID<Distribution> distribution() {
        return StateID.of(Distribution.class);
    }

    @Value.Default
    protected StateID<Package> distPackage() {
        return StateID.of(Package.class);
    }

    @Value.Default
    protected StateID<TempDir> tempDirectory() {
        return StateID.of(TempDir.class);
    }

    @Value.Default
    public StateID<Archive> destination() {
        return StateID.of(Archive.class);
    }

    @Value.Default
    public DownloadToPath downloadToPath() {
        return UrlStreams.asDownloadToPath();
    }

    @Value.Auxiliary
    public final Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.distribution(), this.distPackage(), this.name(), this.tempDirectory(), this.downloadCache(), this.progressListener()});
    }

    @Value.Auxiliary
    public State<Archive> result(StateLookup lookup) {
        Distribution dist = (Distribution)lookup.of(this.distribution());
        Package distPackage = (Package)lookup.of(this.distPackage());
        DownloadCache downloadCache = (DownloadCache)lookup.of(this.downloadCache());
        ProgressListener progressListener = (ProgressListener)lookup.of(this.progressListener());
        Name name = (Name)lookup.of(this.name());
        TempDir temp = (TempDir)lookup.of(this.tempDirectory());
        URL downloadUrl = (URL)Try.supplier(() -> new URL(distPackage.url())).mapToUncheckedException(RuntimeException::new).get();
        Optional<Path> archive = downloadCache.archiveFor(downloadUrl, distPackage.archiveType());
        if (archive.isPresent()) {
            return State.of((Object)archive.map(Archive::of).get(), (TearDown[])new TearDown[0]);
        }
        Path downloadedArchive = ((Path)Try.supplier(() -> temp.createDirectory(name.value(), new FileAttribute[0])).mapToUncheckedException(cause -> new IllegalStateException("could not create archive path", (Throwable)cause)).get()).resolve(UUID.randomUUID().toString());
        Try.runable(() -> this.downloadToPath().download(downloadUrl, downloadedArchive, this.downloadConfig().proxyFactory().map(ProxyFactory::createProxy), this.downloadConfig().getUserAgent(), this.downloadConfig().getTimeoutConfig(), DownloadToPath.downloadCopyListenerDelegatingTo(progressListener))).mapToUncheckedException(cause -> new IllegalStateException("could not download " + distPackage.url(), (Throwable)cause)).run();
        Path storedArchive = (Path)Try.supplier(() -> downloadCache.store(downloadUrl, distPackage.archiveType(), downloadedArchive)).mapToUncheckedException(cause -> new IllegalArgumentException("could not store downloaded artifact", (Throwable)cause)).get();
        return State.of((Object)Archive.of(storedArchive), (TearDown[])new TearDown[]{it -> Try.run(() -> Files.delete(downloadedArchive))});
    }

    public static ImmutableDownloadPackage.Builder builder() {
        return ImmutableDownloadPackage.builder();
    }

    public static ImmutableDownloadPackage withDefaults() {
        return DownloadPackage.builder().build();
    }
}

