/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutablePackage
implements Package {
    private final ArchiveType archiveType;
    private final FileSet fileSet;
    private final String url;

    private ImmutablePackage(ArchiveType archiveType, FileSet fileSet, String url) {
        this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
        this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
        this.url = Objects.requireNonNull(url, "url");
    }

    private ImmutablePackage(ImmutablePackage original, ArchiveType archiveType, FileSet fileSet, String url) {
        this.archiveType = archiveType;
        this.fileSet = fileSet;
        this.url = url;
    }

    @Override
    public ArchiveType archiveType() {
        return this.archiveType;
    }

    @Override
    public FileSet fileSet() {
        return this.fileSet;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutablePackage withArchiveType(ArchiveType value) {
        ArchiveType newValue = Objects.requireNonNull(value, "archiveType");
        if (this.archiveType == newValue) {
            return this;
        }
        return new ImmutablePackage(this, newValue, this.fileSet, this.url);
    }

    public final ImmutablePackage withFileSet(FileSet value) {
        if (this.fileSet == value) {
            return this;
        }
        FileSet newValue = Objects.requireNonNull(value, "fileSet");
        return new ImmutablePackage(this, this.archiveType, newValue, this.url);
    }

    public final ImmutablePackage withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePackage(this, this.archiveType, this.fileSet, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePackage && this.equalTo(0, (ImmutablePackage)another);
    }

    private boolean equalTo(int synthetic, ImmutablePackage another) {
        return this.archiveType.equals((Object)another.archiveType) && this.fileSet.equals(another.fileSet) && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.archiveType.hashCode();
        h += (h << 5) + this.fileSet.hashCode();
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "Package{archiveType=" + (Object)((Object)this.archiveType) + ", fileSet=" + this.fileSet + ", url=" + this.url + "}";
    }

    public static ImmutablePackage of(ArchiveType archiveType, FileSet fileSet, String url) {
        return new ImmutablePackage(archiveType, fileSet, url);
    }

    public static ImmutablePackage copyOf(Package instance) {
        if (instance instanceof ImmutablePackage) {
            return (ImmutablePackage)instance;
        }
        return ImmutablePackage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ARCHIVE_TYPE = 1L;
        private static final long INIT_BIT_FILE_SET = 2L;
        private static final long INIT_BIT_URL = 4L;
        private long initBits = 7L;
        private ArchiveType archiveType;
        private FileSet fileSet;
        private String url;

        private Builder() {
        }

        public final Builder from(Package instance) {
            Objects.requireNonNull(instance, "instance");
            this.archiveType(instance.archiveType());
            this.fileSet(instance.fileSet());
            this.url(instance.url());
            return this;
        }

        public final Builder archiveType(ArchiveType archiveType) {
            this.archiveType = Objects.requireNonNull(archiveType, "archiveType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fileSet(FileSet fileSet) {
            this.fileSet = Objects.requireNonNull(fileSet, "fileSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePackage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePackage(null, this.archiveType, this.fileSet, this.url);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("archiveType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileSet");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build Package, some of required attributes are not set " + attributes;
        }
    }
}

