/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.Legacy;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableEntry;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.config.store.UncompiledPattern;
import java.util.List;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@Legacy
public interface FileSet {
    public List<Entry> entries();

    @Value.Check
    default public void shouldContainOneMoreExecutable() {
        boolean oneOrMoreExecutableFound = this.entries().stream().anyMatch(e -> e.type() == FileType.Executable);
        if (!oneOrMoreExecutableFound) {
            throw new IllegalArgumentException("there is no executable in this file set");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableFileSet.Builder {
        public Builder addEntry(FileType type, String filename) {
            return this.addEntry(type, filename, ".*" + filename);
        }

        public Builder addEntry(FileType type, String filename, String pattern) {
            return this.addEntry(type, filename, Pattern.compile(pattern, 2));
        }

        public Builder addEntry(FileType type, String filename, Pattern pattern) {
            return this.addEntries(Entry.of(type, filename, pattern));
        }
    }

    @Value.Immutable
    public static abstract class Entry {
        @Value.Parameter
        public abstract FileType type();

        @Value.Parameter
        public abstract String destination();

        @Value.Parameter
        protected abstract UncompiledPattern uncompiledMatchingPattern();

        @Value.Auxiliary
        public Pattern matchingPattern() {
            return this.uncompiledMatchingPattern().compile();
        }

        static Entry of(FileType type, String filename, Pattern pattern) {
            return ImmutableEntry.of(type, filename, UncompiledPattern.of(pattern));
        }
    }
}

