package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Edge}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEdge.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdge.of()}.
 */
@Generated(from = "Edge", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEdge<V, E> implements Edge<V, E> {
  private final V start;
  private final V end;
  private final E edge;

  private ImmutableEdge(V start, V end, E edge) {
    this.start = Objects.requireNonNull(start, "start");
    this.end = Objects.requireNonNull(end, "end");
    this.edge = Objects.requireNonNull(edge, "edge");
  }

  private ImmutableEdge(ImmutableEdge<V, E> original, V start, V end, E edge) {
    this.start = start;
    this.end = end;
    this.edge = edge;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public V start() {
    return start;
  }

  /**
   * @return The value of the {@code end} attribute
   */
  @Override
  public V end() {
    return end;
  }

  /**
   * @return The value of the {@code edge} attribute
   */
  @Override
  public E edge() {
    return edge;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Edge#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdge<V, E> withStart(V value) {
    if (this.start == value) return this;
    V newValue = Objects.requireNonNull(value, "start");
    return new ImmutableEdge<>(this, newValue, this.end, this.edge);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Edge#end() end} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for end
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdge<V, E> withEnd(V value) {
    if (this.end == value) return this;
    V newValue = Objects.requireNonNull(value, "end");
    return new ImmutableEdge<>(this, this.start, newValue, this.edge);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Edge#edge() edge} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for edge
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdge<V, E> withEdge(E value) {
    if (this.edge == value) return this;
    E newValue = Objects.requireNonNull(value, "edge");
    return new ImmutableEdge<>(this, this.start, this.end, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdge} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdge<?, ?>
        && equalTo((ImmutableEdge<?, ?>) another);
  }

  private boolean equalTo(ImmutableEdge<?, ?> another) {
    return start.equals(another.start)
        && end.equals(another.end)
        && edge.equals(another.edge);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code end}, {@code edge}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + end.hashCode();
    h += (h << 5) + edge.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Edge} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Edge{"
        + "start=" + start
        + ", end=" + end
        + ", edge=" + edge
        + "}";
  }

  /**
   * Construct a new immutable {@code Edge} instance.
 * @param <V> generic parameter V
 * @param <E> generic parameter E
   * @param start The value for the {@code start} attribute
   * @param end The value for the {@code end} attribute
   * @param edge The value for the {@code edge} attribute
   * @return An immutable Edge instance
   */
  public static <V, E> ImmutableEdge<V, E> of(V start, V end, E edge) {
    return new ImmutableEdge<>(start, end, edge);
  }

  /**
   * Creates an immutable copy of a {@link Edge} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @param instance The instance to copy
   * @return A copied immutable Edge instance
   */
  public static <V, E> ImmutableEdge<V, E> copyOf(Edge<V, E> instance) {
    if (instance instanceof ImmutableEdge<?, ?>) {
      return (ImmutableEdge<V, E>) instance;
    }
    return ImmutableEdge.<V, E>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEdge ImmutableEdge}.
   * <pre>
   * ImmutableEdge.&amp;lt;V, E&amp;gt;builder()
   *    .start(V) // required {@link Edge#start() start}
   *    .end(V) // required {@link Edge#end() end}
   *    .edge(E) // required {@link Edge#edge() edge}
   *    .build();
   * </pre>
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @return A new ImmutableEdge builder
   */
  public static <V, E> ImmutableEdge.Builder<V, E> builder() {
    return new ImmutableEdge.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableEdge ImmutableEdge}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Edge", generator = "Immutables")
  public static final class Builder<V, E> {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_END = 0x2L;
    private static final long INIT_BIT_EDGE = 0x4L;
    private long initBits = 0x7L;

    private V start;
    private V end;
    private E edge;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Edge} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> from(Edge<V, E> instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      end(instance.end());
      edge(instance.edge());
      return this;
    }

    /**
     * Initializes the value for the {@link Edge#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> start(V start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link Edge#end() end} attribute.
     * @param end The value for end 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> end(V end) {
      this.end = Objects.requireNonNull(end, "end");
      initBits &= ~INIT_BIT_END;
      return this;
    }

    /**
     * Initializes the value for the {@link Edge#edge() edge} attribute.
     * @param edge The value for edge 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> edge(E edge) {
      this.edge = Objects.requireNonNull(edge, "edge");
      initBits &= ~INIT_BIT_EDGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEdge ImmutableEdge}.
     * @return An immutable instance of Edge
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdge<V, E> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEdge<>(null, start, end, edge);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_END) != 0) attributes.add("end");
      if ((initBits & INIT_BIT_EDGE) != 0) attributes.add("edge");
      return "Cannot build Edge, some of required attributes are not set " + attributes;
    }
  }
}
