/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ThrowingConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    default public <N extends Exception> ThrowingConsumer<T, N> mapException(Function<Exception, N> exceptionMapper) {
        return value -> {
            try {
                this.accept(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public Consumer<T> mapToUncheckedException(Function<Exception, RuntimeException> exceptionMapper) {
        return this.mapException(exceptionMapper)::accept;
    }

    default public ThrowingConsumer<T, E> andFinally(Runnable runnable) {
        return value -> {
            try {
                this.accept(value);
            }
            finally {
                runnable.run();
            }
        };
    }

    default public Consumer<T> onCheckedException(BiConsumer<Exception, T> exceptionToFallback) {
        return value -> {
            try {
                this.accept(value);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                exceptionToFallback.accept(e, value);
            }
        };
    }
}

