/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reflection;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.reflection.ImmutableMapTypeInfo;
import de.flapdoodle.reflection.TypeInfo;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MapTypeInfo<K, V>
implements TypeInfo<Map<K, V>> {
    @Value.Parameter
    public abstract TypeInfo<K> key();

    @Value.Parameter
    public abstract TypeInfo<V> value();

    @Override
    public Map<K, V> cast(Object instance) {
        Preconditions.checkArgument(this.isInstance(instance), "type mismatch: %s is not a %s", instance, this);
        return (Map)instance;
    }

    @Override
    public boolean isInstance(Object instance) {
        return instance instanceof Map && ((Map)instance).entrySet().stream().allMatch(entry -> this.key().isInstance(entry.getKey()) && this.value().isInstance(entry.getValue()));
    }

    static <K, V> MapTypeInfo<K, V> of(TypeInfo<K> key, TypeInfo<V> value) {
        return ImmutableMapTypeInfo.of(key, value);
    }
}

