/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.ImmutablePair;
import de.flapdoodle.types.ImmutablePairTypeInfo;
import java.util.function.Function;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Pair<FIRST, SECOND> {
    @Value.Parameter
    public abstract FIRST first();

    @Value.Parameter
    public abstract SECOND second();

    public <T> Pair<T, SECOND> mapFirst(Function<FIRST, T> transformation) {
        return Pair.of(transformation.apply(this.first()), this.second());
    }

    public <T> Pair<FIRST, T> mapSecond(Function<SECOND, T> transformation) {
        return Pair.of(this.first(), transformation.apply(this.second()));
    }

    public <FIRST_MAPPED, SECOND_MAPPED> Pair<FIRST_MAPPED, SECOND_MAPPED> map(Function<FIRST, FIRST_MAPPED> first, Function<SECOND, SECOND_MAPPED> second) {
        return this.mapFirst(first).mapSecond(second);
    }

    public static <FIRST, SECOND> Pair<FIRST, SECOND> of(FIRST first, SECOND second) {
        return ImmutablePair.of(first, second);
    }

    public static <FIRST, SECOND> TypeInfo<Pair<FIRST, SECOND>> typeInfo(TypeInfo<FIRST> first, TypeInfo<SECOND> second) {
        return ImmutablePairTypeInfo.of(first, second);
    }

    public static <FIRST, SECOND> TypeInfo<Pair<FIRST, SECOND>> typeInfo(Class<FIRST> first, Class<SECOND> second) {
        return Pair.typeInfo(TypeInfo.of(first), TypeInfo.of(second));
    }

    @Value.Immutable
    public static abstract class PairTypeInfo<FIRST, SECOND>
    implements TypeInfo<Pair<FIRST, SECOND>> {
        @Value.Parameter
        public abstract TypeInfo<FIRST> first();

        @Value.Parameter
        public abstract TypeInfo<SECOND> second();

        @Override
        public boolean isInstance(Object instance) {
            return instance instanceof Pair && this.first().isInstance(((Pair)instance).first()) && this.second().isInstance(((Pair)instance).second());
        }

        @Override
        public Pair<FIRST, SECOND> cast(Object instance) {
            Preconditions.checkArgument(this.isInstance(instance), "type mismatch: %s is not a %s", instance, this);
            return (Pair)instance;
        }
    }
}

