/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ThrowableInfoParser {
    private static final String NEWLINE = "\n";
    private static final String CARRIAGE_RETURN = "\r";
    private static final String CLASS_MESSAGE_SEPARATOR = ": ";
    private static final Pattern OMITTED_PATTERN = Pattern.compile("^(\t+)\\.\\.\\. (\\d+) more");
    private static final Pattern AT_PATTERN = Pattern.compile("^(\t+)at (.+)");
    private static final Pattern MESSAGE_MATCHER = Pattern.compile("^(\t*)?(Caused by: |Suppressed: )?(.*)");

    private ThrowableInfoParser() {
    }

    public static ThrowableInfo parse(String throwableInfoString) {
        if (throwableInfoString == null) {
            return null;
        }
        return ThrowableInfoParser.parse(ThrowableInfoParser.splitLines(throwableInfoString));
    }

    public static ThrowableInfo parse(List<String> throwableInfoLines) {
        if (throwableInfoLines == null) {
            return null;
        }
        if (throwableInfoLines.isEmpty()) {
            return null;
        }
        return ThrowableInfoParser.parse(throwableInfoLines, (int)0, (int)0).throwableInfo;
    }

    private static ThrowableInfoParseResult parse(List<String> throwableInfoLines, int startIndex, int indent) {
        int index;
        int lineCount = throwableInfoLines.size();
        String name = null;
        StringBuilder message = null;
        ArrayList<ExtendedStackTraceElement> stackTraceElements = null;
        int omittedElements = 0;
        ThrowableInfo cause = null;
        ArrayList<ThrowableInfo> suppressedInfos = null;
        for (index = startIndex; index < lineCount; ++index) {
            String currentLine = throwableInfoLines.get(index);
            Matcher atMatcher = ThrowableInfoParser.atMatcher(currentLine);
            if (atMatcher.matches()) {
                String indentString = atMatcher.group(1);
                if (indentString.length() != indent + 1) break;
                String steString = atMatcher.group(2);
                ExtendedStackTraceElement este = ExtendedStackTraceElement.parseStackTraceElement(steString);
                if (este == null) continue;
                if (stackTraceElements == null) {
                    stackTraceElements = new ArrayList<ExtendedStackTraceElement>();
                }
                stackTraceElements.add(este);
                continue;
            }
            Matcher omittedMatcher = ThrowableInfoParser.omittedMatcher(currentLine);
            if (omittedMatcher.matches()) {
                String indentString = omittedMatcher.group(1);
                if (indentString.length() != indent + 1) break;
                omittedElements = Integer.parseInt(omittedMatcher.group(2));
                continue;
            }
            Matcher messageMatcher = ThrowableInfoParser.messageMatcher(currentLine);
            if (messageMatcher.matches()) {
                String indentString = messageMatcher.group(1);
                String type = messageMatcher.group(2);
                String remainder = messageMatcher.group(3);
                if ("Caused by: ".equals(type)) {
                    if (index != startIndex) {
                        if (indentString.length() != indent) break;
                        ThrowableInfoParseResult parsed = ThrowableInfoParser.parse(throwableInfoLines, index, indent);
                        index = parsed.endIndex - 1;
                        if (parsed.throwableInfo == null) continue;
                        cause = parsed.throwableInfo;
                        continue;
                    }
                } else if ("Suppressed: ".equals(type) && index != startIndex) {
                    if (indentString.length() != indent + 1) break;
                    ThrowableInfoParseResult parsed = ThrowableInfoParser.parse(throwableInfoLines, index, indent + 1);
                    index = parsed.endIndex - 1;
                    if (parsed.throwableInfo == null) continue;
                    if (suppressedInfos == null) {
                        suppressedInfos = new ArrayList<ThrowableInfo>();
                    }
                    suppressedInfos.add(parsed.throwableInfo);
                    continue;
                }
                if (message == null) {
                    int colonIndex = remainder.indexOf(CLASS_MESSAGE_SEPARATOR);
                    if (colonIndex > -1) {
                        name = remainder.substring(0, colonIndex);
                        message = new StringBuilder();
                        message.append(remainder.substring(colonIndex + CLASS_MESSAGE_SEPARATOR.length()));
                        continue;
                    }
                    name = remainder;
                    continue;
                }
                message.append(NEWLINE);
                if (indentString != null) {
                    message.append(indentString);
                }
                message.append(remainder);
                continue;
            }
            System.err.println("What? " + currentLine);
        }
        ThrowableInfo throwableInfo = null;
        if (name != null || message != null || stackTraceElements != null || omittedElements != 0 || cause != null || suppressedInfos != null) {
            throwableInfo = new ThrowableInfo();
            throwableInfo.setName(name);
            if (message != null) {
                throwableInfo.setMessage(message.toString());
            }
            if (stackTraceElements != null) {
                throwableInfo.setStackTrace(stackTraceElements.toArray(ExtendedStackTraceElement.ARRAY_PROTOTYPE));
            }
            throwableInfo.setOmittedElements(omittedElements);
            throwableInfo.setCause(cause);
            if (suppressedInfos != null) {
                throwableInfo.setSuppressed(suppressedInfos.toArray(ThrowableInfo.ARRAY_PROTOTYPE));
            }
        }
        return new ThrowableInfoParseResult(throwableInfo, index);
    }

    static List<String> splitLines(String input) {
        if (input == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(input, "\n\r", true);
        ArrayList<String> lines = new ArrayList<String>();
        boolean foundAnything = false;
        boolean hadContent = false;
        while (tok.hasMoreTokens()) {
            foundAnything = true;
            String current = tok.nextToken();
            if (NEWLINE.equals(current)) {
                if (hadContent) {
                    hadContent = false;
                    continue;
                }
                lines.add("");
                continue;
            }
            if (CARRIAGE_RETURN.equals(current)) continue;
            lines.add(current);
            hadContent = true;
        }
        if (!foundAnything) {
            lines.add("");
        }
        return lines;
    }

    static Matcher omittedMatcher(String input) {
        return OMITTED_PATTERN.matcher(input);
    }

    static Matcher atMatcher(String input) {
        return AT_PATTERN.matcher(input);
    }

    static Matcher messageMatcher(String input) {
        return MESSAGE_MATCHER.matcher(input);
    }

    static {
        new ThrowableInfoParser();
    }

    private static class ThrowableInfoParseResult {
        ThrowableInfo throwableInfo;
        int endIndex;

        ThrowableInfoParseResult(ThrowableInfo throwableInfo, int endIndex) {
            this.throwableInfo = throwableInfo;
            this.endIndex = endIndex;
        }
    }
}

