/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Codec;
import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.codec.Encoder;

public class DelegatingCodecBase<E>
implements Codec<E> {
    private Encoder<E> encoder;
    private Decoder<E> decoder;

    protected DelegatingCodecBase() {
        this(null, null);
    }

    protected DelegatingCodecBase(Encoder<E> encoder, Decoder<E> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    protected Encoder<E> getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    protected Decoder<E> getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(Decoder<E> decoder) {
        this.decoder = decoder;
    }

    @Override
    public byte[] encode(E object) {
        if (this.encoder == null) {
            throw new IllegalStateException("encoder must not be null!");
        }
        return this.encoder.encode(object);
    }

    @Override
    public E decode(byte[] bytes) {
        if (this.decoder == null) {
            throw new IllegalStateException("decoder must not be null!");
        }
        return this.decoder.decode(bytes);
    }
}

