/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;

public class SerializableEncoder<E extends Serializable>
implements Encoder<E> {
    private boolean compressing;

    public SerializableEncoder() {
        this(false);
    }

    public SerializableEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encode(E object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = this.createObjectOutputStream(bos);){
            oos.writeObject(object);
            oos.flush();
            oos.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ObjectOutputStream createObjectOutputStream(ByteArrayOutputStream bos) throws IOException {
        if (this.compressing) {
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            return new ObjectOutputStream(gos);
        }
        return new ObjectOutputStream(bos);
    }

    public String toString() {
        return "SerializableEncoder[compressing=" + this.compressing + "]";
    }
}

