/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.streaming;

import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.codec.streaming.StreamingDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderBridge<E>
implements Decoder<E> {
    private final Logger logger = LoggerFactory.getLogger(DecoderBridge.class);
    private final StreamingDecoder<E> wrapped;

    public DecoderBridge(StreamingDecoder<E> wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped must not be null!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E decode(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            E e = this.wrapped.decode(bis);
            return e;
        }
        catch (IOException e2) {
            if (!this.logger.isWarnEnabled()) return null;
            this.logger.warn("Couldn't decode!", (Throwable)e2);
            return null;
        }
    }
}

