/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.streaming;

import de.huxhorn.sulky.codec.Encoder;
import de.huxhorn.sulky.codec.streaming.StreamingEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderBridge<E>
implements Encoder<E> {
    private final Logger logger = LoggerFactory.getLogger(EncoderBridge.class);
    private final StreamingEncoder<E> wrapped;

    public EncoderBridge(StreamingEncoder<E> wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped must not be null!");
    }

    @Override
    public byte[] encode(E object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.wrapped.encode(object, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while encoding {}!", object, (Object)e);
            }
            return null;
        }
    }
}

