/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTCPEnumSetSerializer
extends FSTBasicObjectSerializer {
    Field elemType;

    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        EnumSet enset = (EnumSet)toWrite;
        int count = 0;
        out.writeInt(enset.size());
        if (enset.isEmpty()) {
            EnumSet compl = EnumSet.complementOf(enset);
            out.writeClassTag(compl.iterator().next().getClass());
        } else {
            for (Object element : enset) {
                if (count == 0) {
                    out.writeStringUTF(element.getClass().getName());
                }
                out.writeStringUTF(element.toString());
                ++count;
            }
        }
    }

    @Override
    public boolean alwaysCopy() {
        return false;
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int len = in.readInt();
        Class elemCl = in.getClassForName(in.readStringUTF());
        EnumSet enSet = EnumSet.noneOf(elemCl);
        in.registerObject(enSet, streamPositioin, serializationInfo, referencee);
        for (int i = 0; i < len; ++i) {
            String val = in.readStringUTF();
            enSet.add(Enum.valueOf(elemCl, val));
        }
        return enSet;
    }
}

