/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CommandHandle;
import de.tototec.cmdoption.I18n;
import de.tototec.cmdoption.I18nFactory;
import de.tototec.cmdoption.OptionHandle;
import de.tototec.cmdoption.UsageFormatter;
import de.tototec.cmdoption.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUsageFormatter
implements UsageFormatter {
    private final I18n i18n = I18nFactory.getI18n(DefaultUsageFormatter.class);
    private final boolean withCommandDetails;
    private int lineLength = 80;
    private int colSpace = 2;
    private int col1Prefix = 2;

    public DefaultUsageFormatter(boolean withCommandDetails) {
        this.withCommandDetails = withCommandDetails;
    }

    protected String translate(ResourceBundle resourceBundle, String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public void format(StringBuilder output, CmdlineModel cmdlineModel) {
        ArrayList<OptionHandle> sortedOptions = new ArrayList<OptionHandle>(cmdlineModel.getOptions());
        Iterator<OptionHandle> it = sortedOptions.iterator();
        while (it.hasNext()) {
            if (!it.next().isHidden()) continue;
            it.remove();
        }
        Collections.sort(sortedOptions, new OptionHandle.OptionHandleComparator());
        ArrayList<CommandHandle> sortedCommands = new ArrayList<CommandHandle>(cmdlineModel.getCommands());
        Iterator<CommandHandle> it2 = sortedCommands.iterator();
        while (it2.hasNext()) {
            if (!it2.next().isHidden()) continue;
            it2.remove();
        }
        Collections.sort(sortedCommands, new CommandHandle.CommandHandleComparator());
        if (cmdlineModel.getAboutLine() != null && cmdlineModel.getAboutLine().length() > 0) {
            output.append(this.translate(cmdlineModel.getResourceBundle(), cmdlineModel.getAboutLine())).append("\n\n");
        }
        output.append(this.i18n.tr("Usage:", new Object[0])).append(" ");
        output.append(cmdlineModel.getProgramName() == null ? this.i18n.tr("program", new Object[0]) : cmdlineModel.getProgramName());
        if (!sortedOptions.isEmpty()) {
            output.append(" ").append(this.i18n.tr("[options]", new Object[0]));
        }
        if (cmdlineModel.getParameter() != null) {
            output.append(" ").append(this.i18n.tr("[parameter]", new Object[0]));
        }
        if (!sortedCommands.isEmpty()) {
            output.append(" ").append(this.i18n.tr("[command]", new Object[0]));
            boolean cmdsHaveOptions = false;
            boolean cmdsHaveParameter = false;
            for (CommandHandle cmd : sortedCommands) {
                cmdsHaveOptions |= !cmd.getCmdlineParser().getCmdlineModel().getOptions().isEmpty();
                cmdsHaveParameter |= cmd.getCmdlineParser().getCmdlineModel().getParameter() != null;
            }
            if (cmdsHaveOptions) {
                output.append(" ").append(this.i18n.tr("[command options]", new Object[0]));
            }
            if (cmdsHaveParameter) {
                output.append(" ").append(this.i18n.tr("[command parameters]", new Object[0]));
            }
        }
        output.append("\n");
        this.formatOptions(output, sortedOptions, "\n" + this.i18n.tr("Options:", new Object[0]), cmdlineModel.getResourceBundle());
        this.formatCommands(output, sortedCommands, "\n" + this.i18n.tr("Commands:", new Object[0]), cmdlineModel.getResourceBundle());
        if (this.withCommandDetails) {
            for (CommandHandle command : sortedCommands) {
                ArrayList<OptionHandle> commandOptions = new ArrayList<OptionHandle>(command.getCmdlineParser().getCmdlineModel().getOptions());
                Iterator<OptionHandle> it3 = commandOptions.iterator();
                while (it3.hasNext()) {
                    if (!it3.next().isHidden()) continue;
                    it3.remove();
                }
                Collections.sort(commandOptions, new OptionHandle.OptionHandleComparator());
                this.formatOptions(output, commandOptions, "\n" + this.i18n.tr("Options for command:", new Object[0]) + " " + Util.mkString(command.getNames(), null, ", ", null), cmdlineModel.getResourceBundle());
                this.formatParameter(output, command.getCmdlineParser().getCmdlineModel().getParameter(), "\n" + this.i18n.tr("Parameter for command:", new Object[0]) + " " + Util.mkString(command.getNames(), null, ", ", null), cmdlineModel.getResourceBundle());
            }
        }
        this.formatParameter(output, cmdlineModel.getParameter(), "\n" + this.i18n.tr("Parameter:", new Object[0]), cmdlineModel.getResourceBundle());
    }

    protected void formatParameter(StringBuilder output, OptionHandle parameter, String title, ResourceBundle resourceBundle) {
        if (parameter == null) {
            return;
        }
        output.append(title).append("\n");
        DefaultUsageFormatter.mkSpace(output, this.col1Prefix);
        output.append(Util.mkString(parameter.getArgs(), null, " ", null));
        if (parameter.getDescription() != null) {
            DefaultUsageFormatter.mkSpace(output, this.colSpace);
            output.append(this.translate(resourceBundle, parameter.getDescription()));
        }
        output.append("\n");
    }

    protected void formatOptions(StringBuilder output, List<OptionHandle> options, String title, ResourceBundle resourceBundle) {
        if (options == null || options.isEmpty()) {
            return;
        }
        LinkedList<String[]> optionsToFormat = new LinkedList<String[]>();
        boolean hasOptions = false;
        for (OptionHandle option : options) {
            if (option.isHidden()) continue;
            hasOptions = true;
            String optionNames = Util.mkString(option.getNames(), null, ",", null);
            String argNames = Util.mkString(option.getArgs(), null, " ", null);
            optionsToFormat.add(new String[]{optionNames + (argNames.length() == 0 ? "" : " " + argNames), this.translate(resourceBundle, option.getDescription())});
        }
        if (!hasOptions) {
            return;
        }
        if (title != null) {
            output.append(title).append("\n");
        }
        DefaultUsageFormatter.formatTable(output, optionsToFormat, this.col1Prefix, this.colSpace, this.lineLength);
    }

    protected void formatCommands(StringBuilder output, List<CommandHandle> commands, String title, ResourceBundle resourceBundle) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        if (title != null) {
            output.append(title).append("\n");
        }
        LinkedList<String[]> commandsToFormat = new LinkedList<String[]>();
        for (CommandHandle option : commands) {
            String commandNames = Util.mkString(option.getNames(), null, ",", null);
            commandsToFormat.add(new String[]{commandNames, this.translate(resourceBundle, option.getDescription())});
        }
        DefaultUsageFormatter.formatTable(output, commandsToFormat, this.col1Prefix, this.colSpace, this.lineLength);
    }

    public static void mkSpace(StringBuilder output, int space) {
        for (int i = 0; i < space; ++i) {
            output.append(" ");
        }
    }

    public static void formatTable(StringBuilder output, List<String[]> twoColData, int prefix, int space, int maxLineLength) {
        int firstColSize = 2;
        for (String[] col : twoColData) {
            if (col.length <= 0 || col[0] == null) continue;
            firstColSize = Math.max(firstColSize, col[0].length());
        }
        boolean secondColInNewLine = prefix + space + firstColSize + 10 > maxLineLength;
        for (String[] col : twoColData) {
            if (col.length > 0) {
                DefaultUsageFormatter.mkSpace(output, prefix);
                int cursor = prefix;
                if (col[0] != null) {
                    output.append(col[0]);
                    cursor += col[0].length();
                }
                if (secondColInNewLine) {
                    output.append("\n");
                } else {
                    DefaultUsageFormatter.mkSpace(output, prefix + firstColSize + space - cursor);
                }
                if (col[1] != null) {
                    if (secondColInNewLine) {
                        DefaultUsageFormatter.wrap(output, col[1], prefix + space, maxLineLength - prefix - space);
                    } else {
                        DefaultUsageFormatter.wrap(output, col[1], prefix + space + firstColSize, maxLineLength - prefix - space - firstColSize);
                    }
                }
            }
            output.append("\n");
        }
    }

    public static void wrap(StringBuilder output, String text, int nextLinePrefix, int lineLength) {
        if ((text = text.trim()).length() <= lineLength) {
            output.append(text);
        } else {
            int bestWrap = -1;
            bestWrap = " ".equals(text.substring(lineLength, lineLength + 1)) ? lineLength : text.substring(0, lineLength).lastIndexOf(" ");
            if (bestWrap == -1) {
                bestWrap = text.indexOf(" ");
            }
            if (bestWrap > 0) {
                output.append(text.substring(0, bestWrap)).append("\n");
                for (int i = 0; i < nextLinePrefix; ++i) {
                    output.append(" ");
                }
                DefaultUsageFormatter.wrap(output, text.substring(bestWrap), nextLinePrefix, lineLength);
            } else {
                output.append(text);
            }
        }
    }
}

