/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.row;

import de.vandermeer.asciitable.commons.ObjectToStringStyle;
import de.vandermeer.asciitable.commons.TableException;
import de.vandermeer.asciitable.v2.row.V2_Row;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ContentRow
implements V2_Row {
    private Object[] columns;
    private char[] alignment;
    private int[] padding;

    public ContentRow(Object[] columns, int padding) throws TableException {
        int i;
        if (columns == null) {
            throw new TableException("wrong columns argument", "empty column array");
        }
        this.columns = columns;
        this.alignment = new char[this.columns.length];
        for (i = 0; i < columns.length; ++i) {
            this.alignment[i] = 108;
        }
        this.padding = new int[this.columns.length];
        for (i = 0; i < columns.length; ++i) {
            this.padding[i] = padding;
        }
    }

    public boolean setAlignment(char[] alignment) {
        int i;
        if (alignment == null) {
            return false;
        }
        if (alignment.length != this.alignment.length) {
            return false;
        }
        for (i = 0; i < alignment.length; ++i) {
            if (alignment[i] == 'l' || alignment[i] == 'r' || alignment[i] == 'c' || alignment[i] == 'j' || alignment[i] == 't' || alignment[i] == ' ') continue;
            return false;
        }
        for (i = 0; i < alignment.length; ++i) {
            if (alignment[i] == ' ') continue;
            this.alignment[i] = alignment[i];
        }
        return true;
    }

    public boolean setPadding(int[] padding) {
        if (padding == null) {
            return false;
        }
        if (padding.length != this.padding.length) {
            return false;
        }
        for (int i = 0; i < padding.length; ++i) {
            if (padding[i] == -1) continue;
            this.padding[i] = padding[i];
        }
        return true;
    }

    public char[] getAlignment() {
        return this.alignment;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public Object[] getColumns() {
        return this.columns;
    }

    @Override
    public String toString(int indent) {
        ToStringBuilder ret = new ToStringBuilder((Object)this, ObjectToStringStyle.getStyle(indent));
        ret.append("row type       ", (Object)("content with " + this.columns.length + " column(s)"));
        ret.append("columns        ", this.columns, false);
        ret.append("columns        ", this.columns);
        return ret.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

