/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import com.diffplug.common.swt.os.OS;
import dev.equo.ide.Launcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

class ScriptExec {
    private final String script;
    private Optional<File> directory = Optional.empty();
    private Map<String, String> env = Map.of();
    private static final int EXIT_VALUE_SUCCESS = 0;

    public static ScriptExec script(String script) {
        return new ScriptExec(script);
    }

    private ScriptExec(String script) {
        this.script = Objects.requireNonNull(script);
    }

    public ScriptExec directory(File directory) {
        this.directory = Optional.of(directory);
        return this;
    }

    public ScriptExec environment(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public void execSeparate(@Nullable Consumer<Process> monitorProcess) throws IOException, InterruptedException {
        this.exec(true, monitorProcess);
    }

    public void execBlocking(@Nullable Consumer<Process> monitorProcess) throws IOException, InterruptedException {
        this.exec(false, monitorProcess);
    }

    private void exec(boolean isSeparate, @Nullable Consumer<Process> monitorProcess) throws IOException, InterruptedException {
        File scriptFile = ScriptExec.createSelfDeletingScript(this.script);
        List<String> fullArgs = ScriptExec.getPlatformCmds(scriptFile, isSeparate);
        int exitValue = Launcher.launchAndInheritIO(this.directory.orElse(null), fullArgs, this.env, monitorProcess);
        if (ScriptExec.mavenWorkarounds() && (OS.getNative().isLinux() && exitValue == 137 || OS.getNative().isWindows() && exitValue == 1)) {
            return;
        }
        if (exitValue != 0) {
            throw new RuntimeException("'" + this.script + "' exited with " + exitValue);
        }
    }

    private static boolean mavenWorkarounds() {
        return "true".equals(System.getProperty("equo-ide-maven-workarounds"));
    }

    private static File createSelfDeletingScript(String script) throws IOException {
        String extension = OS.getRunning().isWindows() ? ".bat" : ".sh";
        String header = OS.getRunning().isWindows() ? "" : "#!/bin/bash";
        String callRobust = OS.getRunning().isWindows() ? "call " : "";
        File targetScriptFile = ScriptExec.createGenericScript(extension, (file, printer) -> {
            printer.println(header);
            printer.println(script);
        });
        return ScriptExec.createGenericScript(extension, (file, printer) -> {
            printer.println(header);
            printer.println(callRobust + ScriptExec.quote(targetScriptFile));
            if (OS.getNative().isWindows()) {
                printer.println("start /b \"\" cmd /c del " + ScriptExec.quote(targetScriptFile) + " " + ScriptExec.quote(file));
                printer.println("exit");
            } else {
                printer.println("rm " + ScriptExec.quote(targetScriptFile) + " " + ScriptExec.quote(file));
            }
        });
    }

    private static File createGenericScript(String extension, BiConsumer<File, StringPrinter> client) throws IOException {
        File file = File.createTempFile("DiffPlugScript", extension);
        if (!OS.getNative().isWindows()) {
            file.setExecutable(true);
        }
        StringPrinter fullScript = new StringPrinter();
        client.accept(file, fullScript);
        return ScriptExec.writeFlushed(file, fullScript.toString().getBytes(StandardCharsets.UTF_8));
    }

    private static File writeFlushed(File file, byte[] content) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            output.write(content);
            output.flush();
            output.getFD().sync();
        }
        return file;
    }

    private static List<String> getPlatformCmds(File scriptFile, boolean isSeparate) throws IOException {
        if (OS.getNative().isWindows()) {
            return List.of("wscript.exe", ScriptExec.createInvisibleVbs(isSeparate).getAbsolutePath(), scriptFile.getAbsolutePath());
        }
        if (isSeparate) {
            File spawningScript = ScriptExec.createSelfDeletingScript("nohup " + ScriptExec.quote(scriptFile) + " &\n" + (ScriptExec.mavenWorkarounds() ? "sleep 5\n" : "") + "disown\n");
            return List.of("/bin/bash", spawningScript.getAbsolutePath());
        }
        return List.of("/bin/bash", scriptFile.getAbsolutePath());
    }

    private static File createInvisibleVbs(boolean isSeparate) throws IOException {
        return ScriptExec.createGenericScript(".vbs", (file, printer) -> {
            String windowStyle = "0";
            String waitOnReturn = isSeparate && !ScriptExec.mavenWorkarounds() ? "False" : "True";
            printer.println(String.format("CreateObject(\"Wscript.Shell\").Run \"\"\"\" & WScript.Arguments(0) & \"\"\"\", %s, %s", windowStyle, waitOnReturn));
            printer.println("CreateObject(\"Scripting.FileSystemObject\").DeleteFile(\"" + file.getAbsolutePath() + "\")");
        });
    }

    public static String quote(File file) {
        return ScriptExec.quote(file.getAbsolutePath());
    }

    public static String quote(String arg) {
        return arg.contains(" ") ? "\"" + arg + "\"" : arg;
    }

    private static String quoteObj(Object arg) {
        if (arg instanceof String) {
            return ScriptExec.quote((String)arg);
        }
        if (arg instanceof File) {
            return ScriptExec.quote((File)arg);
        }
        throw new IllegalArgumentException("Unexpected class " + arg.getClass());
    }

    public static String quoteAll(List<?> args) {
        StringBuilder completeArgs = new StringBuilder();
        if (args.size() == 0) {
            return "";
        }
        completeArgs.append(ScriptExec.quoteObj(args.get(0)));
        for (int i = 1; i < args.size(); ++i) {
            completeArgs.append(" ");
            completeArgs.append(ScriptExec.quoteObj(args.get(i)));
        }
        return completeArgs.toString();
    }

    private static class StringPrinter {
        final StringBuilder builder = new StringBuilder();

        private StringPrinter() {
        }

        void println(String line) {
            this.builder.append(line);
            this.builder.append('\n');
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

