/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Globals;

public class Errors {
    private static int numErrors = 0;
    private static int numWarnings = 0;

    public static int errorCount() {
        return numErrors;
    }

    public static int warningCount() {
        return numWarnings;
    }

    public static void setErrorCount(int i) {
        numErrors = i;
    }

    public static void setWarningCount(int i) {
        numWarnings = i;
    }

    public static void resetCounts() {
        numWarnings = 0;
        numErrors = 0;
    }

    public static void printSummary() {
        System.err.println(numWarnings + " warnings, " + numErrors + " errors.");
    }

    public static void warning(String s) {
        Errors.warning(s, -1);
    }

    public static void warning(String s, int lineNum) {
        if (lineNum == -1) {
            System.err.println(Globals.inFilename + ":  warning:  " + s);
        } else {
            System.err.println(Globals.inFilename + " (" + Integer.toString(lineNum) + "):  warning:  " + s);
        }
        ++numWarnings;
    }

    public static void softErr(String s) {
        Errors.softErr(s, -1);
    }

    public static void softErr(String s, int lineNum) {
        if (lineNum == -1) {
            System.err.println(Globals.inFilename + ":  soft error:  " + s);
        } else {
            System.err.println(Globals.inFilename + " (" + Integer.toString(lineNum) + "):  " + s);
        }
        ++numErrors;
    }

    public static void notice(String s) {
        System.err.println(Globals.inFilename + ":  " + s);
    }

    public static void hardErr(String s) {
        System.err.println(Globals.inFilename + ":  unexpected program error:  " + s);
        System.err.println();
        System.err.println("Please report this to wanjun@purdue.edu, vids@ucla.edu");
        System.err.println();
        try {
            throw new Exception();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
            System.exit(-1);
            return;
        }
    }

    public static void hardErr(Throwable t) {
        System.err.println(Globals.inFilename + ":  unexpected program error:  " + t.getMessage());
        System.err.println();
        System.err.println("Please report this to wanjun@purdue.edu, vids@ucla.edu");
        System.err.println();
        t.printStackTrace();
        System.exit(-1);
    }
}

