/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline.authorage;

import edu.usc.irds.agepredictor.cmdline.params.ClassifyTrainingToolParams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.authorage.AgeClassifyFactory;
import opennlp.tools.authorage.AgeClassifyME;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.authorage.AuthorAgeSample;
import opennlp.tools.cmdline.AbstractTrainerTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.ml.authorage.AgeClassifyTrainerFactory;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.BagOfWordsFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGenerator;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public class AgeClassifyTrainerTool
extends AbstractTrainerTool<AuthorAgeSample, ClassifyTrainingToolParams> {
    public AgeClassifyTrainerTool() {
        super(AuthorAgeSample.class, ClassifyTrainingToolParams.class);
    }

    public String getShortDescription() {
        return "trainer for the author age classifier";
    }

    public String getHelp(String format) {
        if ("".equals(format) || "opennlp".equals(format)) {
            return this.getBasicHelp(new Class[]{this.paramsClass, StreamFactoryRegistry.getFactory((Class)this.type, (String)"opennlp").getParameters()});
        }
        ObjectStreamFactory factory = StreamFactoryRegistry.getFactory((Class)this.type, (String)format);
        if (null == factory) {
            throw new TerminateToolException(1, "Format " + format + " is not found.\n" + this.getHelp());
        }
        return "Usage: bin/authorage " + this.getName() + " " + ArgumentParser.createUsage((Class[])new Class[]{this.paramsClass, factory.getParameters()});
    }

    public void run(String format, String[] args) {
        AgeClassifyModel model;
        super.run(format, args);
        TrainingParameters mlParams = null;
        String paramFile = ((ClassifyTrainingToolParams)this.params).getParams();
        if (paramFile != null) {
            CmdLineUtil.checkInputFile((String)"Training Parameter", (File)new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                mlParams = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!AgeClassifyTrainerFactory.isValid((Map)mlParams.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
        }
        if (mlParams == null) {
            mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        File modelOutFile = ((ClassifyTrainingToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile((String)"age classifier model", (File)modelOutFile);
        System.out.println("Feature Generators: " + ((ClassifyTrainingToolParams)this.params).getFeatureGenerators());
        FeatureGenerator[] featureGenerators = AgeClassifyTrainerTool.createFeatureGenerators(((ClassifyTrainingToolParams)this.params).getFeatureGenerators());
        System.out.println("Tokenizer: " + ((ClassifyTrainingToolParams)this.params).getTokenizer());
        Tokenizer tokenizer = AgeClassifyTrainerTool.createTokenizer(((ClassifyTrainingToolParams)this.params).getTokenizer());
        try {
            AgeClassifyFactory factory = AgeClassifyFactory.create((String)"AgeClassifyFactory", (Tokenizer)tokenizer, (FeatureGenerator[])featureGenerators);
            model = AgeClassifyME.train((String)((ClassifyTrainingToolParams)this.params).getLang(), (ObjectStream)this.sampleStream, (TrainingParameters)mlParams, (AgeClassifyFactory)factory);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel((String)"age classifier", (File)modelOutFile, (BaseModel)model);
    }

    private static Tokenizer createTokenizer(String tokenizer) {
        if (tokenizer != null) {
            return (Tokenizer)ExtensionLoader.instantiateExtension(Tokenizer.class, (String)tokenizer);
        }
        return WhitespaceTokenizer.INSTANCE;
    }

    private static FeatureGenerator[] createFeatureGenerators(String featureGeneratorsNames) {
        if (featureGeneratorsNames == null) {
            FeatureGenerator[] def = new FeatureGenerator[]{new BagOfWordsFeatureGenerator()};
            return def;
        }
        String[] classes = featureGeneratorsNames.split(",");
        FeatureGenerator[] featureGenerators = new FeatureGenerator[classes.length];
        for (int i = 0; i < featureGenerators.length; ++i) {
            featureGenerators[i] = (FeatureGenerator)ExtensionLoader.instantiateExtension(FeatureGenerator.class, (String)classes[i]);
        }
        return featureGenerators;
    }
}

